/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.apache.lucene.analysis.miscellaneous.Lucene43LengthFilter;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class LengthTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int min;
    private final int max;
    private final boolean enablePositionIncrements;
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    @Inject
    public LengthTokenFilterFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.min = settings.getAsInt("min", (Integer)0);
        this.max = settings.getAsInt("max", (Integer)Integer.MAX_VALUE);
        if (this.version.onOrAfter(Version.LUCENE_4_4) && settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain or use an older compatibility version (<=4.3) but beware that it might cause highlighting bugs.");
        }
        this.enablePositionIncrements = this.version.onOrAfter(Version.LUCENE_4_4) ? true : settings.getAsBoolean(ENABLE_POS_INC_KEY, (Boolean)true);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        if (this.version.onOrAfter(Version.LUCENE_4_4)) {
            return new LengthFilter(tokenStream, this.min, this.max);
        }
        Lucene43LengthFilter filter = new Lucene43LengthFilter(this.enablePositionIncrements, tokenStream, this.min, this.max);
        return filter;
    }
}

