/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.index.deletionpolicy.SnapshotIndexCommit;
import org.elasticsearch.index.engine.SnapshotFailedEngineException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRepository;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class SnapshotShardsService
extends AbstractLifecycleComponent<SnapshotShardsService>
implements ClusterStateListener {
    public static final String UPDATE_SNAPSHOT_ACTION_NAME = "internal:cluster/snapshot/update_snapshot";
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final SnapshotsService snapshotsService;
    private final TransportService transportService;
    private final ThreadPool threadPool;
    private final Lock shutdownLock = new ReentrantLock();
    private final Condition shutdownCondition = this.shutdownLock.newCondition();
    private volatile ImmutableMap<SnapshotId, SnapshotShards> shardSnapshots = ImmutableMap.of();
    private final BlockingQueue<UpdateIndexShardSnapshotStatusRequest> updatedSnapshotStateQueue = ConcurrentCollections.newBlockingQueue();

    @Inject
    public SnapshotShardsService(Settings settings, ClusterService clusterService, SnapshotsService snapshotsService, ThreadPool threadPool, TransportService transportService, IndicesService indicesService) {
        super(settings);
        this.indicesService = indicesService;
        this.snapshotsService = snapshotsService;
        this.transportService = transportService;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        if (DiscoveryNode.dataNode(settings)) {
            clusterService.addLast(this);
        }
        if (DiscoveryNode.masterNode(settings)) {
            transportService.registerRequestHandler(UPDATE_SNAPSHOT_ACTION_NAME, UpdateIndexShardSnapshotStatusRequest.class, "same", new UpdateSnapshotStateRequestHandler());
        }
    }

    @Override
    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        this.shutdownLock.lock();
        try {
            while (!this.shardSnapshots.isEmpty() && this.shutdownCondition.await(5L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.shutdownLock.unlock();
        }
    }

    @Override
    protected void doClose() {
        this.clusterService.remove(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        try {
            String masterNodeId;
            SnapshotsInProgress prev = (SnapshotsInProgress)event.previousState().custom("snapshots");
            SnapshotsInProgress curr = (SnapshotsInProgress)event.state().custom("snapshots");
            if (prev == null) {
                if (curr != null) {
                    this.processIndexShardSnapshots(event);
                }
            } else if (!prev.equals(curr)) {
                this.processIndexShardSnapshots(event);
            }
            if ((masterNodeId = event.state().nodes().masterNodeId()) != null && !masterNodeId.equals(event.previousState().nodes().masterNodeId())) {
                this.syncShardStatsOnNewMaster(event);
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to update snapshot state ", t, new Object[0]);
        }
    }

    public Map<ShardId, IndexShardSnapshotStatus> currentSnapshotShards(SnapshotId snapshotId) {
        SnapshotShards snapshotShards = (SnapshotShards)this.shardSnapshots.get((Object)snapshotId);
        if (snapshotShards == null) {
            return null;
        }
        return snapshotShards.shards;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIndexShardSnapshots(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        HashMap survivors = Maps.newHashMap();
        for (Map.Entry entry : this.shardSnapshots.entrySet()) {
            if (snapshotsInProgress == null || snapshotsInProgress.snapshot((SnapshotId)entry.getKey()) == null) continue;
            survivors.put(entry.getKey(), entry.getValue());
        }
        HashMap newSnapshots = Maps.newHashMap();
        final String localNodeId = this.clusterService.localNode().id();
        if (snapshotsInProgress != null) {
            for (SnapshotsInProgress.Entry entry : snapshotsInProgress.entries()) {
                SnapshotShards snapshotShards;
                if (entry.state() == SnapshotsInProgress.State.STARTED) {
                    HashMap startedShards = Maps.newHashMap();
                    SnapshotShards snapshotShards2 = (SnapshotShards)this.shardSnapshots.get((Object)entry.snapshotId());
                    for (Map.Entry shard : entry.shards().entrySet()) {
                        if (!localNodeId.equals(((SnapshotsInProgress.ShardSnapshotStatus)shard.getValue()).nodeId()) || ((SnapshotsInProgress.ShardSnapshotStatus)shard.getValue()).state() != SnapshotsInProgress.State.INIT || snapshotShards2 != null && snapshotShards2.shards.containsKey(shard.getKey())) continue;
                        this.logger.trace("[{}] - Adding shard to the queue", shard.getKey());
                        startedShards.put(shard.getKey(), new IndexShardSnapshotStatus());
                    }
                    if (startedShards.isEmpty()) continue;
                    newSnapshots.put(entry.snapshotId(), startedShards);
                    if (snapshotShards2 != null) {
                        ImmutableMap.Builder shards = ImmutableMap.builder();
                        shards.putAll(snapshotShards2.shards);
                        shards.putAll((Map)startedShards);
                        survivors.put(entry.snapshotId(), new SnapshotShards(shards.build()));
                        continue;
                    }
                    survivors.put(entry.snapshotId(), new SnapshotShards(ImmutableMap.copyOf((Map)startedShards)));
                    continue;
                }
                if (entry.state() != SnapshotsInProgress.State.ABORTED || (snapshotShards = (SnapshotShards)this.shardSnapshots.get((Object)entry.snapshotId())) == null) continue;
                block14: for (Map.Entry shard : entry.shards().entrySet()) {
                    IndexShardSnapshotStatus snapshotStatus = (IndexShardSnapshotStatus)snapshotShards.shards.get(shard.getKey());
                    if (snapshotStatus == null) continue;
                    switch (snapshotStatus.stage()) {
                        case INIT: 
                        case STARTED: {
                            snapshotStatus.abort();
                            continue block14;
                        }
                        case FINALIZE: {
                            this.logger.debug("[{}] trying to cancel snapshot on shard [{}] that is finalizing, letting it finish", entry.snapshotId(), shard.getKey());
                            continue block14;
                        }
                        case DONE: {
                            this.logger.debug("[{}] trying to cancel snapshot on the shard [{}] that is already done, updating status on the master", entry.snapshotId(), shard.getKey());
                            this.updateIndexShardSnapshotStatus(entry.snapshotId(), (ShardId)shard.getKey(), new SnapshotsInProgress.ShardSnapshotStatus(event.state().nodes().localNodeId(), SnapshotsInProgress.State.SUCCESS));
                            continue block14;
                        }
                        case FAILURE: {
                            this.logger.debug("[{}] trying to cancel snapshot on the shard [{}] that has already failed, updating status on the master", entry.snapshotId(), shard.getKey());
                            this.updateIndexShardSnapshotStatus(entry.snapshotId(), (ShardId)shard.getKey(), new SnapshotsInProgress.ShardSnapshotStatus(event.state().nodes().localNodeId(), SnapshotsInProgress.State.FAILED, snapshotStatus.failure()));
                            continue block14;
                        }
                    }
                    throw new IllegalStateException("Unknown snapshot shard stage " + (Object)((Object)snapshotStatus.stage()));
                }
            }
        }
        this.shutdownLock.lock();
        try {
            this.shardSnapshots = ImmutableMap.copyOf((Map)survivors);
            if (this.shardSnapshots.isEmpty()) {
                this.shutdownCondition.signalAll();
            }
        }
        finally {
            this.shutdownLock.unlock();
        }
        if (!newSnapshots.isEmpty()) {
            Executor executor = this.threadPool.executor("snapshot");
            for (final Map.Entry entry : newSnapshots.entrySet()) {
                for (final Map.Entry shardEntry : ((Map)entry.getValue()).entrySet()) {
                    final ShardId shardId = (ShardId)shardEntry.getKey();
                    try {
                        final IndexShard indexShard = this.indicesService.indexServiceSafe(shardId.getIndex()).shard(shardId.id());
                        executor.execute(new AbstractRunnable(){

                            @Override
                            public void doRun() {
                                SnapshotShardsService.this.snapshot(indexShard, (SnapshotId)entry.getKey(), (IndexShardSnapshotStatus)shardEntry.getValue());
                                SnapshotShardsService.this.updateIndexShardSnapshotStatus((SnapshotId)entry.getKey(), shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.SUCCESS));
                            }

                            @Override
                            public void onFailure(Throwable t) {
                                SnapshotShardsService.this.logger.warn("[{}] [{}] failed to create snapshot", t, shardId, entry.getKey());
                                SnapshotShardsService.this.updateIndexShardSnapshotStatus((SnapshotId)entry.getKey(), shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.FAILED, ExceptionsHelper.detailedMessage(t)));
                            }
                        });
                    }
                    catch (Throwable t) {
                        this.updateIndexShardSnapshotStatus((SnapshotId)entry.getKey(), shardId, new SnapshotsInProgress.ShardSnapshotStatus(localNodeId, SnapshotsInProgress.State.FAILED, ExceptionsHelper.detailedMessage(t)));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapshot(IndexShard indexShard, SnapshotId snapshotId, IndexShardSnapshotStatus snapshotStatus) {
        IndexShardRepository indexShardRepository = this.snapshotsService.getRepositoriesService().indexShardRepository(snapshotId.getRepository());
        ShardId shardId = indexShard.shardId();
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardSnapshotFailedException(shardId, "snapshot should be performed only on primary");
        }
        if (indexShard.routingEntry().relocating()) {
            throw new IndexShardSnapshotFailedException(shardId, "cannot snapshot while relocating");
        }
        if (indexShard.state() == IndexShardState.CREATED || indexShard.state() == IndexShardState.RECOVERING) {
            throw new IndexShardSnapshotFailedException(shardId, "shard didn't fully recover yet");
        }
        try (SnapshotIndexCommit snapshotIndexCommit = indexShard.snapshotIndex(true);){
            indexShardRepository.snapshot(snapshotId, shardId, snapshotIndexCommit, snapshotStatus);
            if (this.logger.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("snapshot (").append(snapshotId.getSnapshot()).append(") completed to ").append(indexShardRepository).append(", took [").append(TimeValue.timeValueMillis(snapshotStatus.time())).append("]\n");
                sb.append("    index    : version [").append(snapshotStatus.indexVersion()).append("], number_of_files [").append(snapshotStatus.numberOfFiles()).append("] with total_size [").append(new ByteSizeValue(snapshotStatus.totalSize())).append("]\n");
                this.logger.debug(sb.toString(), new Object[0]);
            }
        }
        catch (SnapshotFailedEngineException e) {
            throw e;
        }
        catch (IndexShardSnapshotFailedException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new IndexShardSnapshotFailedException(shardId, "Failed to snapshot", e);
        }
    }

    private void syncShardStatsOnNewMaster(ClusterChangedEvent event) {
        SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)event.state().custom("snapshots");
        if (snapshotsInProgress == null) {
            return;
        }
        for (SnapshotsInProgress.Entry snapshot : snapshotsInProgress.entries()) {
            Map<ShardId, IndexShardSnapshotStatus> localShards;
            if (snapshot.state() != SnapshotsInProgress.State.STARTED && snapshot.state() != SnapshotsInProgress.State.ABORTED || (localShards = this.currentSnapshotShards(snapshot.snapshotId())) == null) continue;
            ImmutableMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus> masterShards = snapshot.shards();
            for (Map.Entry<ShardId, IndexShardSnapshotStatus> localShard : localShards.entrySet()) {
                ShardId shardId = localShard.getKey();
                IndexShardSnapshotStatus localShardStatus = localShard.getValue();
                SnapshotsInProgress.ShardSnapshotStatus masterShard = (SnapshotsInProgress.ShardSnapshotStatus)masterShards.get((Object)shardId);
                if (masterShard == null || masterShard.state().completed()) continue;
                if (localShardStatus.stage() == IndexShardSnapshotStatus.Stage.DONE) {
                    this.logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard is done locally, updating status on the master", snapshot.snapshotId(), shardId);
                    this.updateIndexShardSnapshotStatus(snapshot.snapshotId(), shardId, new SnapshotsInProgress.ShardSnapshotStatus(event.state().nodes().localNodeId(), SnapshotsInProgress.State.SUCCESS));
                    continue;
                }
                if (localShard.getValue().stage() != IndexShardSnapshotStatus.Stage.FAILURE) continue;
                this.logger.debug("[{}] new master thinks the shard [{}] is not completed but the shard failed locally, updating status on master", snapshot.snapshotId(), shardId);
                this.updateIndexShardSnapshotStatus(snapshot.snapshotId(), shardId, new SnapshotsInProgress.ShardSnapshotStatus(event.state().nodes().localNodeId(), SnapshotsInProgress.State.FAILED, localShardStatus.failure()));
            }
        }
    }

    public void updateIndexShardSnapshotStatus(SnapshotId snapshotId, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
        UpdateIndexShardSnapshotStatusRequest request = new UpdateIndexShardSnapshotStatusRequest(snapshotId, shardId, status);
        try {
            if (this.clusterService.state().nodes().localNodeMaster()) {
                this.innerUpdateSnapshotState(request);
            } else {
                this.transportService.sendRequest(this.clusterService.state().nodes().masterNode(), UPDATE_SNAPSHOT_ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
            }
        }
        catch (Throwable t) {
            this.logger.warn("[{}] [{}] failed to update snapshot state", t, request.snapshotId(), request.status());
        }
    }

    private void innerUpdateSnapshotState(final UpdateIndexShardSnapshotStatusRequest request) {
        this.logger.trace("received updated snapshot restore state [{}]", request);
        this.updatedSnapshotStateQueue.add(request);
        this.clusterService.submitStateUpdateTask("update snapshot state", new ClusterStateUpdateTask(){
            private final List<UpdateIndexShardSnapshotStatusRequest> drainedRequests = new ArrayList<UpdateIndexShardSnapshotStatusRequest>();

            @Override
            public ClusterState execute(ClusterState currentState) {
                if (request.isProcessed()) {
                    return currentState;
                }
                SnapshotShardsService.this.updatedSnapshotStateQueue.drainTo(this.drainedRequests);
                int batchSize = this.drainedRequests.size();
                if (batchSize == 0) {
                    return currentState;
                }
                SnapshotsInProgress snapshots = (SnapshotsInProgress)currentState.custom("snapshots");
                if (snapshots != null) {
                    int changedCount = 0;
                    ArrayList<SnapshotsInProgress.Entry> entries = new ArrayList<SnapshotsInProgress.Entry>();
                    for (SnapshotsInProgress.Entry entry : snapshots.entries()) {
                        HashMap shards = Maps.newHashMap();
                        boolean updated = false;
                        for (int i = 0; i < batchSize; ++i) {
                            UpdateIndexShardSnapshotStatusRequest updateSnapshotState = this.drainedRequests.get(i);
                            updateSnapshotState.markAsProcessed();
                            if (!entry.snapshotId().equals(updateSnapshotState.snapshotId())) continue;
                            SnapshotShardsService.this.logger.trace("[{}] Updating shard [{}] with status [{}]", new Object[]{updateSnapshotState.snapshotId(), updateSnapshotState.shardId(), updateSnapshotState.status().state()});
                            if (!updated) {
                                shards.putAll(entry.shards());
                                updated = true;
                            }
                            shards.put(updateSnapshotState.shardId(), updateSnapshotState.status());
                            ++changedCount;
                        }
                        if (updated) {
                            if (!SnapshotsInProgress.completed(shards.values())) {
                                entries.add(new SnapshotsInProgress.Entry(entry, (ImmutableMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>)ImmutableMap.copyOf((Map)shards)));
                                continue;
                            }
                            SnapshotsInProgress.Entry updatedEntry = new SnapshotsInProgress.Entry(entry, SnapshotsInProgress.State.SUCCESS, (ImmutableMap<ShardId, SnapshotsInProgress.ShardSnapshotStatus>)ImmutableMap.copyOf((Map)shards));
                            entries.add(updatedEntry);
                            SnapshotShardsService.this.snapshotsService.endSnapshot(updatedEntry);
                            SnapshotShardsService.this.logger.info("snapshot [{}] is done", updatedEntry.snapshotId());
                            continue;
                        }
                        entries.add(entry);
                    }
                    if (changedCount > 0) {
                        SnapshotShardsService.this.logger.trace("changed cluster state triggered by {} snapshot state updates", changedCount);
                        SnapshotsInProgress updatedSnapshots = new SnapshotsInProgress(entries.toArray(new SnapshotsInProgress.Entry[entries.size()]));
                        return ClusterState.builder(currentState).putCustom("snapshots", updatedSnapshots).build();
                    }
                }
                return currentState;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                for (UpdateIndexShardSnapshotStatusRequest request2 : this.drainedRequests) {
                    SnapshotShardsService.this.logger.warn("[{}][{}] failed to update snapshot status to [{}]", t, request2.snapshotId(), request2.shardId(), request2.status());
                }
            }
        });
    }

    class UpdateSnapshotStateRequestHandler
    implements TransportRequestHandler<UpdateIndexShardSnapshotStatusRequest> {
        UpdateSnapshotStateRequestHandler() {
        }

        @Override
        public void messageReceived(UpdateIndexShardSnapshotStatusRequest request, TransportChannel channel) throws Exception {
            SnapshotShardsService.this.innerUpdateSnapshotState(request);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    private static class UpdateIndexShardSnapshotStatusRequest
    extends TransportRequest {
        private SnapshotId snapshotId;
        private ShardId shardId;
        private SnapshotsInProgress.ShardSnapshotStatus status;
        private volatile boolean processed;

        public UpdateIndexShardSnapshotStatusRequest() {
        }

        public UpdateIndexShardSnapshotStatusRequest(SnapshotId snapshotId, ShardId shardId, SnapshotsInProgress.ShardSnapshotStatus status) {
            this.snapshotId = snapshotId;
            this.shardId = shardId;
            this.status = status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.snapshotId = SnapshotId.readSnapshotId(in);
            this.shardId = ShardId.readShardId(in);
            this.status = SnapshotsInProgress.ShardSnapshotStatus.readShardSnapshotStatus(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
            this.status.writeTo(out);
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public SnapshotsInProgress.ShardSnapshotStatus status() {
            return this.status;
        }

        public String toString() {
            return "" + this.snapshotId + ", shardId [" + this.shardId + "], status [" + (Object)((Object)this.status.state()) + "]";
        }

        public void markAsProcessed() {
            this.processed = true;
        }

        public boolean isProcessed() {
            return this.processed;
        }
    }

    private static class SnapshotShards {
        private final Map<ShardId, IndexShardSnapshotStatus> shards;

        private SnapshotShards(ImmutableMap<ShardId, IndexShardSnapshotStatus> shards) {
            this.shards = shards;
        }
    }
}

