/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.protocol;

import java.util.UUID;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.protocol.RouteAvailableMessage;

public abstract class ParticipantAvailable
extends Message
implements RouteAvailableMessage {
    private final String channelKey;
    private final UUID id;
    private final String displayName;

    public ParticipantAvailable(UUID id, String displayName, String channelKey) {
        this.id = id;
        this.displayName = displayName;
        this.channelKey = channelKey;
    }

    public UUID getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getChannelKey() {
        return this.channelKey;
    }

    public Object getSource() {
        return this.id;
    }

    public String toString() {
        return String.format("[%s id: %s, displayName: %s, channel: %s]", this.getClass().getSimpleName(), this.id, this.displayName, this.channelKey);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ParticipantAvailable other = (ParticipantAvailable)o;
        return this.id.equals(other.id) && this.displayName.equals(other.displayName) && this.channelKey.equals(other.channelKey);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.displayName.hashCode() ^ this.channelKey.hashCode();
    }
}

