/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr.internal.antlr2;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.gradle.api.plugins.antlr.internal.antlr2.GenerationPlan;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarFileMetadata;
import org.gradle.api.plugins.antlr.internal.antlr2.GrammarMetadata;
import org.gradle.api.plugins.antlr.internal.antlr2.XRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerationPlanBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenerationPlanBuilder.class);
    private final LinkedHashMap<String, GenerationPlan> generationPlans = new LinkedHashMap();
    private final File outputDirectory;
    private XRef metadataXRef;

    public GenerationPlanBuilder(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public synchronized List<GenerationPlan> buildGenerationPlans(XRef metadataXRef) {
        this.metadataXRef = metadataXRef;
        Iterator<GrammarFileMetadata> grammarFiles = metadataXRef.iterateGrammarFiles();
        while (grammarFiles.hasNext()) {
            GrammarFileMetadata grammarFileMetadata = grammarFiles.next();
            this.locateOrBuildGenerationPlan(grammarFileMetadata);
        }
        return new ArrayList<GenerationPlan>(this.generationPlans.values());
    }

    private GenerationPlan locateOrBuildGenerationPlan(GrammarFileMetadata grammarFileMetadata) {
        GenerationPlan generationPlan = this.generationPlans.get(grammarFileMetadata.getFilePath().getPath());
        if (generationPlan == null) {
            generationPlan = this.buildGenerationPlan(grammarFileMetadata);
        }
        return generationPlan;
    }

    private GenerationPlan buildGenerationPlan(GrammarFileMetadata grammarFileMetadata) {
        File generationDirectory = this.isEmpty(grammarFileMetadata.getPackageName()) ? this.outputDirectory : new File(this.outputDirectory, grammarFileMetadata.getPackageName().replace('.', File.separatorChar));
        GenerationPlan generationPlan = new GenerationPlan(grammarFileMetadata.getFilePath(), generationDirectory);
        for (GrammarMetadata grammarMetadata : grammarFileMetadata.getGrammars()) {
            GrammarFileMetadata superGrammarGrammarFileMetadata;
            File generatedParserFile = new File(this.outputDirectory, grammarMetadata.determineGeneratedParserPath());
            if (!generatedParserFile.exists()) {
                generationPlan.markOutOfDate();
            } else if (generatedParserFile.lastModified() < generationPlan.getSource().lastModified()) {
                generationPlan.markOutOfDate();
            }
            if (!grammarMetadata.extendsStandardGrammar() && (superGrammarGrammarFileMetadata = grammarMetadata.getSuperGrammarDelegate().getAssociatedGrammarMetadata().getGrammarFile()) != null) {
                GenerationPlan superGrammarGenerationPlan = this.locateOrBuildGenerationPlan(superGrammarGrammarFileMetadata);
                if (superGrammarGenerationPlan.isOutOfDate()) {
                    generationPlan.markOutOfDate();
                } else if (superGrammarGenerationPlan.getSource().lastModified() > generatedParserFile.lastModified()) {
                    generationPlan.markOutOfDate();
                }
            }
            if (!this.isNotEmpty(grammarMetadata.getImportVocab())) continue;
            GrammarFileMetadata importVocabGrammarFileMetadata = this.metadataXRef.getGrammarFileByExportVocab(grammarMetadata.getImportVocab());
            if (importVocabGrammarFileMetadata == null) {
                LOGGER.warn("unable to locate grammar exporting specified import vocab [" + grammarMetadata.getImportVocab() + "]");
                continue;
            }
            if (importVocabGrammarFileMetadata.getFilePath().equals(grammarFileMetadata.getFilePath())) continue;
            GenerationPlan importVocabGrammarGenerationPlan = this.locateOrBuildGenerationPlan(importVocabGrammarFileMetadata);
            generationPlan.setImportVocabTokenTypesDirectory(importVocabGrammarGenerationPlan.getGenerationDirectory());
            if (importVocabGrammarGenerationPlan.isOutOfDate()) {
                generationPlan.markOutOfDate();
                continue;
            }
            if (importVocabGrammarGenerationPlan.getSource().lastModified() <= generatedParserFile.lastModified()) continue;
            generationPlan.markOutOfDate();
        }
        this.generationPlans.put(generationPlan.getId(), generationPlan);
        return generationPlan;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    private boolean isNotEmpty(String string) {
        return !this.isEmpty(string);
    }
}

