/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.engine.memory;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.engine.behavior.ICacheElement;
import org.apache.commons.jcs.engine.control.CompositeCache;
import org.apache.commons.jcs.engine.control.group.GroupAttrName;
import org.apache.commons.jcs.engine.memory.AbstractMemoryCache;
import org.apache.commons.jcs.engine.memory.util.MemoryElementDescriptor;
import org.apache.commons.jcs.engine.stats.StatElement;
import org.apache.commons.jcs.engine.stats.Stats;
import org.apache.commons.jcs.engine.stats.behavior.IStats;
import org.apache.commons.jcs.utils.struct.DoubleLinkedList;
import org.apache.commons.jcs.utils.struct.DoubleLinkedListNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDoubleLinkedListMemoryCache<K, V>
extends AbstractMemoryCache<K, V> {
    private static final Log log = LogFactory.getLog(AbstractDoubleLinkedListMemoryCache.class);
    protected DoubleLinkedList<MemoryElementDescriptor<K, V>> list;
    private volatile int hitCnt = 0;
    private volatile int missCnt = 0;
    private volatile int putCnt = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(CompositeCache<K, V> compositeCache) {
        this.lock.lock();
        try {
            super.initialize(compositeCache);
            this.list = new DoubleLinkedList();
            log.info("initialized MemoryCache for " + this.cacheName);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Map<K, MemoryElementDescriptor<K, V>> createMap() {
        return new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void update(ICacheElement<K, V> iCacheElement) throws IOException {
        this.lock.lock();
        try {
            ++this.putCnt;
            MemoryElementDescriptor<K, V> memoryElementDescriptor = this.adjustListForUpdate(iCacheElement);
            MemoryElementDescriptor<K, V> memoryElementDescriptor2 = this.map.put(memoryElementDescriptor.ce.getKey(), memoryElementDescriptor);
            if (memoryElementDescriptor2 != null && memoryElementDescriptor.ce.getKey().equals(memoryElementDescriptor2.ce.getKey())) {
                this.list.remove(memoryElementDescriptor2);
            }
        }
        finally {
            this.lock.unlock();
        }
        this.spoolIfNeeded();
    }

    protected abstract MemoryElementDescriptor<K, V> adjustListForUpdate(ICacheElement<K, V> var1) throws IOException;

    private void spoolIfNeeded() throws Error {
        int n = this.map.size();
        if (n <= this.cacheAttributes.getMaxObjects()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("In memory limit reached, spooling");
        }
        int n2 = Math.min(n, this.chunkSize);
        if (log.isDebugEnabled()) {
            log.debug("About to spool to disk cache, map size: " + n + ", max objects: " + this.cacheAttributes.getMaxObjects() + ", items to spool: " + n2);
        }
        for (int i = 0; i < n2; ++i) {
            this.spoolLastElement();
        }
        if (log.isDebugEnabled()) {
            log.debug("update: After spool map size: " + this.map.size() + " linked list size = " + this.dumpCacheSize());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ICacheElement<K, V> get(K k) throws IOException {
        MemoryElementDescriptor memoryElementDescriptor;
        ICacheElement iCacheElement = null;
        boolean bl = log.isDebugEnabled();
        if (bl) {
            log.debug("getting item from cache " + this.cacheName + " for key " + k);
        }
        if ((memoryElementDescriptor = (MemoryElementDescriptor)this.map.get(k)) != null) {
            this.lock.lock();
            try {
                iCacheElement = memoryElementDescriptor.ce;
                ++this.hitCnt;
                this.adjustListForGet(memoryElementDescriptor);
            }
            finally {
                this.lock.unlock();
            }
            if (bl) {
                log.debug(this.cacheName + ": LRUMemoryCache hit for " + iCacheElement.getKey());
            }
        } else {
            this.lock.lock();
            try {
                ++this.missCnt;
            }
            finally {
                this.lock.unlock();
            }
            if (bl) {
                log.debug(this.cacheName + ": LRUMemoryCache miss for " + k);
            }
        }
        this.verifyCache();
        return iCacheElement;
    }

    protected abstract void adjustListForGet(MemoryElementDescriptor<K, V> var1);

    @Override
    public int freeElements(int n) throws IOException {
        ICacheElement<K, V> iCacheElement;
        int n2;
        for (n2 = 0; n2 < n && (iCacheElement = this.spoolLastElement()) != null; ++n2) {
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICacheElement<K, V> spoolLastElement() throws Error {
        ICacheElement iCacheElement = null;
        MemoryElementDescriptor<K, V> memoryElementDescriptor = this.list.getLast();
        if (memoryElementDescriptor != null) {
            this.lock.lock();
            try {
                iCacheElement = memoryElementDescriptor.ce;
                if (iCacheElement != null) {
                    this.cache.spoolToDisk(memoryElementDescriptor.ce);
                    if (this.map.remove(memoryElementDescriptor.ce.getKey()) == null) {
                        log.warn("update: remove failed for key: " + memoryElementDescriptor.ce.getKey());
                        this.verifyCache();
                    }
                } else {
                    throw new Error("update: last.ce is null!");
                }
                this.list.remove(memoryElementDescriptor);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            this.verifyCache();
            throw new Error("update: last is null!");
        }
        if (this.map.size() != this.dumpCacheSize()) {
            log.warn("update: After spool, size mismatch: map.size() = " + this.map.size() + ", linked list size = " + this.dumpCacheSize());
        }
        return iCacheElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean remove(K k) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("removing item for key: " + k);
        }
        boolean bl = false;
        if (k instanceof String && ((String)k).endsWith(":")) {
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k2 = entry.getKey();
                if (!(k2 instanceof String) || !((String)k2).startsWith(k.toString())) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    iterator.remove();
                    bl = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return bl;
        } else if (k instanceof GroupAttrName && ((GroupAttrName)k).attrName == null) {
            Iterator iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object k3 = entry.getKey();
                if (!(k3 instanceof GroupAttrName) || !((GroupAttrName)k3).groupId.equals(((GroupAttrName)k).groupId)) continue;
                this.lock.lock();
                try {
                    this.list.remove((MemoryElementDescriptor<K, V>)((DoubleLinkedListNode)entry.getValue()));
                    iterator.remove();
                    bl = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            return bl;
        } else {
            this.lock.lock();
            try {
                MemoryElementDescriptor memoryElementDescriptor = (MemoryElementDescriptor)this.map.remove(k);
                if (memoryElementDescriptor == null) return bl;
                this.list.remove(memoryElementDescriptor);
                bl = true;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() throws IOException {
        this.lock.lock();
        try {
            this.list.removeAll();
            this.map.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addFirst(ICacheElement<K, V> iCacheElement) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> memoryElementDescriptor = new MemoryElementDescriptor<K, V>(iCacheElement);
            this.list.addFirst(memoryElementDescriptor);
            this.verifyCache(iCacheElement.getKey());
            MemoryElementDescriptor<K, V> memoryElementDescriptor2 = memoryElementDescriptor;
            return memoryElementDescriptor2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MemoryElementDescriptor<K, V> addLast(ICacheElement<K, V> iCacheElement) {
        this.lock.lock();
        try {
            MemoryElementDescriptor<K, V> memoryElementDescriptor = new MemoryElementDescriptor<K, V>(iCacheElement);
            this.list.addLast(memoryElementDescriptor);
            this.verifyCache(iCacheElement.getKey());
            MemoryElementDescriptor<K, V> memoryElementDescriptor2 = memoryElementDescriptor;
            return memoryElementDescriptor2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void dumpCacheEntries() {
        log.debug("dumpingCacheEntries");
        MemoryElementDescriptor memoryElementDescriptor = this.list.getFirst();
        while (memoryElementDescriptor != null) {
            log.debug("dumpCacheEntries> key=" + memoryElementDescriptor.ce.getKey() + ", val=" + memoryElementDescriptor.ce.getVal());
            memoryElementDescriptor = (MemoryElementDescriptor)memoryElementDescriptor.next;
        }
    }

    protected int dumpCacheSize() {
        return this.list.size();
    }

    protected void verifyCache() {
        Serializable serializable;
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean bl = false;
        log.debug("verifycache[" + this.cacheName + "]: mapContains " + this.map.size() + " elements, linked list contains " + this.dumpCacheSize() + " elements");
        log.debug("verifycache: checking linked list by key ");
        Object object = this.list.getFirst();
        while (object != null) {
            Object object2 = ((MemoryElementDescriptor)object).ce.getKey();
            if (!this.map.containsKey(object2)) {
                log.error("verifycache[" + this.cacheName + "]: map does not contain key : " + ((MemoryElementDescriptor)object).ce.getKey());
                log.error("li.hashcode=" + ((MemoryElementDescriptor)object).ce.getKey().hashCode());
                log.error("key class=" + object2.getClass());
                log.error("key hashcode=" + object2.hashCode());
                log.error("key toString=" + object2.toString());
                if (object2 instanceof GroupAttrName) {
                    serializable = (GroupAttrName)object2;
                    log.error("GroupID hashcode=" + ((GroupAttrName)serializable).groupId.hashCode());
                    log.error("GroupID.class=" + ((GroupAttrName)serializable).groupId.getClass());
                    log.error("AttrName hashcode=" + ((GroupAttrName)serializable).attrName.hashCode());
                    log.error("AttrName.class=" + ((GroupAttrName)serializable).attrName.getClass());
                }
                this.dumpMap();
            } else if (this.map.get(((MemoryElementDescriptor)object).ce.getKey()) == null) {
                log.error("verifycache[" + this.cacheName + "]: linked list retrieval returned null for key: " + ((MemoryElementDescriptor)object).ce.getKey());
            }
            object = (MemoryElementDescriptor)((MemoryElementDescriptor)object).next;
        }
        log.debug("verifycache: checking linked list by value ");
        object = this.list.getFirst();
        while (object != null) {
            if (!this.map.containsValue(object)) {
                log.error("verifycache[" + this.cacheName + "]: map does not contain value : " + object);
                this.dumpMap();
            }
            object = (MemoryElementDescriptor)((MemoryElementDescriptor)object).next;
        }
        log.debug("verifycache: checking via keysets!");
        for (Object object2 : this.map.keySet()) {
            bl = false;
            serializable = this.list.getFirst();
            while (serializable != null) {
                if (object2.equals(serializable.ce.getKey())) {
                    bl = true;
                    break;
                }
                serializable = (MemoryElementDescriptor)serializable.next;
            }
            if (bl) continue;
            log.error("verifycache[" + this.cacheName + "]: key not found in list : " + object2);
            this.dumpCacheEntries();
            if (this.map.containsKey(object2)) {
                log.error("verifycache: map contains key");
                continue;
            }
            log.error("verifycache: map does NOT contain key, what the HECK!");
        }
    }

    private void verifyCache(K k) {
        if (!log.isDebugEnabled()) {
            return;
        }
        boolean bl = false;
        MemoryElementDescriptor memoryElementDescriptor = this.list.getFirst();
        while (memoryElementDescriptor != null) {
            if (memoryElementDescriptor.ce.getKey() == k) {
                bl = true;
                log.debug("verifycache(key) key match: " + k);
                break;
            }
            memoryElementDescriptor = (MemoryElementDescriptor)memoryElementDescriptor.next;
        }
        if (!bl) {
            log.error("verifycache(key)[" + this.cacheName + "], couldn't find key! : " + k);
        }
    }

    @Override
    public Set<K> getKeySet() {
        return new LinkedHashSet(this.map.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IStats getStatistics() {
        Stats stats = new Stats();
        stats.setTypeName("Memory Cache");
        ArrayList arrayList = new ArrayList();
        this.lock.lock();
        try {
            arrayList.add(new StatElement<Integer>("List Size", this.list.size()));
            arrayList.add(new StatElement<Integer>("Map Size", this.map.size()));
            arrayList.add(new StatElement<Integer>("Put Count", this.putCnt));
            arrayList.add(new StatElement<Integer>("Hit Count", this.hitCnt));
            arrayList.add(new StatElement<Integer>("Miss Count", this.missCnt));
        }
        finally {
            this.lock.unlock();
        }
        stats.setStatElements(arrayList);
        return stats;
    }

    public static class MapEntryWrapper<K extends Serializable, V extends Serializable>
    implements Map.Entry<K, ICacheElement<K, V>> {
        private final Map.Entry<K, MemoryElementDescriptor<K, V>> e;

        private MapEntryWrapper(Map.Entry<K, MemoryElementDescriptor<K, V>> entry) {
            this.e = entry;
        }

        @Override
        public boolean equals(Object object) {
            return this.e.equals(object);
        }

        @Override
        public K getKey() {
            return (K)((Serializable)this.e.getKey());
        }

        @Override
        public ICacheElement<K, V> getValue() {
            return this.e.getValue().ce;
        }

        @Override
        public int hashCode() {
            return this.e.hashCode();
        }

        @Override
        public ICacheElement<K, V> setValue(ICacheElement<K, V> iCacheElement) {
            throw new UnsupportedOperationException("Use normal cache methods to alter the contents of the cache.");
        }
    }

    public static class IteratorWrapper<K extends Serializable, V extends Serializable>
    implements Iterator<Map.Entry<K, MemoryElementDescriptor<K, V>>> {
        private final Iterator<Map.Entry<K, MemoryElementDescriptor<K, V>>> i;

        protected IteratorWrapper(Map<K, MemoryElementDescriptor<K, V>> map) {
            this.i = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        @Override
        public Map.Entry<K, MemoryElementDescriptor<K, V>> next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            this.i.remove();
        }

        public boolean equals(Object object) {
            return this.i.equals(object);
        }

        public int hashCode() {
            return this.i.hashCode();
        }
    }
}

