/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.routines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.validation.routines.AbstractValidator;
import org.openstreetmap.josm.data.validation.routines.DomainValidator;
import org.openstreetmap.josm.data.validation.routines.InetAddressValidator;
import org.openstreetmap.josm.tools.I18n;

public class EmailValidator
extends AbstractValidator {
    private static final String SPECIAL_CHARS = "\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]";
    private static final String VALID_CHARS = "[^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]";
    private static final String QUOTED_USER = "(\"[^\"]*\")";
    private static final String WORD = "(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))";
    private static final String LEGAL_ASCII_REGEX = "^\\p{ASCII}+$";
    private static final String EMAIL_REGEX = "^\\s*?(.+)@(.+?)\\s*$";
    private static final String IP_DOMAIN_REGEX = "^\\[(.*)\\]$";
    private static final String USER_REGEX = "^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$";
    private static final Pattern MATCH_ASCII_PATTERN = Pattern.compile("^\\p{ASCII}+$");
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^\\s*?(.+)@(.+?)\\s*$");
    private static final Pattern IP_DOMAIN_PATTERN = Pattern.compile("^\\[(.*)\\]$");
    private static final Pattern USER_PATTERN = Pattern.compile("^\\s*(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\"))(\\.(([^\\s\\p{Cntrl}\\(\\)<>@,;:'\\\\\\\"\\.\\[\\]]|')+|(\"[^\"]*\")))*$");
    private final boolean allowLocal;
    private static final EmailValidator EMAIL_VALIDATOR = new EmailValidator(false);
    private static final EmailValidator EMAIL_VALIDATOR_WITH_LOCAL = new EmailValidator(true);

    public static EmailValidator getInstance() {
        return EMAIL_VALIDATOR;
    }

    public static EmailValidator getInstance(boolean bl) {
        if (bl) {
            return EMAIL_VALIDATOR_WITH_LOCAL;
        }
        return EMAIL_VALIDATOR;
    }

    protected EmailValidator(boolean bl) {
        this.allowLocal = bl;
    }

    @Override
    public boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = MATCH_ASCII_PATTERN.matcher(string);
        if (!matcher.matches()) {
            this.setErrorMessage(I18n.tr("E-mail address contains non-ascii characters", new Object[0]));
            this.setFix(string.replaceAll("[^\\p{ASCII}]+", ""));
            return false;
        }
        Matcher matcher2 = EMAIL_PATTERN.matcher(string);
        if (!matcher2.matches()) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        if (string.endsWith(".")) {
            this.setErrorMessage(I18n.tr("E-mail address is invalid", new Object[0]));
            return false;
        }
        String string2 = matcher2.group(1);
        if (!this.isValidUser(string2)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid username: {0}", string2));
            return false;
        }
        String string3 = matcher2.group(2);
        if (!this.isValidDomain(string3)) {
            this.setErrorMessage(I18n.tr("E-mail address contains an invalid domain: {0}", string3));
            return false;
        }
        return true;
    }

    protected boolean isValidDomain(String string) {
        Matcher matcher = IP_DOMAIN_PATTERN.matcher(string);
        if (matcher.matches()) {
            InetAddressValidator inetAddressValidator = InetAddressValidator.getInstance();
            return inetAddressValidator.isValid(matcher.group(1));
        }
        DomainValidator domainValidator = DomainValidator.getInstance(this.allowLocal);
        return domainValidator.isValid(string) || domainValidator.isValidTld(string);
    }

    protected boolean isValidUser(String string) {
        return USER_PATTERN.matcher(string).matches();
    }
}

