/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import org.openstreetmap.gui.jmapviewer.AttributionSupport;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.CachedTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.RenameLayerAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.WMSLayerImporter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public abstract class AbstractTileSourceLayer
extends ImageryLayer
implements ImageObserver,
TileLoaderListener,
NavigatableComponent.ZoomChangeListener {
    private static final String PREFERENCE_PREFIX = "imagery.generic";
    public static final int MAX_ZOOM = 30;
    public static final int MIN_ZOOM = 2;
    private static final Font InfoFont = new Font("sansserif", 1, 13);
    public static final BooleanProperty PROP_DEFAULT_AUTOZOOM = new BooleanProperty("imagery.generic.default_autozoom", true);
    public static final BooleanProperty PROP_DEFAULT_AUTOLOAD = new BooleanProperty("imagery.generic.default_autoload", true);
    public static final BooleanProperty PROP_DEFAULT_SHOWERRORS = new BooleanProperty("imagery.generic.default_showerrors", true);
    public static final IntegerProperty PROP_MIN_ZOOM_LVL = new IntegerProperty("imagery.generic.min_zoom_lvl", 2);
    public static final IntegerProperty PROP_MAX_ZOOM_LVL = new IntegerProperty("imagery.generic.max_zoom_lvl", 20);
    public int currentZoomLevel;
    private boolean needRedraw;
    private AttributionSupport attribution = new AttributionSupport();
    public boolean autoZoom;
    public boolean autoLoad;
    public boolean showErrors;
    public static final IntegerProperty ZOOM_OFFSET = new IntegerProperty("imagery.generic.zoom_offset", 0);
    protected TileCache tileCache;
    protected AbstractTMSTileSource tileSource;
    protected TileLoader tileLoader;
    private final TileSet nullTileSet = new TileSet((LatLon)null, (LatLon)null, 0);

    public AbstractTileSourceLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.setBackgroundLayer(true);
        this.setVisible(true);
        MapView.addZoomChangeListener(this);
    }

    protected abstract TileLoaderFactory getTileLoaderFactory();

    protected abstract AbstractTMSTileSource getTileSource(ImageryInfo var1) throws IllegalArgumentException;

    protected Map<String, String> getHeaders(TileSource tileSource) {
        if (tileSource instanceof TemplatedTileSource) {
            return ((TemplatedTileSource)tileSource).getHeaders();
        }
        return null;
    }

    protected void initTileSource(AbstractTMSTileSource abstractTMSTileSource) {
        Map<String, String> map;
        block4: {
            this.attribution.initialize(abstractTMSTileSource);
            this.currentZoomLevel = this.getBestZoom();
            map = this.getHeaders(abstractTMSTileSource);
            this.tileLoader = this.getTileLoaderFactory().makeTileLoader(this, map);
            try {
                if ("file".equalsIgnoreCase(new URL(abstractTMSTileSource.getBaseUrl()).getProtocol())) {
                    this.tileLoader = new OsmTileLoader(this);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!Main.isDebugEnabled()) break block4;
                Main.debug(malformedURLException.getMessage());
            }
        }
        if (this.tileLoader == null) {
            this.tileLoader = new OsmTileLoader(this, map);
        }
        this.tileCache = new MemoryTileCache(this.estimateTileCacheSize());
    }

    @Override
    public synchronized void tileLoadingFinished(Tile tile, boolean bl) {
        if (tile.hasError()) {
            bl = false;
            tile.setImage(null);
        }
        tile.setLoaded(bl);
        this.needRedraw = true;
        if (Main.map != null) {
            Main.map.repaint(100L);
        }
        if (Main.isDebugEnabled()) {
            Main.debug("tileLoadingFinished() tile: " + tile + " success: " + bl);
        }
    }

    public void clearTileCache(ProgressMonitor progressMonitor) {
        if (this.tileLoader instanceof CachedTileLoader) {
            ((CachedTileLoader)((Object)this.tileLoader)).clearCache(this.tileSource);
        }
        this.tileCache.clear();
    }

    protected void redraw() {
        this.needRedraw = true;
        Main.map.repaint();
    }

    @Override
    public void setGamma(double d) {
        super.setGamma(d);
        this.redraw();
    }

    @Override
    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.needRedraw = true;
    }

    private double getScaleFactor(int n) {
        if (!Main.isDisplayingMapView()) {
            return 1.0;
        }
        MapView mapView = Main.map.mapView;
        LatLon latLon = mapView.getLatLon(0, 0);
        LatLon latLon2 = mapView.getLatLon(mapView.getWidth(), mapView.getHeight());
        TileXY tileXY = this.tileSource.latLonToTileXY(latLon.toCoordinate(), n);
        TileXY tileXY2 = this.tileSource.latLonToTileXY(latLon2.toCoordinate(), n);
        int n2 = mapView.getWidth() * mapView.getHeight();
        double d = Math.abs((tileXY2.getY() - tileXY.getY()) * (tileXY2.getX() - tileXY.getX()) * (double)this.tileSource.getTileSize() * (double)this.tileSource.getTileSize());
        if (n2 == 0 || d == 0.0) {
            return 1.0;
        }
        return (double)n2 / d;
    }

    protected int getBestZoom() {
        double d = this.getScaleFactor(1);
        double d2 = Math.log(d) / Math.log(2.0) / 2.0;
        int n = (int)Math.round(d2 + 1.0 + (double)ZOOM_OFFSET.get().intValue() / 1.9);
        n = Math.min(n, this.getMaxZoomLvl());
        n = Math.max(n, this.getMinZoomLvl());
        return n;
    }

    private static boolean actionSupportLayers(List<Layer> list) {
        return list.size() == 1 && list.get(0) instanceof TMSLayer;
    }

    @Override
    public void hookUpMapView() {
        Field field;
        Field field2;
        Field field3;
        this.tileSource = this.getTileSource(this.info);
        if (this.tileSource == null) {
            throw new IllegalArgumentException(I18n.tr("Failed to create tile source", new Object[0]));
        }
        super.hookUpMapView();
        this.projectionChanged(null, Main.getProjection());
        this.initTileSource(this.tileSource);
        final JPopupMenu jPopupMenu = new JPopupMenu();
        final TileHolder tileHolder = new TileHolder();
        try {
            field3 = AbstractTileSourceLayer.class.getField("autoZoom");
            field2 = AbstractTileSourceLayer.class.getDeclaredField("autoLoad");
            field = AbstractTileSourceLayer.class.getDeclaredField("showErrors");
        }
        catch (NoSuchFieldException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
        this.autoZoom = PROP_DEFAULT_AUTOZOOM.get();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
        jCheckBoxMenuItem.setModel(new BooleanButtonModel(field3));
        jCheckBoxMenuItem.setAction(new AutoZoomAction());
        jPopupMenu.add(jCheckBoxMenuItem);
        this.autoLoad = PROP_DEFAULT_AUTOLOAD.get();
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem();
        jCheckBoxMenuItem2.setAction(new AutoLoadTilesAction());
        jCheckBoxMenuItem2.setModel(new BooleanButtonModel(field2));
        jPopupMenu.add(jCheckBoxMenuItem2);
        this.showErrors = PROP_DEFAULT_SHOWERRORS.get();
        JCheckBoxMenuItem jCheckBoxMenuItem3 = new JCheckBoxMenuItem();
        jCheckBoxMenuItem3.setAction(new AbstractAction(I18n.tr("Show Errors", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTileSourceLayer.this.showErrors = !AbstractTileSourceLayer.this.showErrors;
            }
        });
        jCheckBoxMenuItem3.setModel(new BooleanButtonModel(field));
        jPopupMenu.add(jCheckBoxMenuItem3);
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Load Tile", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tile tile = tileHolder.getTile();
                if (tile != null) {
                    AbstractTileSourceLayer.this.loadTile(tile, true);
                    AbstractTileSourceLayer.this.redraw();
                }
            }
        }));
        jPopupMenu.add(new JMenuItem(new ShowTileInfoAction(tileHolder)));
        jPopupMenu.add(new JMenuItem(new LoadAllTilesAction()));
        jPopupMenu.add(new JMenuItem(new LoadErroneusTilesAction()));
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Increase zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTileSourceLayer.this.increaseZoomLevel();
                AbstractTileSourceLayer.this.redraw();
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Decrease zoom", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractTileSourceLayer.this.decreaseZoomLevel();
                AbstractTileSourceLayer.this.redraw();
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Snap to tile size", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = Math.sqrt(AbstractTileSourceLayer.this.getScaleFactor(AbstractTileSourceLayer.this.currentZoomLevel));
                Main.map.mapView.zoomToFactor(d);
                AbstractTileSourceLayer.this.redraw();
            }
        }));
        jPopupMenu.add(new JMenuItem(new AbstractAction(I18n.tr("Flush Tile Cache", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new PleaseWaitRunnable(I18n.tr("Flush Tile Cache", new Object[0])){

                    @Override
                    protected void realRun() {
                        AbstractTileSourceLayer.this.clearTileCache(this.getProgressMonitor());
                    }

                    @Override
                    protected void finish() {
                    }

                    @Override
                    protected void cancel() {
                    }
                }.run();
            }
        }));
        final MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!AbstractTileSourceLayer.this.isVisible()) {
                    return;
                }
                if (mouseEvent.getButton() == 3) {
                    tileHolder.setTile(AbstractTileSourceLayer.this.getTileForPixelpos(mouseEvent.getX(), mouseEvent.getY()));
                    jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getButton() == 1) {
                    AbstractTileSourceLayer.this.attribution.handleAttribution(mouseEvent.getPoint(), true);
                }
            }
        };
        Main.map.mapView.addMouseListener(mouseAdapter);
        MapView.addLayerChangeListener(new MapView.LayerChangeListener(){

            @Override
            public void activeLayerChange(Layer layer, Layer layer2) {
            }

            @Override
            public void layerAdded(Layer layer) {
            }

            @Override
            public void layerRemoved(Layer layer) {
                if (layer == AbstractTileSourceLayer.this) {
                    Main.map.mapView.removeMouseListener(mouseAdapter);
                    MapView.removeLayerChangeListener(this);
                    MapView.removeZoomChangeListener(AbstractTileSourceLayer.this);
                }
            }
        });
        Main.map.repaint(500L);
    }

    @Override
    protected long estimateMemoryUsage() {
        return 4L * (long)this.tileSource.getTileSize() * (long)this.tileSource.getTileSize() * (long)this.estimateTileCacheSize();
    }

    protected int estimateTileCacheSize() {
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        int n3 = 256;
        if (this.tileSource != null) {
            n3 = this.tileSource.getTileSize();
        }
        int n4 = (int)(Math.ceil((double)n / (double)n3 + 1.0) * Math.ceil((double)n2 / (double)n3 + 1.0));
        return (int)Math.ceil(Math.pow(2.0, ZOOM_OFFSET.get().intValue()) * (double)n4 * 2.0);
    }

    public static int checkMaxZoomLvl(int n, TileSource tileSource) {
        if (n > 30) {
            n = 30;
        }
        if (n < PROP_MIN_ZOOM_LVL.get()) {
            n = PROP_MIN_ZOOM_LVL.get();
        }
        if (tileSource != null && tileSource.getMaxZoom() != 0 && tileSource.getMaxZoom() < n) {
            n = tileSource.getMaxZoom();
        }
        return n;
    }

    public static int checkMinZoomLvl(int n, TileSource tileSource) {
        if (n < 2) {
            n = 2;
        }
        if (n > PROP_MAX_ZOOM_LVL.get()) {
            n = AbstractTileSourceLayer.getMaxZoomLvl(tileSource);
        }
        if (tileSource != null && tileSource.getMinZoom() > n) {
            n = tileSource.getMinZoom();
        }
        return n;
    }

    public static int getMaxZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMaxZoomLvl(PROP_MAX_ZOOM_LVL.get(), tileSource);
    }

    public static int getMinZoomLvl(TileSource tileSource) {
        return AbstractTileSourceLayer.checkMinZoomLvl(PROP_MIN_ZOOM_LVL.get(), tileSource);
    }

    public static void setMaxZoomLvl(int n) {
        PROP_MAX_ZOOM_LVL.put(AbstractTileSourceLayer.checkMaxZoomLvl(n, null));
    }

    public static void setMinZoomLvl(int n) {
        PROP_MIN_ZOOM_LVL.put(AbstractTileSourceLayer.checkMinZoomLvl(n, null));
    }

    @Override
    public void zoomChanged() {
        if (Main.isDebugEnabled()) {
            Main.debug("zoomChanged(): " + this.currentZoomLevel);
        }
        if (this.tileLoader instanceof TMSCachedTileLoader) {
            ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
        }
        this.needRedraw = true;
    }

    protected int getMaxZoomLvl() {
        if (this.info.getMaxZoom() != 0) {
            return AbstractTileSourceLayer.checkMaxZoomLvl(this.info.getMaxZoom(), this.tileSource);
        }
        return AbstractTileSourceLayer.getMaxZoomLvl(this.tileSource);
    }

    protected int getMinZoomLvl() {
        return AbstractTileSourceLayer.getMinZoomLvl(this.tileSource);
    }

    public boolean zoomIncreaseAllowed() {
        boolean bl;
        boolean bl2 = bl = this.currentZoomLevel < this.getMaxZoomLvl();
        if (Main.isDebugEnabled()) {
            Main.debug("zoomIncreaseAllowed(): " + bl + ' ' + this.currentZoomLevel + " vs. " + this.getMaxZoomLvl());
        }
        return bl;
    }

    public boolean increaseZoomLevel() {
        if (this.zoomIncreaseAllowed()) {
            ++this.currentZoomLevel;
            if (Main.isDebugEnabled()) {
                Main.debug("increasing zoom level to: " + this.currentZoomLevel);
            }
        } else {
            Main.warn("Current zoom level (" + this.currentZoomLevel + ") could not be increased. " + "Max.zZoom Level " + this.getMaxZoomLvl() + " reached.");
            return false;
        }
        this.zoomChanged();
        return true;
    }

    public boolean setZoomLevel(int n) {
        if (n == this.currentZoomLevel) {
            return true;
        }
        if (n > this.getMaxZoomLvl()) {
            return false;
        }
        if (n < this.getMinZoomLvl()) {
            return false;
        }
        this.currentZoomLevel = n;
        this.zoomChanged();
        return true;
    }

    public boolean zoomDecreaseAllowed() {
        return this.currentZoomLevel > this.getMinZoomLvl();
    }

    public boolean decreaseZoomLevel() {
        if (this.zoomDecreaseAllowed()) {
            if (Main.isDebugEnabled()) {
                Main.debug("decreasing zoom level to: " + this.currentZoomLevel);
            }
            --this.currentZoomLevel;
        } else {
            return false;
        }
        this.zoomChanged();
        return true;
    }

    private Tile tempCornerTile(Tile tile) {
        int n;
        int n2;
        int n3 = tile.getXtile() + 1;
        Tile tile2 = this.getTile(n3, n2 = tile.getYtile() + 1, n = tile.getZoom());
        if (tile2 != null) {
            return tile2;
        }
        return new Tile(this.tileSource, n3, n2, n);
    }

    private Tile getOrCreateTile(int n, int n2, int n3) {
        Tile tile = this.getTile(n, n2, n3);
        if (tile == null) {
            tile = new Tile(this.tileSource, n, n2, n3);
            this.tileCache.addTile(tile);
            tile.loadPlaceholderFromCache(this.tileCache);
        }
        return tile;
    }

    private Tile getTile(int n, int n2, int n3) {
        if (n < 0 || n > this.tileSource.getTileXMax(n3) || n2 < 0 || n2 > this.tileSource.getTileYMax(n3)) {
            return null;
        }
        return this.tileCache.getTile(this.tileSource, n, n2, n3);
    }

    private boolean loadTile(Tile tile, boolean bl) {
        if (tile == null) {
            return false;
        }
        if (!bl && (tile.isLoaded() || tile.hasError())) {
            return false;
        }
        if (tile.isLoading()) {
            return false;
        }
        this.tileLoader.createTileLoaderJob(tile).submit(bl);
        return true;
    }

    private TileSet getVisibleTileSet() {
        MapView mapView = Main.map.mapView;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        return new TileSet(eastNorth, eastNorth2, this.currentZoomLevel);
    }

    protected void loadAllTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        if (tileSet.tooLarge()) {
            Main.warn("Not downloading all tiles because there is more than 18 tiles on an axis!");
            return;
        }
        tileSet.loadAllTiles(bl);
    }

    protected void loadAllErrorTiles(boolean bl) {
        TileSet tileSet = this.getVisibleTileSet();
        tileSet.loadAllErrorTiles(bl);
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl = (n & 0x70) != 0;
        this.needRedraw = true;
        if (Main.isDebugEnabled()) {
            Main.debug("imageUpdate() done: " + bl + " calling repaint");
        }
        Main.map.repaint(bl ? 0L : 100L);
        return !bl;
    }

    private boolean imageLoaded(Image image) {
        if (image == null) {
            return false;
        }
        int n = Toolkit.getDefaultToolkit().checkImage(image, -1, -1, this);
        return (n & 0x20) != 0;
    }

    private Image getLoadedTileImage(Tile tile) {
        if (!tile.isLoaded()) {
            return null;
        }
        BufferedImage bufferedImage = tile.getImage();
        if (!this.imageLoaded(bufferedImage)) {
            return null;
        }
        return bufferedImage;
    }

    private Rectangle tileToRect(Tile tile) {
        Tile tile2 = this.tempCornerTile(tile);
        Rectangle rectangle = new Rectangle(this.pixelPos(tile));
        rectangle.add(this.pixelPos(tile2));
        return rectangle;
    }

    private void drawImageInside(Graphics graphics, Image image, Rectangle rectangle, Rectangle rectangle2) {
        Rectangle rectangle3 = rectangle;
        if (rectangle2 != null) {
            rectangle3 = rectangle.intersection(rectangle2);
            if (Main.isDebugEnabled()) {
                Main.debug("source: " + rectangle + "\nborder: " + rectangle2 + "\nintersection: " + rectangle3);
            }
        }
        double d = (double)image.getHeight(this) / rectangle.getHeight();
        double d2 = (double)image.getWidth(this) / rectangle.getWidth();
        int n = rectangle3.x - rectangle.x;
        int n2 = rectangle3.y - rectangle.y;
        int n3 = (int)((double)n * d2 + 0.5);
        int n4 = (int)((double)n2 * d + 0.5);
        int n5 = n3 + (int)(rectangle3.getWidth() * d2 + 0.5);
        int n6 = n4 + (int)(rectangle3.getHeight() * d + 0.5);
        if (Main.isDebugEnabled()) {
            Main.debug("drawing image into target rect: " + rectangle3);
        }
        graphics.drawImage(image, rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y + rectangle3.height, n3, n4, n5, n6, this);
        if (PROP_FADE_AMOUNT.get() != 0) {
            graphics.setColor(AbstractTileSourceLayer.getFadeColorWithAlpha());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    private List<Tile> paintTileImages(Graphics graphics, TileSet tileSet, int n, Tile tile) {
        if (n <= 0) {
            return Collections.emptyList();
        }
        Rectangle rectangle = null;
        if (tile != null) {
            rectangle = this.tileToRect(tile);
        }
        LinkedList<Tile> linkedList = new LinkedList<Tile>();
        for (Tile tile2 : tileSet.allTilesCreate()) {
            Image image = this.getLoadedTileImage(tile2);
            if (image == null || tile2.hasError()) {
                if (Main.isDebugEnabled()) {
                    Main.debug("missed tile: " + tile2);
                }
                linkedList.add(tile2);
                continue;
            }
            image = this.applyImageProcessors((BufferedImage)image);
            Rectangle rectangle2 = this.tileToRect(tile2);
            if (rectangle != null && !rectangle2.intersects(rectangle)) continue;
            this.drawImageInside(graphics, image, rectangle2, rectangle);
        }
        return linkedList;
    }

    private void myDrawString(Graphics graphics, String string, int n, int n2) {
        Color color = graphics.getColor();
        String string2 = string;
        if (graphics.getFontMetrics().stringWidth(string) > this.tileSource.getTileSize()) {
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            String[] stringArray = string.split(" ");
            int n3 = stringArray.length;
            for (int i = 0; i < n3; ++i) {
                String string3 = stringArray[i];
                if (graphics.getFontMetrics().stringWidth(stringBuilder.toString() + string3) > this.tileSource.getTileSize()) {
                    stringBuilder2.append((CharSequence)stringBuilder).append('\n');
                    stringBuilder.setLength(0);
                }
                stringBuilder.append(string3).append(' ');
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            string2 = stringBuilder2.toString();
        }
        int n4 = 0;
        for (String string4 : string2.split("\n")) {
            graphics.setColor(Color.black);
            graphics.drawString(string4, n + 1, n2 + n4 + 1);
            graphics.setColor(color);
            graphics.drawString(string4, n, n2 + n4);
            n4 += graphics.getFontMetrics().getHeight() + 3;
        }
    }

    private void paintTileText(TileSet tileSet, Tile tile, Graphics graphics, MapView mapView, int n, Tile tile2) {
        int n2 = graphics.getFontMetrics().getHeight();
        if (tile == null) {
            return;
        }
        Point point = this.pixelPos(tile2);
        int n3 = point.y + 2 + n2;
        if (tile.hasError() && this.showErrors) {
            this.myDrawString(graphics, I18n.tr("Error", new Object[0]) + ": " + I18n.tr(tile.getErrorMessage(), new Object[0]), point.x + 2, n3);
        }
        int n4 = -1;
        int n5 = -1;
        if (Main.isDebugEnabled()) {
            if (n5 < tile2.getYtile()) {
                if (tile2.getYtile() % 32 == 31) {
                    graphics.fillRect(0, point.y - 1, mapView.getWidth(), 3);
                } else {
                    graphics.drawLine(0, point.y, mapView.getWidth(), point.y);
                }
            }
            if (n4 < tile2.getXtile()) {
                if (tile2.getXtile() % 32 == 0) {
                    graphics.fillRect(point.x - 1, 0, 3, mapView.getHeight());
                } else {
                    graphics.drawLine(point.x, 0, point.x, mapView.getHeight());
                }
            }
        }
    }

    private Point pixelPos(LatLon latLon) {
        return Main.map.mapView.getPoint(Main.getProjection().latlon2eastNorth(latLon).add(this.getDx(), this.getDy()));
    }

    private Point pixelPos(Tile tile) {
        ICoordinate iCoordinate = this.tileSource.tileXYToLatLon(tile);
        return this.pixelPos(new LatLon(iCoordinate));
    }

    private LatLon getShiftedLatLon(EastNorth eastNorth) {
        return Main.getProjection().eastNorth2latlon(eastNorth.add(-this.getDx(), -this.getDy()));
    }

    private ICoordinate getShiftedCoord(EastNorth eastNorth) {
        return this.getShiftedLatLon(eastNorth).toCoordinate();
    }

    private static TileSetInfo getTileSetInfo(TileSet tileSet) {
        List list = tileSet.allExistingTiles();
        TileSetInfo tileSetInfo = new TileSetInfo();
        tileSetInfo.hasLoadingTiles = list.size() < tileSet.size();
        for (Tile tile : list) {
            if ("no-tile".equals(tile.getValue("tile-info"))) {
                tileSetInfo.hasOverzoomedTiles = true;
            }
            if (tile.isLoaded()) {
                if (tile.hasError()) continue;
                tileSetInfo.hasVisibleTiles = true;
                continue;
            }
            if (!tile.isLoading()) continue;
            tileSetInfo.hasLoadingTiles = true;
        }
        return tileSetInfo;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        LinkedList<Tile> linkedList;
        EastNorth eastNorth = mapView.getEastNorth(0, 0);
        EastNorth eastNorth2 = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight());
        if (eastNorth2.east() == 0.0 || eastNorth2.north() == 0.0) {
            return;
        }
        this.needRedraw = false;
        int n = this.currentZoomLevel;
        if (this.autoZoom) {
            n = this.getBestZoom();
        }
        DeepTileSet deepTileSet = new DeepTileSet(eastNorth, eastNorth2, this.getMinZoomLvl(), n);
        TileSet tileSet = deepTileSet.getTileSet(n);
        int n2 = n;
        boolean bl = false;
        if (this.autoZoom && this.autoLoad) {
            linkedList = deepTileSet.getTileSetInfo(n);
            if (!(((TileSetInfo)((Object)linkedList)).hasVisibleTiles || ((TileSetInfo)((Object)linkedList)).hasLoadingTiles && !((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles)) {
                bl = true;
            }
            for (int i = n; i > deepTileSet.minZoom; --i) {
                if (!deepTileSet.getTileSetInfo((int)i).hasVisibleTiles) continue;
                n2 = i;
                break;
            }
            while (n > n2 && !((TileSetInfo)((Object)linkedList)).hasVisibleTiles && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles) {
                n = (n + n2) / 2;
                linkedList = deepTileSet.getTileSetInfo(n);
            }
            this.setZoomLevel(n);
            if (n == n2 && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles && n < deepTileSet.maxZoom) {
                linkedList = deepTileSet.getTileSetInfo(++n);
            }
            while (n > deepTileSet.minZoom && ((TileSetInfo)((Object)linkedList)).hasOverzoomedTiles && !((TileSetInfo)((Object)linkedList)).hasLoadingTiles) {
                linkedList = deepTileSet.getTileSetInfo(--n);
            }
            tileSet = deepTileSet.getTileSet(n);
        } else if (this.autoZoom) {
            this.setZoomLevel(n);
        }
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        if (n2 != n) {
            tileSet = deepTileSet.getTileSet(n2);
        }
        graphics2D.setColor(Color.DARK_GRAY);
        linkedList = this.paintTileImages(graphics2D, tileSet, n2, null);
        int[] nArray = new int[]{-1, 1, -2, 2, -3, -4, -5};
        for (int n3 : nArray) {
            if (!this.autoZoom) break;
            int n4 = n2 + n3;
            if (n4 < this.getMinZoomLvl() || n4 > this.getMaxZoomLvl()) continue;
            if (linkedList.isEmpty()) break;
            LinkedList<Tile> object2 = new LinkedList<Tile>();
            for (Tile tile : linkedList) {
                LatLon latLon;
                if ("no-tile".equals(tile.getValue("tile-info")) && n3 > 0) {
                    object2.add(tile);
                    continue;
                }
                Tile tile2 = this.tempCornerTile(tile);
                LatLon latLon2 = new LatLon(this.tileSource.tileXYToLatLon(tile));
                TileSet tileSet2 = new TileSet(latLon2, latLon = new LatLon(this.tileSource.tileXYToLatLon(tile2)), n4);
                if (tileSet2.allLoadedTiles().isEmpty()) {
                    object2.add(tile);
                    continue;
                }
                if (tileSet2.tooLarge()) continue;
                object2.addAll(this.paintTileImages(graphics2D, tileSet2, n4, tile));
            }
            linkedList = object2;
        }
        if (Main.isDebugEnabled() && !linkedList.isEmpty()) {
            Main.debug("still missed " + linkedList.size() + " in the end");
        }
        graphics2D.setColor(Color.red);
        graphics2D.setFont(InfoFont);
        Object object = tileSet.allExistingTiles().iterator();
        while (object.hasNext()) {
            Tile tile = (Tile)object.next();
            this.paintTileText(tileSet, tile, graphics2D, mapView, n2, tile);
        }
        this.attribution.paintAttribution(graphics2D, mapView.getWidth(), mapView.getHeight(), this.getShiftedCoord(eastNorth), this.getShiftedCoord(eastNorth2), n2, this);
        graphics2D.setColor(Color.lightGray);
        if (tileSet.insane()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load any tiles", new Object[0]), 120, 120);
        } else if (tileSet.tooLarge()) {
            this.myDrawString(graphics2D, I18n.tr("zoom in to load more tiles", new Object[0]), 120, 120);
        } else if (!this.autoZoom && tileSet.tooSmall()) {
            this.myDrawString(graphics2D, I18n.tr("increase zoom level to see more detail", new Object[0]), 120, 120);
        }
        if (bl) {
            this.myDrawString(graphics2D, I18n.tr("No tiles at this zoom level", new Object[0]), 120, 120);
        }
        if (Main.isDebugEnabled()) {
            this.myDrawString(graphics2D, I18n.tr("Current zoom: {0}", this.currentZoomLevel), 50, 140);
            this.myDrawString(graphics2D, I18n.tr("Display zoom: {0}", n2), 50, 155);
            this.myDrawString(graphics2D, I18n.tr("Pixel scale: {0}", this.getScaleFactor(this.currentZoomLevel)), 50, 170);
            this.myDrawString(graphics2D, I18n.tr("Best zoom: {0}", this.getBestZoom()), 50, 185);
            this.myDrawString(graphics2D, I18n.tr("Estimated cache size: {0}", this.estimateTileCacheSize()), 50, 200);
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                object = (TMSCachedTileLoader)this.tileLoader;
                int n5 = 200;
                for (String string : ((TMSCachedTileLoader)object).getStats().split("\n")) {
                    this.myDrawString(graphics2D, I18n.tr("Cache stats: {0}", string), 50, n5 += 15);
                }
            }
        }
    }

    private Tile getTileForPixelpos(int n, int n2) {
        int n3;
        EastNorth eastNorth;
        if (Main.isDebugEnabled()) {
            Main.debug("getTileForPixelpos(" + n + ", " + n2 + ')');
        }
        MapView mapView = Main.map.mapView;
        Point point = new Point(n, n2);
        EastNorth eastNorth2 = mapView.getEastNorth(0, 0);
        TileSet tileSet = new TileSet(eastNorth2, eastNorth = mapView.getEastNorth(mapView.getWidth(), mapView.getHeight()), n3 = this.currentZoomLevel);
        if (!tileSet.tooLarge()) {
            tileSet.loadAllTiles(false);
        }
        Tile tile = null;
        for (Tile tile2 : tileSet.allExistingTiles()) {
            Tile tile3 = this.tempCornerTile(tile2);
            Rectangle rectangle = new Rectangle(this.pixelPos(tile2));
            rectangle.add(this.pixelPos(tile3));
            if (Main.isDebugEnabled()) {
                Main.debug("r: " + rectangle + " clicked: " + point);
            }
            if (!rectangle.contains(point)) continue;
            tile = tile2;
            break;
        }
        if (tile == null) {
            return null;
        }
        return tile;
    }

    @Override
    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(this), new RenameLayerAction(this.getAssociatedFile(), this), Layer.SeparatorLayerAction.INSTANCE, new AutoLoadTilesAction(), new AutoZoomAction(), new ZoomToBestAction(), new ZoomToNativeLevelAction(), new LoadErroneusTilesAction(), new LoadAllTilesAction(), new LayerListPopup.InfoAction(this)};
    }

    @Override
    public String getToolTipText() {
        if (this.autoLoad) {
            return I18n.tr("{0} ({1}), automatically downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
        }
        return I18n.tr("{0} ({1}), downloading in zoom {2}", this.getClass().getSimpleName(), this.getName(), this.currentZoomLevel);
    }

    @Override
    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
    }

    @Override
    public boolean isChanged() {
        return this.needRedraw;
    }

    public void downloadAreaToCache(PrecacheTask precacheTask, List<LatLon> list, double d, double d2) {
        ConcurrentSkipListSet<Tile> concurrentSkipListSet = new ConcurrentSkipListSet<Tile>(new Comparator<Tile>(){

            @Override
            public int compare(Tile tile, Tile tile2) {
                return String.CASE_INSENSITIVE_ORDER.compare(tile.getKey(), tile2.getKey());
            }
        });
        for (LatLon object : list) {
            TileXY tileXY = this.tileSource.latLonToTileXY(object.lat() - d2, object.lon() - d, this.currentZoomLevel);
            TileXY tileXY2 = this.tileSource.latLonToTileXY(object.toCoordinate(), this.currentZoomLevel);
            TileXY tileXY3 = this.tileSource.latLonToTileXY(object.lat() + d2, object.lon() + d, this.currentZoomLevel);
            int n = Math.min(tileXY2.getYIndex() - 1, tileXY.getYIndex());
            int n2 = Math.max(tileXY2.getYIndex() + 1, tileXY3.getYIndex());
            int n3 = Math.min(tileXY2.getXIndex() - 1, tileXY.getXIndex());
            int n4 = Math.min(tileXY2.getXIndex() + 1, tileXY.getXIndex());
            for (int i = n3; i <= n4; ++i) {
                for (int j = n; j <= n2; ++j) {
                    concurrentSkipListSet.add(new Tile(this.tileSource, i, j, this.currentZoomLevel));
                }
            }
        }
        precacheTask.totalCount = concurrentSkipListSet.size();
        precacheTask.progressMonitor.setTicksCount(concurrentSkipListSet.size());
        TileLoader tileLoader = precacheTask.getTileLoader();
        for (Tile tile : concurrentSkipListSet) {
            tileLoader.createTileLoaderJob(tile).submit();
        }
    }

    @Override
    public boolean isSavable() {
        return true;
    }

    @Override
    public File createAndOpenSaveFileChooser() {
        return SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save WMS file", new Object[0]), WMSLayerImporter.FILE_FILTER);
    }

    public class PrecacheTask
    implements TileLoaderListener {
        private final ProgressMonitor progressMonitor;
        private int totalCount;
        private AtomicInteger processedCount = new AtomicInteger(0);
        private final TileLoader tileLoader;

        public PrecacheTask(ProgressMonitor progressMonitor) {
            this.progressMonitor = progressMonitor;
            this.tileLoader = AbstractTileSourceLayer.this.getTileLoaderFactory().makeTileLoader(this, AbstractTileSourceLayer.this.getHeaders(AbstractTileSourceLayer.this.tileSource));
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).setDownloadExecutor(TMSCachedTileLoader.getNewThreadPoolExecutor("Precache downloader"));
            }
        }

        public boolean isFinished() {
            return this.processedCount.get() >= this.totalCount;
        }

        public int getTotalCount() {
            return this.totalCount;
        }

        public void cancel() {
            if (this.tileLoader instanceof TMSCachedTileLoader) {
                ((TMSCachedTileLoader)this.tileLoader).cancelOutstandingTasks();
            }
        }

        @Override
        public void tileLoadingFinished(Tile tile, boolean bl) {
            if (bl) {
                int n = this.processedCount.incrementAndGet();
                this.progressMonitor.worked(1);
                this.progressMonitor.setCustomText(I18n.tr("Downloaded {0}/{1} tiles", n, this.totalCount));
            }
        }

        public TileLoader getTileLoader() {
            return this.tileLoader;
        }
    }

    private class DeepTileSet {
        private final EastNorth topLeft;
        private final EastNorth botRight;
        private final int minZoom;
        private final int maxZoom;
        private final TileSet[] tileSets;
        private final TileSetInfo[] tileSetInfos;

        DeepTileSet(EastNorth eastNorth, EastNorth eastNorth2, int n, int n2) {
            this.topLeft = eastNorth;
            this.botRight = eastNorth2;
            this.minZoom = n;
            this.maxZoom = n2;
            this.tileSets = new TileSet[n2 - n + 1];
            this.tileSetInfos = new TileSetInfo[n2 - n + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSet getTileSet(int n) {
            if (n < this.minZoom) {
                return AbstractTileSourceLayer.this.nullTileSet;
            }
            TileSet[] tileSetArray = this.tileSets;
            synchronized (this.tileSets) {
                TileSet tileSet = this.tileSets[n - this.minZoom];
                if (tileSet == null) {
                    this.tileSets[n - this.minZoom] = tileSet = new TileSet(this.topLeft, this.botRight, n);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileSetInfo getTileSetInfo(int n) {
            if (n < this.minZoom) {
                return new TileSetInfo();
            }
            TileSetInfo[] tileSetInfoArray = this.tileSetInfos;
            synchronized (this.tileSetInfos) {
                TileSetInfo tileSetInfo = this.tileSetInfos[n - this.minZoom];
                if (tileSetInfo == null) {
                    this.tileSetInfos[n - this.minZoom] = tileSetInfo = AbstractTileSourceLayer.getTileSetInfo(this.getTileSet(n));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return tileSetInfo;
            }
        }
    }

    private static class TileSetInfo {
        public boolean hasVisibleTiles;
        public boolean hasOverzoomedTiles;
        public boolean hasLoadingTiles;

        private TileSetInfo() {
        }
    }

    private final class TileSet {
        int x0;
        int x1;
        int y0;
        int y1;
        int zoom;

        private TileSet(EastNorth eastNorth, EastNorth eastNorth2, int n) {
            this(abstractTileSourceLayer.getShiftedLatLon(eastNorth), abstractTileSourceLayer.getShiftedLatLon(eastNorth2), n);
        }

        private TileSet(LatLon latLon, LatLon latLon2, int n) {
            int n2;
            this.zoom = n;
            if (n == 0) {
                return;
            }
            TileXY tileXY = AbstractTileSourceLayer.this.tileSource.latLonToTileXY(latLon.toCoordinate(), n);
            TileXY tileXY2 = AbstractTileSourceLayer.this.tileSource.latLonToTileXY(latLon2.toCoordinate(), n);
            this.x0 = tileXY.getXIndex();
            this.y0 = tileXY.getYIndex();
            this.x1 = tileXY2.getXIndex();
            this.y1 = tileXY2.getYIndex();
            if (this.x0 > this.x1) {
                n2 = this.x0;
                this.x0 = this.x1;
                this.x1 = n2;
            }
            if (this.y0 > this.y1) {
                n2 = this.y0;
                this.y0 = this.y1;
                this.y1 = n2;
            }
            if (this.x0 < AbstractTileSourceLayer.this.tileSource.getTileXMin(n)) {
                this.x0 = AbstractTileSourceLayer.this.tileSource.getTileXMin(n);
            }
            if (this.y0 < AbstractTileSourceLayer.this.tileSource.getTileYMin(n)) {
                this.y0 = AbstractTileSourceLayer.this.tileSource.getTileYMin(n);
            }
            if (this.x1 > AbstractTileSourceLayer.this.tileSource.getTileXMax(n)) {
                this.x1 = AbstractTileSourceLayer.this.tileSource.getTileXMax(n);
            }
            if (this.y1 > AbstractTileSourceLayer.this.tileSource.getTileYMax(n)) {
                this.y1 = AbstractTileSourceLayer.this.tileSource.getTileYMax(n);
            }
        }

        private boolean tooSmall() {
            return this.tilesSpanned() < 2.1;
        }

        private boolean tooLarge() {
            return this.insane() || this.tilesSpanned() > 20.0;
        }

        private boolean insane() {
            return this.size() > AbstractTileSourceLayer.this.tileCache.getCacheSize();
        }

        private double tilesSpanned() {
            return Math.sqrt(1.0 * (double)this.size());
        }

        private int size() {
            int n = this.x1 - this.x0 + 1;
            int n2 = this.y1 - this.y0 + 1;
            return n * n2;
        }

        private List<Tile> allExistingTiles() {
            return this.__allTiles(false);
        }

        private List<Tile> allTilesCreate() {
            return this.__allTiles(true);
        }

        private List<Tile> __allTiles(boolean bl) {
            if (this.zoom == 0 || this.insane()) {
                return Collections.emptyList();
            }
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (int i = this.x0; i <= this.x1; ++i) {
                for (int j = this.y0; j <= this.y1; ++j) {
                    Tile tile = bl ? AbstractTileSourceLayer.this.getOrCreateTile(i, j, this.zoom) : AbstractTileSourceLayer.this.getTile(i, j, this.zoom);
                    if (tile == null) continue;
                    arrayList.add(tile);
                }
            }
            return arrayList;
        }

        private List<Tile> allLoadedTiles() {
            ArrayList<Tile> arrayList = new ArrayList<Tile>();
            for (Tile tile : this.allExistingTiles()) {
                if (!tile.isLoaded()) continue;
                arrayList.add(tile);
            }
            return arrayList;
        }

        private Comparator<Tile> getTileDistanceComparator() {
            final int n = (int)Math.ceil((double)(this.x0 + this.x1) / 2.0);
            final int n2 = (int)Math.ceil((double)(this.y0 + this.y1) / 2.0);
            return new Comparator<Tile>(){

                private int getDistance(Tile tile) {
                    return Math.abs(tile.getXtile() - n) + Math.abs(tile.getYtile() - n2);
                }

                @Override
                public int compare(Tile tile, Tile tile2) {
                    int n3 = this.getDistance(tile);
                    int n22 = this.getDistance(tile2);
                    return Integer.compare(n3, n22);
                }
            };
        }

        private void loadAllTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.autoLoad && !bl) {
                return;
            }
            List<Tile> list = this.allTilesCreate();
            Collections.sort(list, this.getTileDistanceComparator());
            for (Tile tile : list) {
                AbstractTileSourceLayer.this.loadTile(tile, bl);
            }
        }

        private void loadAllErrorTiles(boolean bl) {
            if (!AbstractTileSourceLayer.this.autoLoad && !bl) {
                return;
            }
            for (Tile tile : this.allTilesCreate()) {
                if (!tile.hasError()) continue;
                AbstractTileSourceLayer.this.loadTile(tile, true);
            }
        }
    }

    private class BooleanButtonModel
    extends DefaultButtonModel {
        private Field field;

        BooleanButtonModel(Field field) {
            this.field = field;
        }

        @Override
        public boolean isSelected() {
            try {
                return this.field.getBoolean(AbstractTileSourceLayer.this);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    private static final class TileHolder {
        private Tile t;

        private TileHolder() {
        }

        public Tile getTile() {
            return this.t;
        }

        public void setTile(Tile tile) {
            this.t = tile;
        }
    }

    private class ZoomToBestAction
    extends AbstractAction {
        ZoomToBestAction() {
            super(I18n.tr("Change resolution", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.setZoomLevel(AbstractTileSourceLayer.this.getBestZoom());
        }
    }

    private class ZoomToNativeLevelAction
    extends AbstractAction {
        ZoomToNativeLevelAction() {
            super(I18n.tr("Zoom to native resolution", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            double d = Math.sqrt(AbstractTileSourceLayer.this.getScaleFactor(AbstractTileSourceLayer.this.currentZoomLevel));
            Main.map.mapView.zoomToFactor(d);
            AbstractTileSourceLayer.this.redraw();
        }
    }

    private class LoadErroneusTilesAction
    extends AbstractAction {
        LoadErroneusTilesAction() {
            super(I18n.tr("Load All Error Tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.loadAllErrorTiles(true);
            AbstractTileSourceLayer.this.redraw();
        }
    }

    private class LoadAllTilesAction
    extends AbstractAction {
        LoadAllTilesAction() {
            super(I18n.tr("Load All Tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.loadAllTiles(true);
            AbstractTileSourceLayer.this.redraw();
        }
    }

    private class AutoLoadTilesAction
    extends AbstractAction
    implements Layer.LayerAction {
        AutoLoadTilesAction() {
            super(I18n.tr("Auto load tiles", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.autoLoad = !AbstractTileSourceLayer.this.autoLoad;
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(AbstractTileSourceLayer.this.autoLoad);
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return AbstractTileSourceLayer.actionSupportLayers(list);
        }
    }

    private class AutoZoomAction
    extends AbstractAction
    implements Layer.LayerAction {
        AutoZoomAction() {
            super(I18n.tr("Auto Zoom", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractTileSourceLayer.this.autoZoom = !AbstractTileSourceLayer.this.autoZoom;
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(AbstractTileSourceLayer.this.autoZoom);
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return AbstractTileSourceLayer.actionSupportLayers(list);
        }
    }

    private final class ShowTileInfoAction
    extends AbstractAction {
        private final transient TileHolder clickedTileHolder;

        private ShowTileInfoAction(TileHolder tileHolder) {
            super(I18n.tr("Show Tile Info", new Object[0]));
            this.clickedTileHolder = tileHolder;
        }

        private String getSizeString(int n) {
            StringBuilder stringBuilder = new StringBuilder();
            return stringBuilder.append(n).append('x').append(n).toString();
        }

        private JTextField createTextField(String string) {
            JTextField jTextField = new JTextField(string);
            jTextField.setEditable(false);
            jTextField.setBorder(BorderFactory.createEmptyBorder());
            return jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Tile tile = this.clickedTileHolder.getTile();
            if (tile != null) {
                String string;
                Rectangle rectangle;
                JPanel jPanel;
                ExtendedDialog extendedDialog;
                block6: {
                    extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Tile Info", new Object[0]), new String[]{I18n.tr("OK", new Object[0])});
                    jPanel = new JPanel(new GridBagLayout());
                    rectangle = AbstractTileSourceLayer.this.tileToRect(tile);
                    string = "";
                    try {
                        string = tile.getUrl();
                    }
                    catch (IOException iOException) {
                        if (!Main.isTraceEnabled()) break block6;
                        Main.trace(iOException.getMessage());
                    }
                }
                String[][] stringArrayArray = new String[][]{{"Tile name", tile.getKey()}, {"Tile url", string}, {"Tile size", this.getSizeString(tile.getTileSource().getTileSize())}, {"Tile display size", "" + rectangle.width + 'x' + rectangle.height}};
                for (String[] stringArray : stringArrayArray) {
                    jPanel.add((Component)new JLabel(I18n.tr(stringArray[0], new Object[0]) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    jPanel.add((Component)this.createTextField(stringArray[1]), GBC.eol().fill(2));
                }
                for (Map.Entry entry : tile.getMetadata().entrySet()) {
                    jPanel.add((Component)new JLabel(I18n.tr("Metadata ", new Object[0]) + I18n.tr((String)entry.getKey(), new Object[0]) + ':'), GBC.std());
                    jPanel.add(GBC.glue(5, 0), GBC.std());
                    String string2 = (String)entry.getValue();
                    if ("lastModification".equals(entry.getKey()) || "expirationTime".equals(entry.getKey())) {
                        string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(Long.parseLong(string2)));
                    }
                    jPanel.add((Component)this.createTextField(string2), GBC.eol().fill(2));
                }
                extendedDialog.setIcon(1);
                extendedDialog.setContent(jPanel);
                extendedDialog.showDialog();
            }
        }
    }
}

