/****************************************************************************
**
*W  compiled.h                  GAP source                   Martin Schönert
**
**  This package defines macros and functions that are used by compiled code.
**  Those macros and functions should go into the appropriate packages.
*/

#ifndef libGAP_GAP_COMPILED_H
#define libGAP_GAP_COMPILED_H

#ifdef __cplusplus
extern "C" {
#define libGAP_GAP_IN_EXTERN_C
#endif

#include        "system.h"              /* system dependent part           */

#include        "gasman.h"              /* garbage collector               */
#include        "objects.h"             /* objects                         */
#include        "scanner.h"             /* scanner                         */

#include        "gap.h"                 /* error handling, initialisation  */

#include        "read.h"                /* reader                          */

#include        "gvars.h"               /* global variables                */
#include        "calls.h"               /* generic call mechanism          */
#include        "opers.h"               /* generic operations              */

#include        "ariths.h"              /* basic arithmetic                */

#include        "integer.h"             /* integers                        */
#include        "rational.h"            /* rationals                       */
#include        "cyclotom.h"            /* cyclotomics                     */
#include        "finfield.h"            /* finite fields and ff elements   */
#include        "macfloat.h"            /* machine floats                  */

#include        "bool.h"                /* booleans                        */
#include        "permutat.h"            /* permutations                    */
#include        "trans.h"               /* transformation                  */
#include        "pperm.h"               /* partial perms                   */

#include        "records.h"             /* generic records                 */
#include        "precord.h"             /* plain records                   */

#include        "lists.h"               /* generic lists                   */
#include        "listoper.h"            /* operations for generic lists    */
#include        "listfunc.h"            /* functions for generic lists     */
#include        "plist.h"               /* plain lists                     */
#include        "set.h"                 /* plain sets                      */
#include        "vector.h"              /* functions for plain vectors     */
#include        "blister.h"             /* boolean lists                   */
#include        "range.h"               /* ranges                          */
#include        "string.h"              /* strings                         */

#include        "objfgelm.h"            /* objects of free groups          */
#include        "objpcgel.h"            /* objects of polycyclic groups    */
#include        "objscoll.h"            /* single collector                */
#include        "objcftl.h"             /* from the left collect           */

#include        "dt.h"                  /* deep thought                    */
#include        "dteval.h"              /* deep thought evaluation          */

#include        "sctable.h"             /* structure constant table        */
#include        "costab.h"              /* coset table                     */
#include        "tietze.h"              /* tietze helper functions         */

#include        "code.h"                /* coder                           */

#include        "vars.h"                /* variables                       */
#include        "exprs.h"               /* expressions                     */
#include        "stats.h"               /* statements                      */
#include        "funcs.h"               /* functions                       */


#include        "intrprtr.h"            /* interpreter                     */

#include        "compiler.h"            /* compiler                        */

#include        "compstat.h"            /* statically linked modules       */

#include        "saveload.h"            /* saving and loading              */

#include        "streams.h"             /* streams package                 */
#include        "sysfiles.h"            /* file input/output               */
#include        "weakptr.h"             /* weak pointers                   */


extern libGAP_Obj libGAP_InfoDecision;
extern libGAP_Obj libGAP_InfoDoPrint;
extern libGAP_Obj libGAP_CurrentAssertionLevel;

extern libGAP_Obj libGAP_NewAndFilter (
    libGAP_Obj                 oper1,
    libGAP_Obj                 oper2 );


/* types, should go into 'gvars.c' and 'records.c' * * * * * * * * * * * * */

typedef libGAP_UInt    libGAP_GVar;

typedef libGAP_UInt    libGAP_RNam;


/* checks, should go into 'gap.c'  * * * * * * * * * * * * * * * * * * * * */

#define libGAP_CHECK_BOUND(obj,name) \
 if ( obj == 0 ) libGAP_ErrorQuitBound(name);

#define libGAP_CHECK_FUNC_RESULT(obj) \
 if ( obj == 0 ) libGAP_ErrorQuitFuncResult();

#define libGAP_CHECK_INT_SMALL(obj) \
 if ( ! libGAP_IS_INTOBJ(obj) ) libGAP_ErrorQuitIntSmall(obj);

#define libGAP_CHECK_INT_SMALL_POS(obj) \
 if ( ! libGAP_IS_INTOBJ(obj) || libGAP_INT_INTOBJ(obj) <= 0 ) libGAP_ErrorQuitIntSmallPos(obj);

#define libGAP_CHECK_INT_POS(obj) \
 if ( libGAP_TNUM_OBJ(obj) != libGAP_T_INTPOS && (! libGAP_IS_INTOBJ(obj) || libGAP_INT_INTOBJ(obj) <= 0) ) libGAP_ErrorQuitIntPos(obj);

#define libGAP_CHECK_BOOL(obj) \
 if ( obj != libGAP_True && obj != libGAP_False ) libGAP_ErrorQuitBool(obj);

#define libGAP_CHECK_FUNC(obj) \
 if ( libGAP_TNUM_OBJ(obj) != libGAP_T_FUNCTION ) libGAP_ErrorQuitFunc(obj);

#define libGAP_CHECK_NR_ARGS(narg,args) \
 if ( narg != libGAP_LEN_PLIST(args) ) libGAP_ErrorQuitNrArgs(narg,args);


/* higher variables, should go into 'vars.c' * * * * * * * * * * * * * * * */

#define libGAP_SWITCH_TO_NEW_FRAME     libGAP_SWITCH_TO_NEW_LVARS
#define libGAP_SWITCH_TO_OLD_FRAME     libGAP_SWITCH_TO_OLD_LVARS

#define libGAP_CURR_FRAME              libGAP_CurrLVars
#define libGAP_CURR_FRAME_1UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME     )[0] )
#define libGAP_CURR_FRAME_2UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_1UP )[0] )
#define libGAP_CURR_FRAME_3UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_2UP )[0] )
#define libGAP_CURR_FRAME_4UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_3UP )[0] )
#define libGAP_CURR_FRAME_5UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_4UP )[0] )
#define libGAP_CURR_FRAME_6UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_5UP )[0] )
#define libGAP_CURR_FRAME_7UP          libGAP_ENVI_FUNC( libGAP_PTR_BAG( libGAP_CURR_FRAME_6UP )[0] )

/* #define OBJ_LVAR(lvar)  PtrLVars[(lvar)+2] */
#define libGAP_OBJ_LVAR_0UP(lvar) \
    libGAP_OBJ_LVAR(lvar)
#define libGAP_OBJ_LVAR_1UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_1UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_2UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_2UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_3UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_3UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_4UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_4UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_5UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_5UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_6UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_6UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_7UP(lvar) \
    libGAP_PTR_BAG(libGAP_CURR_FRAME_7UP)[(lvar)+2]
#define libGAP_OBJ_LVAR_8UP(lvar) \
    libGAP_PTR_BAG(CURR_FRAME_8UP)[(lvar)+2]

/* #define ASS_LVAR(lvar,obj) do { PtrLVars[(lvar)+2] = (obj); } while ( 0 ) */
#define libGAP_ASS_LVAR_0UP(lvar,obj) \
    libGAP_ASS_LVAR(lvar,obj)
#define libGAP_ASS_LVAR_1UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_1UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_1UP); } while ( 0 )
#define libGAP_ASS_LVAR_2UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_2UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_2UP); } while ( 0 )
#define libGAP_ASS_LVAR_3UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_3UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_3UP); } while ( 0 )
#define libGAP_ASS_LVAR_4UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_4UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_4UP); } while ( 0 )
#define libGAP_ASS_LVAR_5UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_5UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_5UP); } while ( 0 )
#define libGAP_ASS_LVAR_6UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_6UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_6UP); } while ( 0 )
#define libGAP_ASS_LVAR_7UP(lvar,obj) \
    do { libGAP_PTR_BAG(libGAP_CURR_FRAME_7UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(libGAP_CURR_FRAME_7UP); } while ( 0 )
#define libGAP_ASS_LVAR_8UP(lvar,obj) \
    do { libGAP_PTR_BAG(CURR_FRAME_8UP)[(lvar)+2] = (obj); libGAP_CHANGED_BAG(CURR_FRAME_8UP); } while ( 0 )


/* objects, should into 'objects.c'  * * * * * * * * * * * * * * * * * * * */

/* there should be a function for C_ELM_POSOBJ */
#define libGAP_C_ELM_POSOBJ( elm, list, pos ) NOT_READY_YET


#define libGAP_C_ELM_POSOBJ_NLE( elm, list, pos ) \
    if ( libGAP_TNUM_OBJ(list) == libGAP_T_POSOBJ ) { \
        elm = libGAP_ELM_PLIST( list, pos ); \
    } \
    else { \
        elm = libGAP_ELMW_LIST( list, pos ); \
    }

#define libGAP_C_ASS_POSOBJ_INTOBJ( list, pos, elm ) \
    if ( libGAP_TNUM_OBJ(list) == libGAP_T_POSOBJ ) { \
        if ( libGAP_SIZE_OBJ(list)/sizeof(libGAP_Obj)-1 < pos ) { \
            libGAP_ResizeBag( list, (pos+1)*sizeof(libGAP_Obj) ); \
        } \
        libGAP_SET_ELM_PLIST( list, pos, elm ); \
    } \
    else { \
        libGAP_ASS_LIST( list, pos, elm ); \
    }

#define libGAP_C_ASS_POSOBJ( list, pos, elm ) \
    if ( libGAP_TNUM_OBJ(list) == libGAP_T_POSOBJ ) { \
        if ( libGAP_SIZE_OBJ(list)/sizeof(libGAP_Obj)-1 < pos ) { \
            libGAP_ResizeBag( list, (pos+1)*sizeof(libGAP_Obj) ); \
        } \
        libGAP_SET_ELM_PLIST( list, pos, elm ); \
        libGAP_CHANGED_BAG(list); \
    } \
    else { \
        libGAP_ASS_LIST( list, pos, elm ); \
    }



/* lists, should go into 'lists.c' * * * * * * * * * * * * * * * * * * * * */
#define libGAP_C_LEN_LIST(len,list) \
 len = libGAP_LENGTH(list);

#define libGAP_C_LEN_LIST_FPL(len,list) \
 if ( libGAP_IS_PLIST(list) ) { \
  len = libGAP_INTOBJ_INT( libGAP_LEN_PLIST(list) ); \
 } \
 else { \
  len = libGAP_LENGTH(list); \
 }




#define libGAP_C_ELM_LIST(elm,list,p) \
 elm = libGAP_IS_INTOBJ(p) ? libGAP_ELM_LIST( list, libGAP_INT_INTOBJ(p) ) : libGAP_ELMB_LIST(list, p);

#define libGAP_C_ELM_LIST_NLE(elm,list,p) \
 elm = libGAP_IS_INTOBJ(p) ? libGAP_ELMW_LIST( list, libGAP_INT_INTOBJ(p) ) : libGAP_ELMB_LIST(list, p);

#define libGAP_C_ELM_LIST_FPL(elm,list,p) \
 if ( libGAP_IS_INTOBJ(p) && libGAP_IS_PLIST(list) ) { \
  if ( libGAP_INT_INTOBJ(p) <= libGAP_LEN_PLIST(list) ) { \
   elm = libGAP_ELM_PLIST( list, libGAP_INT_INTOBJ(p) ); \
   if ( elm == 0 ) elm = libGAP_ELM_LIST( list, libGAP_INT_INTOBJ(p) ); \
  } else elm = libGAP_ELM_LIST( list, libGAP_INT_INTOBJ(p) ); \
 } else libGAP_C_ELM_LIST( elm, list, p )

#define libGAP_C_ELM_LIST_NLE_FPL(elm,list,p) \
 if ( libGAP_IS_INTOBJ(p) && libGAP_IS_PLIST(list) ) { \
  elm = libGAP_ELM_PLIST( list, libGAP_INT_INTOBJ(p) ); \
 } else libGAP_C_ELM_LIST_NLE(elm, list, p)

#define libGAP_C_ASS_LIST(list,p,rhs) \
  if (libGAP_IS_INTOBJ(p)) libGAP_ASS_LIST( list, libGAP_INT_INTOBJ(p), rhs ); \
  else libGAP_ASSB_LIST(list, p, rhs);

#define libGAP_C_ASS_LIST_FPL(list,p,rhs) \
 if ( libGAP_IS_INTOBJ(p) && libGAP_TNUM_OBJ(list) == libGAP_T_PLIST ) { \
  if ( libGAP_LEN_PLIST(list) < libGAP_INT_INTOBJ(p) ) { \
   libGAP_GROW_PLIST( list, (libGAP_UInt)libGAP_INT_INTOBJ(p) ); \
   libGAP_SET_LEN_PLIST( list, libGAP_INT_INTOBJ(p) ); \
  } \
  libGAP_SET_ELM_PLIST( list, libGAP_INT_INTOBJ(p), rhs ); \
  libGAP_CHANGED_BAG( list ); \
 } \
 else { \
  libGAP_C_ASS_LIST( list, p, rhs ) \
 }

#define libGAP_C_ASS_LIST_FPL_INTOBJ(list,p,rhs) \
 if ( libGAP_IS_INTOBJ(p) && libGAP_TNUM_OBJ(list) == libGAP_T_PLIST) { \
  if ( libGAP_LEN_PLIST(list) < libGAP_INT_INTOBJ(p) ) { \
   libGAP_GROW_PLIST( list, (libGAP_UInt)libGAP_INT_INTOBJ(p) ); \
   libGAP_SET_LEN_PLIST( list, libGAP_INT_INTOBJ(p) ); \
  } \
  libGAP_SET_ELM_PLIST( list, libGAP_INT_INTOBJ(p), rhs ); \
 } \
 else { \
  libGAP_C_ASS_LIST( list, p, rhs ) \
 }

#define libGAP_C_ISB_LIST( list, pos) \
  ((libGAP_IS_INTOBJ(pos) ? libGAP_ISB_LIST(list, libGAP_INT_INTOBJ(pos)) : libGAP_ISBB_LIST( list, pos)) ? libGAP_True : libGAP_False)

#define libGAP_C_UNB_LIST( list, pos) \
   if (libGAP_IS_INTOBJ(pos)) libGAP_UNB_LIST(list, libGAP_INT_INTOBJ(pos)); else libGAP_UNBB_LIST(list, pos);

extern  void            libGAP_AddList (
            libGAP_Obj                 list,
            libGAP_Obj                 obj );

extern  void            libGAP_AddPlist (
            libGAP_Obj                 list,
            libGAP_Obj                 obj );

#define libGAP_C_ADD_LIST(list,obj) \
 libGAP_AddList( list, obj );

#define libGAP_C_ADD_LIST_FPL(list,obj) \
 if ( libGAP_TNUM_OBJ(list) == libGAP_T_PLIST) { \
  libGAP_AddPlist( list, obj ); \
 } \
 else { \
  libGAP_AddList( list, obj ); \
 }

#define libGAP_GF_ITERATOR     libGAP_ITERATOR
#define libGAP_GF_IS_DONE_ITER libGAP_IS_DONE_ITER
#define libGAP_GF_NEXT_ITER    libGAP_NEXT_ITER

extern  libGAP_Obj             libGAP_GF_ITERATOR;
extern  libGAP_Obj             libGAP_GF_IS_DONE_ITER;
extern  libGAP_Obj             libGAP_GF_NEXT_ITER;



/* More or less all of this will get inlined away */

/* Allocate a bag suitable for a size-byte integer of type type. 
   The allocation may need to be bigger than size bytes 
   due to limb size or other aspects of the representation */

static inline  libGAP_Obj C_MAKE_INTEGER_BAG( libGAP_UInt size, libGAP_UInt type)  {
  /* Round size up to nearest multiple of INTEGER_ALLOCATION_SIZE */
  return libGAP_NewBag(type,libGAP_INTEGER_ALLOCATION_SIZE*
		((size + libGAP_INTEGER_ALLOCATION_SIZE-1)/libGAP_INTEGER_ALLOCATION_SIZE));
}


/* Set 2 bytes of data in an integer */

static inline void C_SET_LIMB2(libGAP_Obj bag, libGAP_UInt limbnumber, libGAP_UInt2 value)  {

#if libGAP_INTEGER_UNIT_SIZE == 2
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[limbnumber] = value;
#else
#if libGAP_INTEGER_UNIT_SIZE == 4
  libGAP_UInt4 *p;
  if (limbnumber % 2) {
    p = ((libGAP_UInt4 *)libGAP_ADDR_OBJ(bag)) + (limbnumber-1) / 2;
    *p = (*p & 0xFFFFUL) | ((libGAP_UInt4)value << 16);
  } else {
    p = ((libGAP_UInt4 *)libGAP_ADDR_OBJ(bag)) + limbnumber / 2;
    *p = (*p & 0xFFFF0000UL) | (libGAP_UInt4)value;
  }
#else
  libGAP_UInt8 *p;
    p  = ((libGAP_UInt8 *)libGAP_ADDR_OBJ(bag)) + limbnumber/4;
    switch(limbnumber %4) {
    case 0: 
      *p = (*p & 0xFFFFFFFFFFFF0000UL) | (libGAP_UInt8)value;
      break;
    case 1:
      *p = (*p & 0xFFFFFFFF0000FFFFUL) | ((libGAP_UInt8)value << 16);
      break;
    case 2:
      *p = (*p & 0xFFFF0000FFFFFFFFUL) | ((libGAP_UInt8)value << 32);
      break;
    case 3:
      *p = (*p & 0xFFFFFFFFFFFFUL) | ((libGAP_UInt8)value << 48);
      break;
    }
#endif
#endif  
}

static inline void C_SET_LIMB4(libGAP_Obj bag, libGAP_UInt limbnumber, libGAP_UInt4 value)  {

#if libGAP_INTEGER_UNIT_SIZE == 4
  ((libGAP_UInt4 *)libGAP_ADDR_OBJ(bag))[limbnumber] = value;
#else
#if libGAP_INTEGER_UNIT_SIZE == 8
  libGAP_UInt8 *p;
  if (limbnumber % 2) {
    p = ((libGAP_UInt8*)libGAP_ADDR_OBJ(bag)) + (limbnumber-1) / 2;
    *p = (*p & 0xFFFFFFFFUL) | ((libGAP_UInt8)value << 32);
  } else {
    p = ((libGAP_UInt8 *)libGAP_ADDR_OBJ(bag)) + limbnumber / 2;
    *p = (*p & 0xFFFFFFFF00000000UL) | (libGAP_UInt8)value;
  }
#else
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[2*limbnumber] = (libGAP_UInt2)(value & 0xFFFFUL);
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[2*limbnumber+1] = (libGAP_UInt2)(value >>16);
#endif
#endif  
}



static inline void C_SET_LIMB8(libGAP_Obj bag, libGAP_UInt limbnumber, libGAP_UInt8 value)  { 
#if libGAP_INTEGER_UNIT_SIZE == 8
  ((libGAP_UInt8 *)libGAP_ADDR_OBJ(bag))[limbnumber] = value;
#else
#if libGAP_INTEGER_UNIT_SIZE == 4
  ((libGAP_UInt4 *)libGAP_ADDR_OBJ(bag))[2*limbnumber] = (libGAP_UInt4)(value & 0xFFFFFFFFUL);
  ((libGAP_UInt4 *)libGAP_ADDR_OBJ(bag))[2*limbnumber+1] = (libGAP_UInt4)(value >>32);
#else
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[4*limbnumber] = (libGAP_UInt2)(value & 0xFFFFULL);
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[4*limbnumber+1] = (libGAP_UInt2)((value & 0xFFFF0000ULL) >>16);
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[4*limbnumber+2] = (libGAP_UInt2)((value & 0xFFFF00000000ULL) >>32);
  ((libGAP_UInt2 *)libGAP_ADDR_OBJ(bag))[4*limbnumber+3] = (libGAP_UInt2)(value >>48);
#endif
#endif
}

/* C_MAKE_MED_INT handles numbers between 2^28 and 2^60 in magnitude,
   and is used in code compiled on 64 bit systems. If the target system
   is 64 bit an immediate integer is constructed. If the target is 32 bits then
   an 8-byte large integer is constructed using the representation-neutral 
   macros above 

   C_NORMALIZE_64BIT is called when a large integer has been
   constructed (because the literal was large on the compiling system)
   and might be small on the target system. */

 
#ifdef libGAP_SYS_IS_64_BIT 
static inline libGAP_Obj C_MAKE_MED_INT( libGAP_Int8 value ) {
  return libGAP_INTOBJ_INT(value);
}

static inline libGAP_Obj C_NORMALIZE_64BIT(libGAP_Obj o) {
  libGAP_Int value =  *(libGAP_Int *)libGAP_ADDR_OBJ(o);
  if (value < 0)
    return o;
  if (libGAP_TNUM_OBJ(o) == libGAP_T_INTNEG)
    value = -value;
  if (-(1L << 60) <= value && value < (1L << 60))
    return libGAP_INTOBJ_INT(value);
  else
    return o;    
}


#else
static inline libGAP_Obj C_MAKE_MED_INT( libGAP_Int8 value ) {
  libGAP_Obj x;
  libGAP_UInt type;
  if (value < 0) {
    type = libGAP_T_INTNEG;
    value = -value;
  } else
    type = libGAP_T_INTPOS;

  x = C_MAKE_INTEGER_BAG(8,type);
  C_SET_LIMB8(x,0,(libGAP_UInt8)value);
  return x;
}

static inline libGAP_Obj C_NORMALIZE_64BIT( libGAP_Obj o) {
  return o;
}

#endif

#ifdef __cplusplus
}
#undef libGAP_GAP_IN_EXTERN_C
#endif
    
#endif // GAP_COMPILED_H

/****************************************************************************
**
*E  compiled.h  . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
*/
