/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfSmartCopy;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.SimpleBookmark;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SplitParsedCommand;
import org.pdfsam.console.business.pdf.bookmarks.BookmarksProcessor;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.SplitException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.console.utils.perfix.FileNameRequest;
import org.pdfsam.console.utils.perfix.PrefixParser;

public class SplitCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(SplitCmdExecutor.class.getPackage().getName());
    private PrefixParser prefixParser;
    private PdfSmartCopy pdfWriter = null;
    private PdfReader pdfReader = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof SplitParsedCommand) {
            SplitParsedCommand inputCommand = (SplitParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                this.prefixParser = new PrefixParser(inputCommand.getOutputFilesPrefix(), inputCommand.getInputFile().getFile().getName());
                if ("BURST".equals(inputCommand.getSplitType())) {
                    this.executeBurst(inputCommand);
                }
                if ("NSPLIT".equals(inputCommand.getSplitType())) {
                    this.executeNSplit(inputCommand);
                }
                if ("SPLIT".equals(inputCommand.getSplitType())) {
                    this.executeSplit(inputCommand);
                }
                if ("EVEN".equals(inputCommand.getSplitType()) || "ODD".equals(inputCommand.getSplitType())) {
                    this.executeSplitOddEven(inputCommand);
                }
                if ("SIZE".equals(inputCommand.getSplitType())) {
                    this.executeSizeSplit(inputCommand);
                }
                if ("BLEVEL".equals(inputCommand.getSplitType())) {
                    this.executeBookmarksSplit(inputCommand);
                }
                throw new SplitException(3, new String[]{inputCommand.getSplitType()});
            }
            catch (Exception e) {
                throw new SplitException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    private void executeBurst(SplitParsedCommand inputCommand) throws Exception {
        this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
        this.pdfReader.removeUnusedObjects();
        this.pdfReader.consolidateNamedDestinations();
        int n = this.pdfReader.getNumberOfPages();
        int fileNum = 0;
        LOG.info("Found " + n + " pages in input pdf document.");
        for (int currentPage = 1; currentPage <= n; ++currentPage) {
            LOG.debug("Creating a new document.");
            File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
            FileNameRequest request = new FileNameRequest(currentPage, ++fileNum, null);
            File outFile = new File(inputCommand.getOutputFile().getCanonicalPath(), this.prefixParser.generateFileName(request));
            Document currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(currentPage));
            this.pdfWriter = new PdfSmartCopy(currentDocument, (OutputStream)new FileOutputStream(tmpFile));
            currentDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
            this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
            this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter, Character.valueOf(this.pdfReader.getPdfVersion()));
            currentDocument.open();
            PdfImportedPage importedPage = this.pdfWriter.getImportedPage(this.pdfReader, currentPage);
            this.pdfWriter.addPage(importedPage);
            currentDocument.close();
            FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
            LOG.debug("File " + outFile.getCanonicalPath() + " created.");
            this.setPercentageOfWorkDone(currentPage * 1000 / n);
        }
        this.pdfReader.close();
        LOG.info("Burst done.");
    }

    private void executeSplitOddEven(SplitParsedCommand inputCommand) throws Exception {
        this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
        this.pdfReader.removeUnusedObjects();
        this.pdfReader.consolidateNamedDestinations();
        int n = this.pdfReader.getNumberOfPages();
        int fileNum = 0;
        LOG.info("Found " + n + " pages in input pdf document.");
        Document currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(1));
        boolean isTimeToClose = false;
        File tmpFile = null;
        File outFile = null;
        for (int currentPage = 1; currentPage <= n; ++currentPage) {
            boolean bl = isTimeToClose = currentPage != 1 && ("ODD".equals(inputCommand.getSplitType()) && currentPage % 2 != 0 || "EVEN".equals(inputCommand.getSplitType()) && currentPage % 2 == 0);
            if (!isTimeToClose) {
                LOG.debug("Creating a new document.");
                tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                FileNameRequest request = new FileNameRequest(currentPage, ++fileNum, null);
                outFile = new File(inputCommand.getOutputFile(), this.prefixParser.generateFileName(request));
                currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(currentPage));
                this.pdfWriter = new PdfSmartCopy(currentDocument, (OutputStream)new FileOutputStream(tmpFile));
                currentDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter, Character.valueOf(this.pdfReader.getPdfVersion()));
                currentDocument.open();
            }
            PdfImportedPage importedPage = this.pdfWriter.getImportedPage(this.pdfReader, currentPage);
            this.pdfWriter.addPage(importedPage);
            if (isTimeToClose || currentPage == n || currentPage == 1 && "ODD".equals(inputCommand.getSplitType())) {
                currentDocument.close();
                FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                LOG.debug("File " + outFile.getCanonicalPath() + " created.");
            }
            this.setPercentageOfWorkDone(currentPage * 1000 / n);
        }
        this.pdfReader.close();
        LOG.info("Split " + inputCommand.getSplitType() + " done.");
    }

    private void executeSplit(SplitParsedCommand inputCommand) throws Exception {
        this.executeSplit(inputCommand, null);
    }

    private void executeSplit(SplitParsedCommand inputCommand, Hashtable bookmarksTable) throws Exception {
        this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
        this.pdfReader.removeUnusedObjects();
        this.pdfReader.consolidateNamedDestinations();
        int n = this.pdfReader.getNumberOfPages();
        BookmarksProcessor bookmarkProcessor = new BookmarksProcessor(SimpleBookmark.getBookmark((PdfReader)this.pdfReader), n);
        int fileNum = 0;
        LOG.info("Found " + n + " pages in input pdf document.");
        Integer[] limits = inputCommand.getSplitPageNumbers();
        TreeSet limitsList = this.validateSplitLimits(limits, n);
        if (limitsList.isEmpty()) {
            throw new SplitException(1);
        }
        Document currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(1));
        int relativeCurrentPage = 0;
        int endPage = n;
        int startPage = 1;
        File tmpFile = null;
        File outFile = null;
        Iterator itr = limitsList.iterator();
        if (itr.hasNext()) {
            endPage = (Integer)itr.next();
        }
        for (int currentPage = 1; currentPage <= n; ++currentPage) {
            if (++relativeCurrentPage == 1) {
                LOG.debug("Creating a new document.");
                ++fileNum;
                tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                String bookmark = null;
                if (bookmarksTable != null && bookmarksTable.size() > 0) {
                    bookmark = (String)bookmarksTable.get(new Integer(currentPage));
                }
                FileNameRequest request = new FileNameRequest(currentPage, fileNum, bookmark);
                outFile = new File(inputCommand.getOutputFile(), this.prefixParser.generateFileName(request));
                startPage = currentPage;
                currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(currentPage));
                this.pdfWriter = new PdfSmartCopy(currentDocument, (OutputStream)new FileOutputStream(tmpFile));
                currentDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter, Character.valueOf(this.pdfReader.getPdfVersion()));
                currentDocument.open();
            }
            PdfImportedPage importedPage = this.pdfWriter.getImportedPage(this.pdfReader, currentPage);
            this.pdfWriter.addPage(importedPage);
            if (currentPage == endPage) {
                LOG.info("Temporary document " + tmpFile.getName() + " done, now adding bookmarks...");
                List bookmarks = bookmarkProcessor.processBookmarks(startPage, endPage);
                if (bookmarks != null) {
                    this.pdfWriter.setOutlines(bookmarks);
                }
                relativeCurrentPage = 0;
                currentDocument.close();
                FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                LOG.debug("File " + outFile.getCanonicalPath() + " created.");
                endPage = itr.hasNext() ? (Integer)itr.next() : n;
            }
            this.setPercentageOfWorkDone(currentPage * 1000 / n);
        }
        this.pdfReader.close();
        LOG.info("Split " + inputCommand.getSplitType() + " done.");
    }

    private void executeNSplit(SplitParsedCommand inputCommand) throws Exception {
        Integer[] numberPages = inputCommand.getSplitPageNumbers();
        if (numberPages != null && numberPages.length == 1) {
            this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
            this.pdfReader.removeUnusedObjects();
            this.pdfReader.consolidateNamedDestinations();
            int n = this.pdfReader.getNumberOfPages();
            int numberPage = numberPages[0];
            if (numberPage < 1 || numberPage > n) {
                this.pdfReader.close();
                throw new SplitException(2, new String[]{"" + numberPage});
            }
            ArrayList<Integer> retVal = new ArrayList<Integer>();
            for (int i = numberPage; i < n; i += numberPage) {
                retVal.add(new Integer(i));
            }
            inputCommand.setSplitPageNumbers(retVal.toArray(new Integer[0]));
            this.pdfReader.close();
        }
        this.executeSplit(inputCommand);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void executeBookmarksSplit(SplitParsedCommand inputCommand) throws Exception {
        String headBookmarkXQuery;
        this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
        int bLevel = inputCommand.getBookmarksLevel();
        Hashtable<Integer, String> bookmarksTable = new Hashtable<Integer, String>();
        if (bLevel <= 0) {
            this.pdfReader.close();
            throw new SplitException(4, new String[]{"" + bLevel});
        }
        this.pdfReader.removeUnusedObjects();
        this.pdfReader.consolidateNamedDestinations();
        List bookmarks = SimpleBookmark.getBookmark((PdfReader)this.pdfReader);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimpleBookmark.exportToXML((List)bookmarks, (OutputStream)out, (String)"UTF-8", (boolean)false);
        ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
        int maxDepth = PdfUtility.getMaxBookmarksDepth(input);
        input.reset();
        if (bLevel > maxDepth) {
            input.close();
            this.pdfReader.close();
            throw new SplitException(5, new String[]{"" + bLevel, "" + maxDepth});
        }
        SAXReader reader = new SAXReader();
        org.dom4j.Document document = reader.read(input);
        Node headNode = document.selectSingleNode(headBookmarkXQuery = "/Bookmark/Title[@Action=\"GoTo\"]");
        if (headNode != null && headNode.getText() != null && headNode.getText().trim().length() > 0) {
            bookmarksTable.put(new Integer(1), headNode.getText().trim());
        }
        StringBuffer buffer = new StringBuffer("/Bookmark");
        for (int i = 0; i < bLevel; ++i) {
            buffer.append("/Title[@Action=\"GoTo\"]");
        }
        String xQuery = buffer.toString();
        List nodes = document.selectNodes(xQuery);
        input.close();
        input = null;
        if (nodes != null && nodes.size() > 0) {
            LinkedHashSet<Integer> pageSet = new LinkedHashSet<Integer>(nodes.size());
            Iterator nodeIter = nodes.iterator();
            while (nodeIter.hasNext()) {
                String attribute;
                int blankIndex;
                Node currentNode = (Node)nodeIter.next();
                Node pageAttribute = currentNode.selectSingleNode("@Page");
                if (pageAttribute == null || pageAttribute.getText().length() <= 0 || (blankIndex = (attribute = pageAttribute.getText()).indexOf(32)) <= 0) continue;
                Integer currentNumber = new Integer(attribute.substring(0, blankIndex));
                String bookmarkText = currentNode.getText().trim();
                if (currentNumber <= 0 || !StringUtils.isBlank((String)inputCommand.getBookmarkRegexp()) && !bookmarkText.matches(inputCommand.getBookmarkRegexp())) continue;
                if (currentNumber > 1) {
                    pageSet.add(new Integer(currentNumber - 1));
                }
                if (!StringUtils.isNotBlank((String)bookmarkText)) continue;
                bookmarksTable.put(currentNumber, bookmarkText.trim());
            }
            if (pageSet.size() <= 0) {
                throw new SplitException(6, new String[]{"" + bLevel});
            }
            if (StringUtils.isBlank((String)inputCommand.getBookmarkRegexp())) {
                LOG.debug("Found " + pageSet.size() + " destination pages at level " + bLevel);
            } else {
                LOG.debug("Found " + pageSet.size() + " destination pages at level " + bLevel + " matching '" + inputCommand.getBookmarkRegexp() + "'");
            }
            inputCommand.setSplitPageNumbers(pageSet.toArray(new Integer[pageSet.size()]));
            this.pdfReader.close();
            this.executeSplit(inputCommand, bookmarksTable);
            return;
        }
        throw new SplitException(6, new String[]{"" + bLevel});
    }

    private void executeSizeSplit(SplitParsedCommand inputCommand) throws Exception {
        this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
        this.pdfReader.removeUnusedObjects();
        this.pdfReader.consolidateNamedDestinations();
        int n = this.pdfReader.getNumberOfPages();
        BookmarksProcessor bookmarkProcessor = new BookmarksProcessor(SimpleBookmark.getBookmark((PdfReader)this.pdfReader), n);
        int fileNum = 0;
        LOG.info("Found " + n + " pages in input pdf document.");
        Document currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(1));
        File tmpFile = null;
        File outFile = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int startPage = 0;
        int relativeCurrentPage = 0;
        for (int currentPage = 1; currentPage <= n; ++currentPage) {
            if (++relativeCurrentPage == 1) {
                LOG.debug("Creating a new document.");
                startPage = currentPage;
                tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                FileNameRequest request = new FileNameRequest(currentPage, ++fileNum, null);
                outFile = new File(inputCommand.getOutputFile(), this.prefixParser.generateFileName(request));
                currentDocument = new Document(this.pdfReader.getPageSizeWithRotation(currentPage));
                baos = new ByteArrayOutputStream();
                this.pdfWriter = new PdfSmartCopy(currentDocument, (OutputStream)baos);
                currentDocument.addCreator("pdfsam-console (Ver. 2.4.3e)");
                this.setCompressionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter);
                this.setPdfVersionSettingOnWriter(inputCommand, (PdfWriter)this.pdfWriter, Character.valueOf(this.pdfReader.getPdfVersion()));
                currentDocument.open();
            }
            PdfImportedPage importedPage = this.pdfWriter.getImportedPage(this.pdfReader, currentPage);
            this.pdfWriter.addPage(importedPage);
            if (currentPage == n || relativeCurrentPage > 1 && (long)(baos.size() / relativeCurrentPage * (1 + relativeCurrentPage)) > inputCommand.getSplitSize()) {
                LOG.debug("Current stream size: " + baos.size() + " bytes.");
                List bookmarks = bookmarkProcessor.processBookmarks(startPage, currentPage);
                if (bookmarks != null) {
                    this.pdfWriter.setOutlines(bookmarks);
                }
                relativeCurrentPage = 0;
                currentDocument.close();
                FileOutputStream fos = new FileOutputStream(tmpFile);
                baos.writeTo(fos);
                fos.close();
                baos.close();
                LOG.info("Temporary document " + tmpFile.getName() + " done.");
                FileUtility.renameTemporaryFile(tmpFile, outFile, inputCommand.isOverwrite());
                LOG.debug("File " + outFile.getCanonicalPath() + " created.");
            }
            this.setPercentageOfWorkDone(currentPage * 1000 / n);
        }
        this.pdfReader.close();
        LOG.info("Split " + inputCommand.getSplitType() + " done.");
    }

    private TreeSet validateSplitLimits(Integer[] limits, int upperLimit) {
        TreeSet<Integer> limitsList = new TreeSet<Integer>();
        for (int j = 0; j < limits.length; ++j) {
            if (limits[j] <= 0 || limits[j] >= upperLimit) {
                LOG.warn("Cannot split before page number " + limits[j] + ", limit removed.");
                continue;
            }
            if (limitsList.add(limits[j])) continue;
            LOG.warn(limits[j] + " found more than once in the page limits list, limit removed.");
        }
        return limitsList;
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfWriter((PdfWriter)this.pdfWriter);
    }
}

