/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font;

import de.intarsys.cwt.font.CommonFont;
import de.intarsys.cwt.font.FontStyle;
import de.intarsys.cwt.font.FontTools;
import de.intarsys.cwt.font.GenericFontProgram;
import de.intarsys.cwt.font.IFont;
import de.intarsys.cwt.freetype.Face;
import de.intarsys.tools.locator.ILocator;

public class GenericFont
extends CommonFont {
    private String fontType;
    private String fontName;
    private String fontNamePostScript;
    private String fontFamilyName;
    private FontStyle fontStyle;

    public static GenericFont createNew(ILocator iLocator, Face face) {
        Object object;
        String string = face.getPostscriptName();
        String string2 = face.getFamilyName();
        String string3 = face.getStyleName();
        String string4 = null;
        int n = face.getSfntNameCount();
        int n2 = 0;
        while (n2 < n) {
            object = face.getSfntName(n2);
            if (object.getNameId() == 4) {
                string4 = object.getName();
                if (object.getPlatformId() == 3) break;
            }
            ++n2;
        }
        if (string == null) {
            string = string2;
        }
        if (string4 == null) {
            string4 = string;
        }
        FontStyle fontStyle = FontStyle.getFontStyle(string3);
        object = new GenericFont();
        GenericFontProgram genericFontProgram = new GenericFontProgram((IFont)object, iLocator);
        ((CommonFont)object).setFontProgram(genericFontProgram);
        ((GenericFont)object).setFontFamilyName(string2);
        ((GenericFont)object).setFontNamePostScript(string);
        ((GenericFont)object).setFontName(string4);
        ((GenericFont)object).setFontStyle(fontStyle);
        String string5 = iLocator.getType();
        if (string5 != null) {
            string5 = string5.toLowerCase();
        }
        if ("ttf".equals(string5) || "ttc".equals(string5) || "otf".equals(string5) || "otc".equals(string5)) {
            ((GenericFont)object).setFontType("TrueType");
        } else if ("pfb".equals(string5)) {
            ((GenericFont)object).setFontType("Type1");
        } else {
            ((GenericFont)object).setFontType("Unknown");
        }
        return object;
    }

    protected GenericFont() {
    }

    @Override
    public String getFontFamilyName() {
        return this.fontFamilyName;
    }

    @Override
    public String getFontName() {
        return this.fontName;
    }

    @Override
    public String getFontNameCanonical() {
        String string = null;
        FontStyle fontStyle = null;
        string = this.getFontFamilyName() == null ? FontTools.getFontFamilyName(this.getFontName()) : this.getFontFamilyName();
        fontStyle = this.getFontStyle() == null ? FontTools.getFontStyle(this.getFontName()) : this.getFontStyle();
        return FontTools.createCanonicalName(string, fontStyle.getId());
    }

    @Override
    public String getFontNamePostScript() {
        return this.fontNamePostScript;
    }

    @Override
    public FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Override
    public String getFontType() {
        return this.fontType;
    }

    protected void setFontFamilyName(String string) {
        this.fontFamilyName = string;
    }

    protected void setFontName(String string) {
        this.fontName = string;
    }

    protected void setFontNamePostScript(String string) {
        this.fontNamePostScript = string;
    }

    protected void setFontStyle(FontStyle fontStyle) {
        this.fontStyle = fontStyle;
    }

    protected void setFontType(String string) {
        this.fontType = string;
    }
}

