/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.utils.PdfVersionUtility;
import org.pdfsam.i18n.GettextResource;

public class JPdfVersionCombo
extends JComboBox {
    private static final long serialVersionUID = -5004011941231451770L;
    public static final String SAME_AS_SOURCE = "1000";
    private Configuration config;
    private boolean addSameAsSourceItem = false;
    private Vector<Integer> filterVersions = new Vector();
    private int fullSize = 0;

    public JPdfVersionCombo() {
        this(false);
    }

    public JPdfVersionCombo(boolean addSameAsSourceItem) {
        this.config = Configuration.getInstance();
        this.init(addSameAsSourceItem);
        this.fullSize = this.getModel().getSize();
        this.setEnabled(true);
    }

    private void init(boolean addSameAsSourceItem, boolean checkFilters) {
        this.removeAllItems();
        this.addSameAsSourceItem = addSameAsSourceItem;
        if (addSameAsSourceItem) {
            this.addItem(new StringItem(SAME_AS_SOURCE, GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Same as input document")));
        }
        ArrayList<StringItem> values = PdfVersionUtility.getVersionsList();
        Integer maxFilter = -1;
        if (checkFilters && !this.filterVersions.isEmpty()) {
            maxFilter = Collections.max(this.filterVersions);
        }
        for (StringItem currentItem : values) {
            if (currentItem == null || new Integer(currentItem.getId()).compareTo(maxFilter) < 0) continue;
            this.addItem(currentItem);
        }
    }

    private void init(boolean addSameAsSourceItem) {
        this.init(addSameAsSourceItem, false);
        this.setSelectedIndex(this.getModel().getSize() - 3);
    }

    public synchronized void addVersionFilter(Integer version) {
        ArrayList<StringItem> removeList = new ArrayList<StringItem>();
        this.filterVersions.add(version);
        Integer maxFilter = Collections.max(this.filterVersions);
        Object item = this.getSelectedItem();
        for (int i = 0; i < this.getItemCount(); ++i) {
            StringItem currentItem = (StringItem)this.getItemAt(i);
            if (currentItem == null || maxFilter.compareTo(new Integer(currentItem.getId())) <= 0) continue;
            removeList.add(currentItem);
            if (!currentItem.equals(item)) continue;
            item = null;
        }
        if (removeList.size() > 0) {
            for (StringItem currentItem : removeList) {
                this.removeItem(currentItem);
            }
        }
        if (this.getItemCount() == 0) {
            this.setEnabled(false);
        } else if (item == null) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedItem(item);
        }
    }

    public synchronized void removeVersionFilter(Integer version) {
        if (this.filterVersions.remove(version)) {
            if (this.filterVersions.isEmpty()) {
                this.removeFilters();
            } else {
                Integer maxFilter = Collections.max(this.filterVersions);
                if (maxFilter.compareTo(version) < 0) {
                    Object item = this.getSelectedItem();
                    this.removeAllItems();
                    this.init(this.addSameAsSourceItem, true);
                    if (item != null) {
                        this.setSelectedItem(item);
                    }
                }
            }
        }
    }

    public synchronized void removeFilters() {
        if (this.getModel().getSize() < this.fullSize) {
            Object item = this.getSelectedItem();
            this.filterVersions.clear();
            this.removeAllItems();
            this.init(this.addSameAsSourceItem);
            if (item != null) {
                this.setSelectedItem(item);
            }
        }
    }

    public void resetComponent() {
        this.filterVersions.clear();
        this.init(this.addSameAsSourceItem);
    }

    public StringItem getMinItem() {
        StringItem minItem = null;
        for (int i = 0; i < this.getItemCount(); ++i) {
            StringItem currentItem = (StringItem)this.getItemAt(i);
            if (minItem != null) {
                if (currentItem == null || new Integer(minItem.getId()).compareTo(new Integer(currentItem.getId())) <= 0) continue;
                minItem = currentItem;
                continue;
            }
            minItem = currentItem;
        }
        return minItem;
    }
}

