/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.cos.ICOSProxyVisitor;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.collection.EmptyIterator;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public abstract class COSObjectProxy
extends COSCompositeObject
implements Cloneable {
    private long position = -1L;
    private int length;
    private COSObject object;

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        if (this.object != null) {
            return this.object.accept(iCOSObjectVisitor);
        }
        if (iCOSObjectVisitor instanceof ICOSProxyVisitor) {
            return ((ICOSProxyVisitor)((Object)iCOSObjectVisitor)).visitFromProxy(this);
        }
        return null;
    }

    public Iterator basicIterator() {
        if (this.object == null) {
            return EmptyIterator.UNIQUE;
        }
        return this.object.basicIterator();
    }

    @Override
    protected String basicToString() {
        if (this.object == null) {
            return "COSObjectProxy: empty";
        }
        return this.object.stringValue();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    protected COSObject copyBasic() {
        COSObjectProxy cOSObjectProxy = (COSObjectProxy)this.clone();
        cOSObjectProxy.reserveData(this.getLength());
        return cOSObjectProxy;
    }

    @Override
    public COSObject copyDeep(Map map) {
        if (this.object != null) {
            return this.object.copyDeep(map);
        }
        return super.copyDeep(map);
    }

    @Override
    public COSObject copyShallow() {
        if (this.object != null) {
            return this.object.copyShallow();
        }
        return super.copyShallow();
    }

    public COSObject cosGetObject() {
        return this.object == null ? COSNull.NULL : this.object;
    }

    protected abstract COSObject createCOSObject(IRandomAccess var1) throws IOException;

    @Override
    public COSObject dereference() {
        return this.object == null ? this : this.object;
    }

    public void ended(COSWriter cOSWriter) throws IOException {
        if (this.object != null) {
            return;
        }
        IOException iOException = null;
        IRandomAccess iRandomAccess = cOSWriter.getRandomAccess();
        iRandomAccess.mark();
        try {
            try {
                this.object = this.createCOSObject(iRandomAccess);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            iRandomAccess.seek(this.getPosition());
            if (this.object != null) {
                cOSWriter.writeObject(this.object);
            } else {
                cOSWriter.writeObject(COSNull.create());
            }
            long l = this.getPosition() + (long)this.getLength();
            if (iRandomAccess.getOffset() < l) {
                long l2 = l - iRandomAccess.getOffset();
                byte[] byArray = new byte[(int)l2];
                Arrays.fill(byArray, (byte)32);
                cOSWriter.write(byArray);
            } else if (iRandomAccess.getOffset() > l) {
                throw new IOException("Destroyed document, wrote more bytes than reserved!");
            }
            if (iOException != null) {
                throw iOException;
            }
        }
        finally {
            iRandomAccess.reset();
        }
    }

    public int getLength() {
        return this.length;
    }

    public COSObject getObject() {
        return this.object;
    }

    public long getPosition() {
        return this.position;
    }

    @Override
    public Iterator iterator() {
        if (this.object == null) {
            return EmptyIterator.UNIQUE;
        }
        return this.object.iterator();
    }

    @Override
    public boolean mayBeSwapped() {
        return false;
    }

    public void reserveData(int n) {
        this.length = n;
    }

    public Object saveState() {
        return null;
    }

    protected void setObject(COSObject cOSObject) {
        this.object = cOSObject;
    }

    public void setPosition(long l) {
        this.position = l;
    }
}

