/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control.util;

import com.baselet.control.util.CanOpenDiagram;
import com.baselet.control.util.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.TimerTask;

public class RunningFileChecker
extends TimerTask {
    private final File file;
    private final File ok_file;
    private final CanOpenDiagram canOpenDiagram;

    public RunningFileChecker(String filename, String okfile, CanOpenDiagram canOpenDiagram) {
        this.canOpenDiagram = canOpenDiagram;
        this.file = new File(filename);
        this.ok_file = new File(okfile);
    }

    @Override
    public void run() {
        try {
            Utils.safeCreateFile(this.file, false);
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String filename = reader.readLine();
            reader.close();
            if (filename != null) {
                Utils.safeCreateFile(this.ok_file, true);
                Utils.safeDeleteFile(this.file, false);
                Utils.safeCreateFile(this.file, true);
                this.canOpenDiagram.doOpen(filename);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

