/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.element.elementnew.plot.parser.DataSet;
import com.baselet.element.elementnew.plot.parser.KeyValue;
import com.baselet.element.elementnew.plot.parser.ParserException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class PlotState {
    private final List<PlotState> subPlots = new ArrayList<PlotState>();
    private DataSet dataset;
    private final HashMap<String, KeyValue> values;
    private final int plotLineNr;

    protected PlotState(int n, HashMap<String, KeyValue> hashMap) {
        this.plotLineNr = n;
        this.values = hashMap;
    }

    protected void setDataSet(DataSet dataSet) {
        this.dataset = dataSet;
    }

    public void addSubPlot(PlotState plotState) {
        this.subPlots.add(plotState);
    }

    public List<PlotState> getSubplots() {
        return this.subPlots;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }

    public boolean containsKey(String string) {
        return this.values.containsKey(string);
    }

    public int getLine(String string) {
        if (this.values.get(string) != null) {
            return this.values.get(string).getLine();
        }
        return -1;
    }

    public int getPlotLineNr() {
        return this.plotLineNr;
    }

    public String getValue(String string, String string2) {
        KeyValue keyValue = this.values.get(string);
        if (keyValue != null) {
            keyValue.setUsed(true);
        }
        if (keyValue == null || keyValue.getValue().equals("auto")) {
            return string2;
        }
        return keyValue.getValue();
    }

    public String getValueValidated(String string, String string2, List<String> list) {
        String string3 = this.getValue(string, string2);
        if (!list.contains(string3)) {
            throw new ParserException(string, string3, this.getLine(string));
        }
        return string3;
    }

    public Double getValueAsDouble(String string, Double d) {
        try {
            String string2 = this.getValue(string, null);
            if (string2 == null) {
                return d;
            }
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            throw new ParserException(string, this.values.get(string).getValue(), this.values.get(string).getLine());
        }
    }

    public Integer getValueAsInt(String string, Integer n) {
        try {
            String string2 = this.getValue(string, null);
            if (string2 == null) {
                return n;
            }
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new ParserException(string, this.values.get(string).getValue(), this.values.get(string).getLine());
        }
    }

    public Boolean getValueAsBoolean(String string, Boolean bl) {
        String string2 = this.getValue(string, null);
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        throw new ParserException(string, this.values.get(string).getValue(), this.values.get(string).getLine());
    }

    public List<String> getValueList(String string, List<String> list) {
        String string2 = this.getValue(string, null);
        List<String> list2 = string2 == null ? list : Arrays.asList(string2.split(","));
        return list2;
    }

    public List<String> getValueListValidated(String string, List<String> list, List<String> list2, boolean bl) {
        List<String> list3 = this.getValueList(string, list);
        for (String string2 : list3) {
            boolean bl2;
            boolean bl3 = bl2 = bl && this.isDoubleValue(string2);
            if (list2.contains(string2) || bl2) continue;
            throw new ParserException(string, string2, this.getLine(string));
        }
        return list3;
    }

    private boolean isDoubleValue(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void checkIfAllValuesUsed() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (KeyValue keyValue : this.values.values()) {
            if (keyValue.isUsed()) continue;
            stringBuilder.append("\"").append(keyValue.getKey()).append("=").append(keyValue.getValue()).append("\" (line ").append(keyValue.getLine()).append(") ");
        }
        String string = stringBuilder.toString();
        if (!string.isEmpty()) {
            throw new ParserException("Invalid variables: " + (String)string);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("PlotState (").append(this.plotLineNr).append(")\n");
        if (this.dataset != null) {
            stringBuilder.append("\tdataset -> ").append(this.dataset.getLineNr()).append("\n");
        }
        for (KeyValue object : this.values.values()) {
            stringBuilder.append("\t").append(object).append("\n");
        }
        if (!this.subPlots.isEmpty()) {
            stringBuilder.append("---Begin Subplots---\n");
            for (PlotState plotState : this.subPlots) {
                stringBuilder.append(plotState.toString());
            }
            stringBuilder.append("---End Subplots---\n");
        }
        return stringBuilder.toString();
    }
}

