/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet;

import com.baselet.control.enums.FormatLabels;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.Facet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class KeyValueFacet
extends Facet {
    public static final String SEP = "=";

    public abstract KeyValue getKeyValue();

    public abstract void handleValue(String var1, PropertiesParserState var2);

    @Override
    public boolean checkStart(String string, PropertiesParserState propertiesParserState) {
        return string.startsWith(this.getKeyWithSep());
    }

    @Override
    public void handleLine(String string, PropertiesParserState propertiesParserState) {
        String string2 = this.extractValue(string);
        try {
            this.handleValue(string2, propertiesParserState);
        }
        catch (Exception exception) {
            this.log.debug((Object)"KeyValue Error", (Throwable)exception);
            String string3 = this.getKeyValue().getValueString();
            if (exception instanceof StyleException) {
                string3 = exception.getMessage();
            }
            throw new RuntimeException(FormatLabels.BOLD.getValue() + "Invalid value:" + FormatLabels.BOLD.getValue() + "\n" + this.getKeyWithSep() + string2 + "\n" + string3);
        }
    }

    protected String extractValue(String string) {
        return string.substring(this.getKeyWithSep().length());
    }

    @Override
    public List<AutocompletionText> getAutocompletionStrings() {
        ArrayList<AutocompletionText> arrayList = new ArrayList<AutocompletionText>();
        for (ValueInfo valueInfo : this.getKeyValue().getValueInfos()) {
            arrayList.add(new AutocompletionText(this.getKeyWithSep() + valueInfo.getValue().toString().toLowerCase(), valueInfo.getInfo(), valueInfo.getBase64Img()));
        }
        return arrayList;
    }

    public String getKeyWithSep() {
        return this.getKeyValue().getKey() + SEP;
    }

    public static class ValueInfo {
        private final Object value;
        private final String info;
        private final String base64Img;

        public ValueInfo(Object object, String string) {
            this(object, string, null);
        }

        public ValueInfo(Object object, String string, String string2) {
            this.value = object;
            this.info = string;
            this.base64Img = string2;
        }

        public Object getValue() {
            return this.value;
        }

        private String getInfo() {
            return this.info;
        }

        private String getBase64Img() {
            return this.base64Img;
        }
    }

    public static class KeyValue {
        private final String key;
        private final boolean allValuesListed;
        private final List<ValueInfo> valueInfos;

        public KeyValue(String string, boolean bl, String string2, String string3) {
            this.key = string.toLowerCase();
            this.allValuesListed = bl;
            this.valueInfos = Arrays.asList(new ValueInfo(string2, string3));
        }

        public KeyValue(String string, ValueInfo ... valueInfoArray) {
            this.key = string;
            this.allValuesListed = true;
            this.valueInfos = Arrays.asList(valueInfoArray);
        }

        public String getKey() {
            return this.key;
        }

        public List<ValueInfo> getValueInfos() {
            return this.valueInfos;
        }

        public String getValueString() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.allValuesListed) {
                stringBuilder.append("Valid are: ");
                for (ValueInfo valueInfo : this.valueInfos) {
                    stringBuilder.append(valueInfo.value.toString().toLowerCase()).append(',');
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            } else {
                for (ValueInfo valueInfo : this.valueInfos) {
                    stringBuilder.append(valueInfo.info);
                }
            }
            return stringBuilder.toString();
        }
    }
}

