/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.enums.LineType;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.diagram.draw.helper.Style;
import com.baselet.diagram.draw.helper.StyleException;
import com.baselet.element.facet.FirstRunKeyValueFacet;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import com.baselet.element.sticking.polygon.PointDoubleStickingPolygonGenerator;
import com.baselet.element.sticking.polygon.SimpleStickingPolygonGenerator;
import java.util.Arrays;
import java.util.List;

public class TemplateClassFacet
extends FirstRunKeyValueFacet {
    public static final TemplateClassFacet INSTANCE = new TemplateClassFacet();
    public static final int UPPER_SPACE = 3;
    public static final int LOWER_SPACE = 3;
    public static final int LEFT_SPACE = 12;

    private TemplateClassFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("template", new KeyValueFacet.ValueInfo("text", "print template rectangle on top right corner"));
    }

    @Override
    public void handleValue(String string, PropertiesParserState propertiesParserState) {
    }

    private static int round(double d) {
        return SharedUtils.realignToGrid(false, d, true);
    }

    @Override
    public void parsingFinished(PropertiesParserState propertiesParserState, List<String> list) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        int n = propertiesParserState.getGridElementSize().getHeight();
        int n2 = propertiesParserState.getGridElementSize().getWidth();
        if (list.isEmpty()) {
            drawHandler.drawRectangle(0.0, 0.0, n2, n);
            propertiesParserState.setStickingPolygonGenerator(SimpleStickingPolygonGenerator.INSTANCE);
        } else if (list.size() == 1) {
            List<PointDouble> list2 = TemplateClassFacet.drawTemplateClass(this.extractValue(list.get(0)), drawHandler, propertiesParserState, n, n2);
            propertiesParserState.setStickingPolygonGenerator(new PointDoubleStickingPolygonGenerator(list2));
        } else {
            throw new StyleException("Only one class template is allowed");
        }
    }

    private static List<PointDouble> drawTemplateClass(String string, DrawHandler drawHandler, PropertiesParserState propertiesParserState, int n, int n2) {
        Rectangle rectangle = TemplateClassFacet.calcTemplateRect(string, drawHandler, n2);
        int n3 = TemplateClassFacet.round((double)rectangle.getHeight() / 2.0);
        int n4 = n2 - TemplateClassFacet.round((double)rectangle.getWidth() / 2.0);
        PointDouble pointDouble = new PointDouble(0.0, n3);
        List<PointDouble> list = Arrays.asList(pointDouble, new PointDouble(rectangle.getX(), n3), new PointDouble(rectangle.getX(), 0.0), new PointDouble(n2, 0.0), new PointDouble(n2, rectangle.getHeight()), new PointDouble(n4, rectangle.getHeight()), new PointDouble(n4, n), new PointDouble(0.0, n), pointDouble);
        propertiesParserState.getBuffer().setTopMin(rectangle.getHeight());
        propertiesParserState.getBuffer().addToRight(n2 - n4);
        Style style = drawHandler.getStyleClone();
        drawHandler.setForegroundColor(ColorOwn.TRANSPARENT);
        drawHandler.drawLines(list);
        drawHandler.setStyle(style);
        drawHandler.setLineType(LineType.DASHED);
        drawHandler.setBackgroundColor(ColorOwn.TRANSPARENT);
        drawHandler.drawRectangle(rectangle);
        drawHandler.setStyle(style);
        drawHandler.drawLines(list.get(1), list.get(0), list.get(7), list.get(6), list.get(5));
        drawHandler.print(string, (double)n2 - drawHandler.getDistanceBorderToText(), rectangle.getHeight() - 3, AlignHorizontal.RIGHT);
        return list;
    }

    private static Rectangle calcTemplateRect(String string, DrawHandler drawHandler, int n) {
        double d = drawHandler.textHeightMax() + 3.0 + 3.0;
        double d2 = drawHandler.textWidth(string) + 12.0;
        Rectangle rectangle = new Rectangle((double)n - d2, 0.0, d2, d);
        return rectangle;
    }
}

