/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.vcomposer.GUI;

import com.lowagie.text.pdf.codec.Base64;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.models.VisualListModel;
import org.pdfsam.guiclient.commons.panels.JVisualMultiSelectionPanel;
import org.pdfsam.guiclient.commons.panels.JVisualPdfPageSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfFile;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.dto.VisualPageListItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.vcomposer.listeners.RunButtonActionListener;

public class VComposerMainGUI
extends AbstractPlugablePanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -3265981976255542241L;
    private static final String DEFAULT_OUPUT_NAME = "composed_file.pdf";
    private static final Logger log = Logger.getLogger((String)VComposerMainGUI.class.getPackage().getName());
    private JTextField destinationFileText = CommonComponentsFactory.getInstance().createTextField(1);
    private JHelpLabel destinationHelpLabel;
    private Configuration config;
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo(false);
    private JVisualPdfPageSelectionPanel composerPanel = new JVisualPdfPageSelectionPanel(1, false, true, true, 2, 2, 1);
    private JSplitPane lowerSplitPanel = null;
    private JSplitPane higherSplitPanel = null;
    private SpringLayout destinationPanelLayout;
    private final JButton browseDestButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final JButton moveToBottomButton = new JButton();
    private final JButton moveOnTopButton = new JButton();
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private final EnterDoClickListener browsedEnterkeyListener = new EnterDoClickListener(this.browseDestButton);
    private final EnterDoClickListener runEnterkeyListener = new EnterDoClickListener(this.runButton);
    private final JPanel destinationPanel = new JPanel();
    private final JVisualMultiSelectionPanel inputPanel = new JVisualMultiSelectionPanel();
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private final VisualComposerPolicy visualComposerFocusPolicy = new VisualComposerPolicy();
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.0.8";

    public VComposerMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/vcomposer.png");
        this.setPreferredSize(new Dimension(500, 700));
        this.setLayout(new GridBagLayout());
        this.inputPanel.setOutputPathPropertyChangeListener((PropertyChangeListener)this);
        this.inputPanel.setPreferredSize(new Dimension(180, 180));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 2));
        this.moveOnTopButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveOnTopButton.setIcon(new ImageIcon(this.getClass().getResource("/images/movetop.png")));
        this.moveOnTopButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move on top"));
        this.moveOnTopButton.setHorizontalTextPosition(10);
        this.moveOnTopButton.addKeyListener((KeyListener)new EnterDoClickListener(this.moveOnTopButton));
        this.moveOnTopButton.setAlignmentX(0.5f);
        this.moveOnTopButton.setMinimumSize(new Dimension(90, 25));
        this.moveOnTopButton.setPreferredSize(new Dimension(120, 25));
        this.moveOnTopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualPageListItem[] elements = VComposerMainGUI.this.inputPanel.getSelectedElements();
                if (elements != null && elements.length > 0) {
                    Vector<VisualPageListItem> newList = new Vector<VisualPageListItem>(elements.length);
                    for (VisualPageListItem currItem : elements) {
                        newList.add((VisualPageListItem)currItem.clone());
                    }
                    VComposerMainGUI.this.composerPanel.prependElements(newList);
                }
            }
        });
        this.moveToBottomButton.setMargin(new Insets(2, 2, 2, 2));
        this.moveToBottomButton.setIcon(new ImageIcon(this.getClass().getResource("/images/movebottom.png")));
        this.moveToBottomButton.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Move to bottom"));
        this.moveToBottomButton.addKeyListener((KeyListener)new EnterDoClickListener(this.moveOnTopButton));
        this.moveToBottomButton.setAlignmentX(0.5f);
        this.moveToBottomButton.setMinimumSize(new Dimension(90, 25));
        this.moveToBottomButton.setPreferredSize(new Dimension(120, 25));
        this.moveToBottomButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VisualPageListItem[] elements = VComposerMainGUI.this.inputPanel.getSelectedElements();
                if (elements != null && elements.length > 0) {
                    Vector<VisualPageListItem> newList = new Vector<VisualPageListItem>(elements.length);
                    for (VisualPageListItem currItem : elements) {
                        newList.add((VisualPageListItem)currItem.clone());
                    }
                    VComposerMainGUI.this.composerPanel.appendElements(newList);
                }
            }
        });
        buttonsPanel.add(this.moveOnTopButton);
        buttonsPanel.add(Box.createRigidArea(new Dimension(10, 5)));
        buttonsPanel.add(this.moveToBottomButton);
        this.composerPanel.addToTopPanel((Component)buttonsPanel);
        this.composerPanel.disableSetOutputPathMenuItem();
        JScrollPane composerScroll = new JScrollPane((Component)this.composerPanel, 20, 31);
        composerScroll.setPreferredSize(new Dimension(180, 180));
        this.higherSplitPanel = new JSplitPane(0, (Component)this.inputPanel, composerScroll);
        this.higherSplitPanel.setDividerSize(2);
        this.higherSplitPanel.setDividerLocation(0.5);
        this.higherSplitPanel.setResizeWeight(0.5);
        this.destinationPanelLayout = new SpringLayout();
        this.destinationPanel.setLayout(this.destinationPanelLayout);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file"));
        this.destinationPanel.setBorder(titledBorder);
        this.destinationPanel.setPreferredSize(new Dimension(200, 160));
        this.destinationPanel.add(this.destinationFileText);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        this.browseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.PDF_FILE, (int)0, (String)VComposerMainGUI.this.destinationFileText.getText());
                if (fileChooser.showOpenDialog(VComposerMainGUI.this.browseDestButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    VComposerMainGUI.this.destinationFileText.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseDestButton);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"To choose a file browse or enter the full path to the destination output file.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output files if they already exist.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want compressed output files.") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"PDF version 1.5 or above.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.lowerSplitPanel = new JSplitPane(0, this.higherSplitPanel, new JScrollPane(this.destinationPanel, 20, 31));
        this.lowerSplitPanel.setOneTouchExpandable(true);
        this.lowerSplitPanel.setResizeWeight(1.0);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridheight = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 10, 0);
        this.add(this.lowerSplitPanel, c);
        this.browseDestButton.addKeyListener((KeyListener)this.browsedEnterkeyListener);
        this.runButton.addKeyListener((KeyListener)this.runEnterkeyListener);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Execute pages reorder"));
        this.runButton.setSize(new Dimension(88, 25));
        c.fill = 0;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.add(this.runButton, c);
        this.setLayout();
    }

    private void setLayout() {
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationFileText, 20, "North", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("North", (Component)this.destinationFileText, 10, "North", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationFileText, -105, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.destinationFileText, 5, "West", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.destinationPanelLayout.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.browseDestButton, 0, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("East", (Component)this.browseDestButton, -10, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("North", (Component)this.browseDestButton, -25, "South", (Component)this.destinationFileText);
        this.destinationPanelLayout.putConstraint("West", (Component)this.browseDestButton, -98, "East", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.destinationPanelLayout.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.visualComposerFocusPolicy;
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                Element inputDocuments = ((Element)arg0).addElement("input-documents");
                PdfFile[] openFiles = this.inputPanel.getInputDocuments();
                if (openFiles != null && openFiles.length > 0) {
                    for (PdfFile openFile : openFiles) {
                        if (openFile == null || openFile.getInputFile() == null) continue;
                        Element fileSource = inputDocuments.addElement("source");
                        fileSource.addAttribute("value", openFile.getInputFile().getAbsolutePath());
                        if (!savePasswords) continue;
                        fileSource.addAttribute("password", openFile.getPassword() != null ? openFile.getPassword() : "");
                    }
                }
                Element outputDocument = ((Element)arg0).addElement("output-document");
                VisualPageListItem[] pages = ((VisualListModel)this.composerPanel.getThumbnailList().getModel()).getElements();
                if (pages != null && pages.length > 0) {
                    for (VisualPageListItem page : pages) {
                        Element outputFile = outputDocument.addElement("page");
                        outputFile.setText(Base64.encodeObject((Serializable)page));
                    }
                }
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationFileText.getText());
                Element fileOverwrite = ((Element)arg0).addElement("overwrite");
                fileOverwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException((Throwable)ex);
        }
    }

    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Visual document composer");
    }

    public String getVersion() {
        return PLUGIN_VERSION;
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node fileCompressed;
            Node fileOverwrite;
            Node fileDestination;
            List outputPages;
            List filesSource = arg0.selectNodes("input-documents/source");
            if (filesSource != null && filesSource.size() > 0) {
                for (Node fileNode : filesSource) {
                    Node fileSource = fileNode.selectSingleNode("@value");
                    if (fileSource == null || fileSource.getText().length() <= 0) continue;
                    Node filePwd = fileNode.selectSingleNode("@password");
                    String password = null;
                    if (filePwd != null && filePwd.getText().length() > 0) {
                        password = filePwd.getText();
                    }
                    this.inputPanel.addTab(new File(fileSource.getText()), password);
                }
            }
            if ((outputPages = arg0.selectNodes("output-document/page")) != null && outputPages.size() > 0) {
                for (Node pageNode : outputPages) {
                    Object pageObject;
                    String serializedPage = pageNode.getText();
                    if (serializedPage == null || serializedPage.length() <= 0 || (pageObject = Base64.decodeToObject((String)serializedPage)) == null) continue;
                    ((VisualListModel)this.composerPanel.getThumbnailList().getModel()).addElement((VisualPageListItem)pageObject);
                }
            }
            if ((fileDestination = arg0.selectSingleNode("destination/@value")) != null && fileDestination.getText().length() > 0) {
                this.destinationFileText.setText(fileDestination.getText());
            }
            if ((fileOverwrite = arg0.selectSingleNode("overwrite/@value")) != null) {
                this.overwriteCheckbox.setSelected(TRUE.equals(fileOverwrite.getText()));
            }
            if ((fileCompressed = arg0.selectSingleNode("compressed/@value")) != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Visual Composer section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    public void resetPanel() {
        this.inputPanel.removeAllTabs();
        this.composerPanel.resetPanel();
        this.destinationFileText.setText("");
        this.versionCombo.resetComponent();
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("defaultOutputPath".equals(evt.getPropertyName())) {
            this.destinationFileText.setText((String)evt.getNewValue() + File.separatorChar + DEFAULT_OUPUT_NAME);
        }
    }

    public JTextField getDestinationFileText() {
        return this.destinationFileText;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JVisualPdfPageSelectionPanel getComposerPanel() {
        return this.composerPanel;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public class VisualComposerPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            JButton zoomIn = VComposerMainGUI.this.inputPanel.getCurrentZoomInButton();
            JButton zoomOut = VComposerMainGUI.this.inputPanel.getCurrentZoomOutButton();
            if (aComponent.equals(VComposerMainGUI.this.inputPanel.getOpenButton())) {
                if (zoomIn != null) {
                    return zoomIn;
                }
                return VComposerMainGUI.this.moveOnTopButton;
            }
            if (zoomIn != null && aComponent.equals(zoomIn)) {
                return zoomOut;
            }
            if (zoomOut != null && aComponent.equals(zoomOut)) {
                return VComposerMainGUI.this.moveOnTopButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.moveOnTopButton)) {
                return VComposerMainGUI.this.moveToBottomButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.moveToBottomButton)) {
                if (VComposerMainGUI.this.composerPanel.getClearButton() != null) {
                    return VComposerMainGUI.this.composerPanel.getClearButton();
                }
                return VComposerMainGUI.this.composerPanel.getZoomInButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getClearButton())) {
                return VComposerMainGUI.this.composerPanel.getZoomInButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getZoomInButton())) {
                return VComposerMainGUI.this.composerPanel.getZoomOutButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getZoomOutButton())) {
                return VComposerMainGUI.this.composerPanel.getMoveUpButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getMoveUpButton())) {
                return VComposerMainGUI.this.composerPanel.getMoveDownButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getMoveDownButton())) {
                return VComposerMainGUI.this.composerPanel.getRemoveButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRemoveButton())) {
                if (VComposerMainGUI.this.composerPanel.getUndeleteButton() != null) {
                    return VComposerMainGUI.this.composerPanel.getUndeleteButton();
                }
                return VComposerMainGUI.this.composerPanel.getRotateButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getUndeleteButton())) {
                return VComposerMainGUI.this.composerPanel.getRotateButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRotateButton())) {
                return VComposerMainGUI.this.composerPanel.getRotateAntiButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRotateAntiButton())) {
                return VComposerMainGUI.this.composerPanel.getReverseButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getReverseButton())) {
                return VComposerMainGUI.this.destinationFileText;
            }
            if (aComponent.equals(VComposerMainGUI.this.destinationFileText)) {
                return VComposerMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.browseDestButton)) {
                return VComposerMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(VComposerMainGUI.this.overwriteCheckbox)) {
                return VComposerMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(VComposerMainGUI.this.outputCompressedCheck)) {
                return VComposerMainGUI.this.versionCombo;
            }
            if (aComponent.equals(VComposerMainGUI.this.versionCombo)) {
                return VComposerMainGUI.this.runButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.runButton)) {
                return VComposerMainGUI.this.inputPanel.getOpenButton();
            }
            return VComposerMainGUI.this.inputPanel.getOpenButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            JButton zoomIn = VComposerMainGUI.this.inputPanel.getCurrentZoomInButton();
            JButton zoomOut = VComposerMainGUI.this.inputPanel.getCurrentZoomOutButton();
            if (aComponent.equals(VComposerMainGUI.this.inputPanel.getOpenButton())) {
                return VComposerMainGUI.this.runButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getClearButton())) {
                return VComposerMainGUI.this.moveToBottomButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.moveToBottomButton)) {
                return VComposerMainGUI.this.moveOnTopButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.moveOnTopButton)) {
                if (zoomOut != null) {
                    return zoomOut;
                }
                return VComposerMainGUI.this.inputPanel.getOpenButton();
            }
            if (zoomOut != null && aComponent.equals(zoomOut)) {
                return zoomIn;
            }
            if (zoomIn != null && aComponent.equals(zoomIn)) {
                return VComposerMainGUI.this.inputPanel.getOpenButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getZoomInButton())) {
                if (VComposerMainGUI.this.composerPanel.getClearButton() != null) {
                    return VComposerMainGUI.this.composerPanel.getClearButton();
                }
                return VComposerMainGUI.this.moveToBottomButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getZoomOutButton())) {
                return VComposerMainGUI.this.composerPanel.getZoomInButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getMoveUpButton())) {
                return VComposerMainGUI.this.composerPanel.getZoomOutButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getMoveDownButton())) {
                return VComposerMainGUI.this.composerPanel.getMoveUpButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRemoveButton())) {
                return VComposerMainGUI.this.composerPanel.getMoveDownButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getUndeleteButton())) {
                return VComposerMainGUI.this.composerPanel.getRemoveButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRotateButton())) {
                if (VComposerMainGUI.this.composerPanel.getUndeleteButton() != null) {
                    return VComposerMainGUI.this.composerPanel.getUndeleteButton();
                }
                return VComposerMainGUI.this.composerPanel.getRemoveButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getRotateAntiButton())) {
                return VComposerMainGUI.this.composerPanel.getRotateButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.destinationFileText)) {
                return VComposerMainGUI.this.composerPanel.getReverseButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.composerPanel.getReverseButton())) {
                return VComposerMainGUI.this.composerPanel.getRotateAntiButton();
            }
            if (aComponent.equals(VComposerMainGUI.this.browseDestButton)) {
                return VComposerMainGUI.this.destinationFileText;
            }
            if (aComponent.equals(VComposerMainGUI.this.overwriteCheckbox)) {
                return VComposerMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(VComposerMainGUI.this.outputCompressedCheck)) {
                return VComposerMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(VComposerMainGUI.this.versionCombo)) {
                return VComposerMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(VComposerMainGUI.this.runButton)) {
                return VComposerMainGUI.this.versionCombo;
            }
            return VComposerMainGUI.this.inputPanel.getOpenButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return VComposerMainGUI.this.inputPanel.getOpenButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return VComposerMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return VComposerMainGUI.this.inputPanel.getOpenButton();
        }
    }
}

