/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.tools.logging.LogTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GlyphNameMap {
    private static final int ARRAY_MAPPING_SIZE = 256;
    public static final GlyphNameMap Standard = new GlyphNameMap();
    public static final String GLYPH_NOTDEF = ".notdef";
    private static Logger Log = LogTools.getLogger(GlyphNameMap.class);
    private static final String AdobeGlyphList = "AdobeGlyphList.txt";
    private static final String PREFIX_UNI = "uni";
    private Map glyphNameToUnicode = new HashMap();
    private Map unicodeToGlyphName = new HashMap();
    private String[] asciiToGlyphName = new String[256];

    protected GlyphNameMap() {
        int n = 0;
        while (n < this.asciiToGlyphName.length) {
            this.asciiToGlyphName[n] = GLYPH_NOTDEF;
            ++n;
        }
        this.load();
    }

    protected void addEntry(String string, int n) {
        this.glyphNameToUnicode.put(string, new Integer(n));
        this.unicodeToGlyphName.put(new Integer(n), string);
        if (n >= 0 && n < 256) {
            this.asciiToGlyphName[n] = string;
        }
    }

    public String getGlyphName(int n) {
        if (n >= 0 && n < 256) {
            return this.asciiToGlyphName[n];
        }
        String string = (String)this.unicodeToGlyphName.get(new Integer(n));
        if (string == null) {
            return GLYPH_NOTDEF;
        }
        return string;
    }

    protected Map getGlyphNameToUnicode() {
        return this.glyphNameToUnicode;
    }

    public int getUnicode(String string) {
        Integer n = (Integer)this.glyphNameToUnicode.get(string);
        if (n == null && string != null && string.startsWith(PREFIX_UNI)) {
            try {
                n = Integer.parseInt(string.substring(3), 16);
                this.addEntry(string, n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n == null) {
            return -1;
        }
        return n;
    }

    protected Map getUnicodeToGlyphName() {
        return this.unicodeToGlyphName;
    }

    protected void load() {
        InputStream inputStream = this.getClass().getResourceAsStream(AdobeGlyphList);
        try {
            this.load(inputStream);
        }
        catch (IOException iOException) {
            Log.log(Level.WARNING, "error loading Adobe glyph list");
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void load(InputStream var1_1) throws IOException {
        var2_2 = new StringBuilder();
        var3_3 = null;
        var4_4 = null;
        var5_5 = var1_1.read();
        while (var5_5 != -1) {
            block7: {
                if (var5_5 == 13 || var5_5 == 10 || var5_5 == 32) break block7;
                if (var5_5 != 35) ** GOTO lbl27
                var5_5 = var1_1.read();
                while (var5_5 != -1 && var5_5 != 10) {
                    var5_5 = var1_1.read();
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    if (var5_5 == 59) {
                        var3_3 = var2_2.toString();
                        var2_2.setLength(0);
                    } else {
                        if (var5_5 == 32 | var5_5 == 13 || var5_5 == 10) {
                            var4_4 = var2_2.toString();
                            var2_2.setLength(0);
                            while (var5_5 != -1 && var5_5 != 10) {
                                var5_5 = var1_1.read();
                            }
                            break;
                        }
                        var2_2.append((char)var5_5);
                    }
                    var5_5 = var1_1.read();
lbl27:
                    // 2 sources

                    ** while (var5_5 != -1)
                }
lbl28:
                // 2 sources

                this.addEntry(var3_3, Integer.parseInt(var4_4, 16));
            }
            var5_5 = var1_1.read();
        }
    }
}

