/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.SymbolEncoding;
import de.intarsys.pdf.font.AFMEncoding;
import de.intarsys.pdf.font.PACKAGE;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorAFM;
import de.intarsys.pdf.font.PDSingleByteFont;
import de.intarsys.tools.locator.ClassResourceLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class PDFontType1
extends PDSingleByteFont {
    public static final Map<String, String> FONT_ALIASES;
    public static final Map<String, String> FONT_ALIASES_DEPRECATED;
    public static String FONT_Courier;
    public static String FONT_Courier_Bold;
    public static String FONT_Courier_BoldOblique;
    public static String FONT_Courier_Oblique;
    public static String FONT_Helvetica;
    public static String FONT_Helvetica_Bold;
    public static String FONT_Helvetica_BoldOblique;
    public static String FONT_Helvetica_Oblique;
    public static String FONT_Symbol;
    public static String FONT_Times_Bold;
    public static String FONT_Times_BoldItalic;
    public static String FONT_Times_Italic;
    public static String FONT_Times_Roman;
    public static String FONT_ZapfDingbats;
    public static final String[] FONT_BUILTINS;
    public static final MetaClass META;
    private static Map<String, AFM> builtins;

    static {
        FONT_Courier = "Courier";
        FONT_Courier_Bold = "Courier-Bold";
        FONT_Courier_BoldOblique = "Courier-BoldOblique";
        FONT_Courier_Oblique = "Courier-Oblique";
        FONT_Helvetica = "Helvetica";
        FONT_Helvetica_Bold = "Helvetica-Bold";
        FONT_Helvetica_BoldOblique = "Helvetica-BoldOblique";
        FONT_Helvetica_Oblique = "Helvetica-Oblique";
        FONT_Symbol = "Symbol";
        FONT_Times_Bold = "Times-Bold";
        FONT_Times_BoldItalic = "Times-BoldItalic";
        FONT_Times_Italic = "Times-Italic";
        FONT_Times_Roman = "Times-Roman";
        FONT_ZapfDingbats = "ZapfDingbats";
        FONT_BUILTINS = new String[]{FONT_Courier, FONT_Courier_Bold, FONT_Courier_BoldOblique, FONT_Courier_Oblique, FONT_Helvetica, FONT_Helvetica_Bold, FONT_Helvetica_BoldOblique, FONT_Helvetica_Oblique, FONT_Symbol, FONT_Times_Bold, FONT_Times_BoldItalic, FONT_Times_Italic, FONT_Times_Roman, FONT_ZapfDingbats};
        META = new MetaClass(MetaClass.class.getDeclaringClass());
        builtins = new HashMap<String, AFM>();
        FONT_ALIASES = new HashMap<String, String>();
        FONT_ALIASES.put(FONT_Courier, FONT_Courier);
        FONT_ALIASES.put(FONT_Courier_Bold, FONT_Courier_Bold);
        FONT_ALIASES.put(FONT_Courier_Oblique, FONT_Courier_Oblique);
        FONT_ALIASES.put(FONT_Courier_BoldOblique, FONT_Courier_BoldOblique);
        FONT_ALIASES.put(FONT_Helvetica, FONT_Helvetica);
        FONT_ALIASES.put(FONT_Helvetica_Bold, FONT_Helvetica_Bold);
        FONT_ALIASES.put(FONT_Helvetica_Oblique, FONT_Helvetica_Oblique);
        FONT_ALIASES.put(FONT_Helvetica_BoldOblique, FONT_Helvetica_BoldOblique);
        FONT_ALIASES.put(FONT_Times_Roman, FONT_Times_Roman);
        FONT_ALIASES.put(FONT_Times_Bold, FONT_Times_Bold);
        FONT_ALIASES.put(FONT_Times_Italic, FONT_Times_Italic);
        FONT_ALIASES.put(FONT_Times_BoldItalic, FONT_Times_BoldItalic);
        FONT_ALIASES.put(FONT_ZapfDingbats, FONT_ZapfDingbats);
        FONT_ALIASES.put(FONT_Symbol, FONT_Symbol);
        FONT_ALIASES.put("Cour", FONT_Courier);
        FONT_ALIASES.put("CoBo", FONT_Courier_Bold);
        FONT_ALIASES.put("CoOb", FONT_Courier_Oblique);
        FONT_ALIASES.put("CoBO", FONT_Courier_BoldOblique);
        FONT_ALIASES.put("Helv", FONT_Helvetica);
        FONT_ALIASES.put("HeBo", FONT_Helvetica_Bold);
        FONT_ALIASES.put("HeOb", FONT_Helvetica_Oblique);
        FONT_ALIASES.put("HeBO", FONT_Helvetica_BoldOblique);
        FONT_ALIASES.put("TiRo", FONT_Times_Roman);
        FONT_ALIASES.put("TiBo", FONT_Times_Bold);
        FONT_ALIASES.put("TiIt", FONT_Times_Italic);
        FONT_ALIASES.put("TiBI", FONT_Times_BoldItalic);
        FONT_ALIASES.put("ZaDb", FONT_ZapfDingbats);
        FONT_ALIASES.put("Symb", FONT_Symbol);
        FONT_ALIASES.put("CourierNew", FONT_Courier);
        FONT_ALIASES.put("CourierNew,Bold", FONT_Courier_Bold);
        FONT_ALIASES.put("CourierNew,Italic", FONT_Courier_Oblique);
        FONT_ALIASES.put("CourierNew,BoldItalic", FONT_Courier_BoldOblique);
        FONT_ALIASES.put("Arial", FONT_Helvetica);
        FONT_ALIASES.put("Arial,Bold", FONT_Helvetica_Bold);
        FONT_ALIASES.put("Arial,Italic", FONT_Helvetica_Oblique);
        FONT_ALIASES.put("Arial,BoldItalic", FONT_Helvetica_BoldOblique);
        FONT_ALIASES.put("TimesNewRoman", FONT_Times_Roman);
        FONT_ALIASES.put("TimesNewRoman,Bold", FONT_Times_Bold);
        FONT_ALIASES.put("TimesNewRoman,Italic", FONT_Times_Italic);
        FONT_ALIASES.put("TimesNewRoman,BoldItalic", FONT_Times_BoldItalic);
        FONT_ALIASES_DEPRECATED = new HashMap<String, String>();
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS", FONT_Times_Roman);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPSMT", FONT_Times_Roman);
        FONT_ALIASES_DEPRECATED.put("TimesNewRoman-Bold", FONT_Times_Bold);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-Bold", FONT_Times_Bold);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-BoldMT", FONT_Times_Bold);
        FONT_ALIASES_DEPRECATED.put("TimesNewRoman-Italic", FONT_Times_Italic);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-Italic", FONT_Times_Italic);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-ItalicMT", FONT_Times_Italic);
        FONT_ALIASES_DEPRECATED.put("TimesNewRoman-BoldItalic", FONT_Times_BoldItalic);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-BoldItalic", FONT_Times_BoldItalic);
        FONT_ALIASES_DEPRECATED.put("TimesNewRomanPS-BoldItalicMT", FONT_Times_BoldItalic);
        FONT_ALIASES_DEPRECATED.put("CourierNewPSMT", FONT_Courier);
        FONT_ALIASES_DEPRECATED.put("Courier,BoldItalic", FONT_Courier_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("CourierNew-BoldItalic", FONT_Courier_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("CourierNewPS-BoldItalicMT", FONT_Courier_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("Courier,Bold", FONT_Courier_Bold);
        FONT_ALIASES_DEPRECATED.put("CourierNew-Bold", FONT_Courier_Bold);
        FONT_ALIASES_DEPRECATED.put("CourierNewPS-BoldMT", FONT_Courier_Bold);
        FONT_ALIASES_DEPRECATED.put("Courier,Italic", FONT_Courier_Oblique);
        FONT_ALIASES_DEPRECATED.put("CourierNew-Italic", FONT_Courier_Oblique);
        FONT_ALIASES_DEPRECATED.put("CourierNewPS-ItalicMT", FONT_Courier_Oblique);
        FONT_ALIASES_DEPRECATED.put("Helvetica,Bold", FONT_Helvetica_Bold);
        FONT_ALIASES_DEPRECATED.put("Helvetica-Italic", FONT_Helvetica_Oblique);
        FONT_ALIASES_DEPRECATED.put("Helvetica,Italic", FONT_Helvetica_Oblique);
        FONT_ALIASES_DEPRECATED.put("Helvetica-BoldItalic", FONT_Helvetica_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("Helvetica,BoldItalic", FONT_Helvetica_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("ArialMT", FONT_Helvetica);
        FONT_ALIASES_DEPRECATED.put("Arial-Bold", FONT_Helvetica_Bold);
        FONT_ALIASES_DEPRECATED.put("Arial-BoldMT", FONT_Helvetica_Bold);
        FONT_ALIASES_DEPRECATED.put("Arial-Italic", FONT_Helvetica_Oblique);
        FONT_ALIASES_DEPRECATED.put("Arial-ItalicMT", FONT_Helvetica_Oblique);
        FONT_ALIASES_DEPRECATED.put("Arial-BoldItalic", FONT_Helvetica_BoldOblique);
        FONT_ALIASES_DEPRECATED.put("Arial-BoldItalicMT", FONT_Helvetica_BoldOblique);
    }

    public static PDFontType1 createNew(String string) {
        PDFontType1 pDFontType1 = (PDFontType1)META.createNew();
        String string2 = FONT_ALIASES.get(string);
        if (string2 == null && (string2 = FONT_ALIASES_DEPRECATED.get(string)) == null) {
            string2 = string;
        }
        pDFontType1.setBaseFont(string2);
        return pDFontType1;
    }

    public static boolean isBuiltin(String string) {
        return string != null && string.equals(FONT_ALIASES.get(string));
    }

    public static boolean isBuiltinAlias(String string) {
        return FONT_ALIASES.get(string) != null;
    }

    public static boolean isBuiltinDeprecated(String string) {
        return FONT_ALIASES_DEPRECATED.get(string) != null;
    }

    public static synchronized AFM lookupBuiltinAFM(String string) {
        String string2 = FONT_ALIASES.get(string);
        if (string2 == null && (string2 = FONT_ALIASES_DEPRECATED.get(string)) == null) {
            return null;
        }
        AFM aFM = builtins.get(string2);
        if (aFM == null) {
            ClassResourceLocator classResourceLocator = new ClassResourceLocator(PDFontType1.class, String.valueOf(string2) + ".afm");
            try {
                aFM = AFM.createFromLocator((ILocator)classResourceLocator);
                builtins.put(string2, aFM);
            }
            catch (IOException iOException) {
                PACKAGE.Log.log(Level.WARNING, "builtin font metrics '" + string2 + "' load error", iOException);
            }
        }
        return aFM;
    }

    protected PDFontType1(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type1;
    }

    @Override
    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return new PDFontDescriptorAFM(PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue()));
    }

    @Override
    protected int[] createBuiltInWidths(int[] nArray) {
        AFM aFM = PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue());
        if (aFM == null) {
            return nArray;
        }
        if (this.getEncoding().isFontSpecificEncoding()) {
            int n = 0;
            while (n < 256) {
                AFMChar aFMChar = aFM.getCharByCode(n);
                if (aFMChar != null) {
                    nArray[n] = aFMChar.getWidth();
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < 256) {
                String string = this.getEncoding().getGlyphName(n);
                AFMChar aFMChar = aFM.getCharByName(string);
                if (aFMChar != null) {
                    nArray[n] = aFMChar.getWidth();
                }
                ++n;
            }
        }
        return nArray;
    }

    @Override
    protected Encoding createDefaultEncoding() {
        if (this.getFontDescriptor() != null && this.getFontDescriptor().isSymbolic()) {
            return SymbolEncoding.UNIQUE;
        }
        AFM aFM = PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue());
        if (aFM == null) {
            return super.createDefaultEncoding();
        }
        return new AFMEncoding(aFM);
    }

    @Override
    protected int createFirstChar() {
        Encoding encoding = this.getEncoding();
        int n = 0;
        while (n <= 255) {
            if (encoding.getDecoded(n) != -1) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    @Override
    protected int createLastChar() {
        Encoding encoding = this.getEncoding();
        int n = 255;
        while (n >= 0) {
            if (encoding.getDecoded(n) != -1) {
                return n;
            }
            --n;
        }
        return 0;
    }

    @Override
    public String getFontNameNormalized() {
        String string = super.getFontNameNormalized();
        String string2 = FONT_ALIASES.get(string);
        if (string2 != null) {
            return string2;
        }
        string2 = FONT_ALIASES_DEPRECATED.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    @Override
    public String getFontType() {
        return "Type1";
    }

    @Override
    public boolean isStandardFont() {
        if (this.cosGetField(DK_FontDescriptor).isNull()) {
            return true;
        }
        return Arrays.asList(FONT_BUILTINS).contains(this.cosGetField(DK_BaseFont));
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDFontType1(cOSObject);
        }
    }
}

