/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrue;
import de.intarsys.pdf.pd.AcroFormSigFlags;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import java.util.List;

public class PDAcroForm
extends PDAcroFormNode {
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName DK_NeedAppearances = COSName.constant("NeedAppearances");
    public static final COSName DK_SigFlags = COSName.constant("SigFlags");
    public static final COSName DK_CO = COSName.constant("CO");
    public static final COSName DK_XFA = COSName.constant("XFA");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private AcroFormSigFlags sigFlags;
    private List cachedFields;
    private boolean fieldsChecked = false;

    protected PDAcroForm(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    public void addField(PDAcroFormField pDAcroFormField) {
        this.checkFields();
        this.cosAddField(pDAcroFormField.cosGetDict());
        pDAcroFormField.setParent(null);
        if (pDAcroFormField.isTypeSig()) {
            this.getSigFlags().setSignatureExists(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFields() {
        PDAcroForm pDAcroForm = this;
        synchronized (pDAcroForm) {
            if (this.fieldsChecked) {
                return;
            }
            this.fieldsChecked = true;
            COSArray cOSArray = this.cosGetField(DK_Fields).asArray();
            if (cOSArray != null && cOSArray.size() == 0) {
                COSArray cOSArray2 = this.reconstruct(this.getDoc());
                this.cosGetDict().basicPutSilent(DK_Fields, cOSArray2);
            }
        }
    }

    private void cosAddField(COSDictionary cOSDictionary) {
        COSArray cOSArray = this.cosGetField(DK_Fields).asArray();
        if (cOSArray == null) {
            cOSArray = COSArray.create();
            cOSArray.beIndirect();
            this.cosSetField(DK_Fields, cOSArray);
        }
        cOSArray.add(cOSDictionary);
    }

    public COSObject cosGetXfa() {
        return this.cosGetField(DK_XFA);
    }

    protected void cosSetSigFlags(int n) {
        if (n != 0) {
            this.cosSetField(DK_SigFlags, COSInteger.create(n));
        } else {
            this.cosRemoveField(DK_SigFlags);
        }
    }

    @Override
    public PDAcroForm getAcroForm() {
        return this;
    }

    public List getCalculationOrder() {
        return this.getPDObjects(DK_CO, PDAcroFormField.META, false);
    }

    public PDResources getDefaultResources() {
        return (PDResources)PDResources.META.createFromCos(this.cosGetField(DK_DR));
    }

    public List getFields() {
        this.checkFields();
        if (this.cachedFields == null) {
            this.cachedFields = this.getPDObjects(DK_Fields, PDAcroFormField.META, true);
        }
        return this.cachedFields;
    }

    @Override
    public List getGenericChildren() {
        return this.getFields();
    }

    public boolean getNeedAppearances() {
        return this.getFieldBoolean(DK_NeedAppearances, false);
    }

    public AcroFormSigFlags getSigFlags() {
        if (this.sigFlags == null) {
            this.sigFlags = new AcroFormSigFlags(this);
        }
        return this.sigFlags;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        COSArray cOSArray = this.cosGetField(DK_Fields).asArray();
        if (cOSArray != null) {
            cOSArray.removeObjectListener(this);
        }
        this.cachedFields = null;
    }

    public boolean isSignatureExists() {
        for (PDAcroFormField pDAcroFormField : this.collectLeafFields()) {
            if (!pDAcroFormField.isTypeSig()) continue;
            return true;
        }
        return false;
    }

    public boolean isSigned() {
        for (PDAcroFormField pDAcroFormField : this.collectLeafFields()) {
            if (!pDAcroFormField.isTypeSig() || !((PDAFSignatureField)pDAcroFormField).isSigned()) continue;
            return true;
        }
        return false;
    }

    protected COSArray reconstruct(PDDocument pDDocument) {
        COSArray cOSArray = COSArray.create();
        if (pDDocument == null) {
            return cOSArray;
        }
        PDPageTree pDPageTree = pDDocument.getPageTree();
        if (pDPageTree == null) {
            return cOSArray;
        }
        boolean bl = false;
        PDPage pDPage = pDPageTree.getFirstPage();
        while (pDPage != null) {
            List<PDAnnotation> list = pDPage.getAnnotations();
            if (list != null) {
                for (PDAnnotation pDAnnotation : list) {
                    if (!pDAnnotation.isWidgetAnnotation()) continue;
                    COSDictionary cOSDictionary = pDAnnotation.cosGetDict();
                    cOSArray.basicAddSilent(cOSDictionary);
                    cOSDictionary.basicRemoveSilent(PDAcroFormField.DK_Parent);
                    bl |= cOSDictionary.get(PDAcroFormField.DK_FT).equals(PDAcroFormField.CN_FT_Sig);
                }
            }
            pDPage = pDPage.getNextPage();
        }
        if (bl) {
            int n = this.getFieldInt(DK_SigFlags, 0);
            this.cosGetDict().basicPutSilent(DK_SigFlags, COSInteger.create(n |= AcroFormSigFlags.Bit_AppendOnly | AcroFormSigFlags.Bit_SignatureExists));
        }
        return cOSArray;
    }

    @Override
    public boolean removeField(PDAcroFormField pDAcroFormField) {
        this.getFields().remove(pDAcroFormField);
        COSArray cOSArray = this.cosGetField(DK_Fields).asArray();
        if (cOSArray == null) {
            return false;
        }
        boolean bl = cOSArray.remove(pDAcroFormField.cosGetDict());
        this.getSigFlags().setSignatureExists(this.isSignatureExists());
        return bl;
    }

    protected void setCalculationOrder(List list) {
        this.setPDObjects(DK_CO, list);
    }

    public void setDefaultResources(PDResources pDResources) {
        this.setFieldObject(DK_DR, pDResources);
    }

    @Override
    public void setGenericParent(PDObject pDObject) {
        throw new IllegalStateException("AcroForm may not have a parent");
    }

    public void setNeedAppearances(boolean bl) {
        if (bl) {
            this.cosSetField(DK_NeedAppearances, COSTrue.create());
        } else {
            this.cosRemoveField(DK_NeedAppearances);
        }
    }

    @Override
    public String toString() {
        return "AcroForm " + super.toString();
    }

    public static class MetaClass
    extends PDAcroFormNode.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDAcroForm(cOSObject);
        }

        @Override
        protected MetaClass doDetermineClass(COSObject cOSObject) {
            if (!(cOSObject instanceof COSDictionary)) {
                return null;
            }
            return this;
        }
    }
}

