/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Function;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import de.intarsys.nativec.api.CLong;
import de.intarsys.nativec.api.CWideString;
import de.intarsys.nativec.api.INativeFunction;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.JnaNativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

public class JnaNativeFunction
implements INativeFunction {
    private Function function;

    public JnaNativeFunction(Function function) {
        this.function = function;
    }

    protected Function getFunction() {
        return this.function;
    }

    @Override
    public <T> T invoke(Class<T> clazz, Object ... objectArray) {
        Object object;
        JnaNativeHandle jnaNativeHandle;
        Object object2;
        int n = 0;
        while (n < objectArray.length) {
            object2 = objectArray[n];
            if (object2 instanceof INativeObject) {
                jnaNativeHandle = (JnaNativeHandle)((INativeObject)object2).getNativeHandle();
                objectArray[n] = jnaNativeHandle == null ? null : jnaNativeHandle.getPointer();
            } else if (object2 instanceof INativeHandle) {
                jnaNativeHandle = (JnaNativeHandle)object2;
                objectArray[n] = jnaNativeHandle.getPointer();
            } else if (object2 instanceof CWideString) {
                objectArray[n] = new WString(((CWideString)object2).getString());
            } else if (object2 instanceof CLong) {
                objectArray[n] = new NativeLong(((CLong)object2).longValue());
            }
            ++n;
        }
        if (CWideString.class.isAssignableFrom(clazz)) {
            object2 = (WString)this.function.invoke(WString.class, objectArray);
            object = new CWideString(object2.toString());
        } else if (CLong.class.isAssignableFrom(clazz)) {
            object2 = (NativeLong)this.function.invoke(NativeLong.class, objectArray);
            object = new CLong(object2.longValue());
        } else if (NativeObject.class.isAssignableFrom(clazz)) {
            object2 = (Pointer)this.function.invoke(Pointer.class, objectArray);
            if (object2 == null) {
                object = null;
            } else {
                jnaNativeHandle = new JnaNativeHandle((Pointer)object2);
                INativeType iNativeType = NativeType.lookup(clazz);
                if (iNativeType == null) {
                    throw new IllegalArgumentException("no type for '" + clazz + "'");
                }
                object = iNativeType.createNative(jnaNativeHandle);
            }
        } else {
            object = INativeHandle.class.isAssignableFrom(clazz) ? ((object2 = (Pointer)this.function.invoke(Pointer.class, objectArray)) == null ? null : new JnaNativeHandle((Pointer)object2)) : this.function.invoke(clazz, objectArray);
        }
        return (T)object;
    }
}

