/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeIntType;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeType;

public class NativeInt
extends NativeNumber {
    public static final NativeIntType META = new NativeIntType();

    static {
        NativeType.register(NativeInt.class, META);
    }

    public static NativeInt createFromAddress(long l) {
        return (NativeInt)META.createNative(NativeTools.toHandle(l));
    }

    public NativeInt() {
        this.allocate();
    }

    protected NativeInt(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    public NativeInt(long l) {
        this.allocate();
        this.setValue(l);
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return new Integer(this.intValue());
    }

    @Override
    public int intValue() {
        return this.handle.getInt(0);
    }

    @Override
    public long longValue() {
        return this.intValue();
    }

    public void setValue(int n) {
        this.handle.setInt(0, n);
    }

    @Override
    public void setValue(Object object) {
        this.setValue(((Number)object).intValue());
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.intValue());
    }
}

