/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.NativeGenericStruct;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeStructType;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.StructMember;

public abstract class NativeStruct
extends NativeObject {
    public static final NativeStructType META = new NativeStructType();
    protected INativeObject[] values;

    static {
        NativeType.register(NativeGenericStruct.class, META);
    }

    public NativeStruct() {
    }

    public NativeStruct(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    @Override
    public int getByteCount() {
        return this.getNativeType().getByteCount();
    }

    public INativeObject getNativeObject(String string) {
        return this.getStructType().getNativeObject(this, string);
    }

    protected StructMember getStructField(String string) {
        return this.getStructType().getField(string);
    }

    public NativeStructType getStructType() {
        return (NativeStructType)this.getNativeType();
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("getValue not implemented for NativeStruct");
    }

    @Override
    public void setValue(Object object) {
        throw new UnsupportedOperationException("getValue not implemented for NativeStruct");
    }

    @Override
    public String toNestedString() {
        return "Struct " + this.getClass().getName();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\n");
        for (StructMember structMember : this.getStructType().getFields()) {
            stringBuilder.append(structMember.getName());
            stringBuilder.append("=");
            try {
                stringBuilder.append(this.getNativeObject(structMember.getName()).toString());
            }
            catch (RuntimeException runtimeException) {
                stringBuilder.append("**error**");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

