/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business;

import java.io.File;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.thumbnails.ThumbnailCreatorsRegisty;
import org.pdfsam.guiclient.business.thumbnails.creators.ThumbnailsCreator;
import org.pdfsam.guiclient.commons.frames.JPagePreviewFrame;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class PagePreviewOpener {
    private static final Logger log = Logger.getLogger(PagePreviewOpener.class.getPackage().getName());
    private static PagePreviewOpener instance = null;
    private JPagePreviewFrame frame = null;
    private Thread imageOpener = null;

    private PagePreviewOpener() {
        this.init();
    }

    private void init() {
        this.frame = new JPagePreviewFrame();
        this.frame.setTitle(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Image viewer"));
    }

    public static synchronized PagePreviewOpener getInstance() {
        if (instance == null) {
            instance = new PagePreviewOpener();
        }
        return instance;
    }

    public synchronized void openPreview(File inputFile, String password, int page) {
        this.execute(new ImageOpener(inputFile, page, password));
    }

    public synchronized void openPreview(String inputFilePath, String password, int page) {
        this.execute(new ImageOpener(inputFilePath, page, password));
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone PagePreviewOpener object.");
    }

    private void execute(Runnable r) {
        if (this.imageOpener != null && this.imageOpener.isAlive()) {
            this.imageOpener.interrupt();
        }
        this.imageOpener = new Thread(r);
        this.imageOpener.start();
    }

    private ThumbnailsCreator getCreator() {
        return ThumbnailCreatorsRegisty.getCreator(Configuration.getInstance().getThumbnailsCreatorIdentifier());
    }

    private class ImageOpener
    implements Runnable {
        private File inputFile;
        private String password;
        private int page;

        public ImageOpener(File inputFile, int page, String password) {
            this.inputFile = inputFile;
            this.page = page;
            this.password = password;
        }

        public ImageOpener(String inputFilePath, int page, String password) {
            this.inputFile = new File(inputFilePath);
            this.page = page;
            this.password = password;
        }

        @Override
        public void run() {
            try {
                ThumbnailsCreator creator = PagePreviewOpener.this.getCreator();
                if (creator != null) {
                    PagePreviewOpener.this.frame.setPagePreview(creator.getPageImage(this.inputFile, this.password, this.page), this.inputFile.getAbsolutePath());
                    PagePreviewOpener.this.frame.setVisible(true);
                } else {
                    log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to initialize the thumbnails creation library."));
                }
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to open image preview"), e);
            }
        }
    }
}

