/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.business;

import java.awt.Color;
import java.util.Hashtable;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class TextPaneAppender
extends AppenderSkeleton {
    private static JTextPane logTextArea = null;
    private static StyledDocument styledDocument = null;
    private static Hashtable<Level, SimpleAttributeSet> attributes = null;

    public TextPaneAppender() {
        TextPaneAppender.getTextPaneInstance();
    }

    public static synchronized JTextPane getTextPaneInstance() {
        if (logTextArea == null) {
            logTextArea = new JTextPane();
            logTextArea.setEditable(false);
            logTextArea.setDragEnabled(true);
            DefaultCaret caret = (DefaultCaret)logTextArea.getCaret();
            caret.setUpdatePolicy(2);
            styledDocument = logTextArea.getStyledDocument();
            TextPaneAppender.createTextAttributes();
        }
        return logTextArea;
    }

    private static void createTextAttributes() {
        attributes = new Hashtable();
        attributes.put(Level.ERROR, new SimpleAttributeSet());
        attributes.put(Level.FATAL, new SimpleAttributeSet());
        attributes.put(Level.WARN, new SimpleAttributeSet());
        StyleConstants.setForeground(attributes.get(Level.ERROR), Color.red);
        StyleConstants.setForeground(attributes.get(Level.FATAL), Color.red);
        StyleConstants.setForeground(attributes.get(Level.WARN), Color.blue);
    }

    @Override
    protected void append(LoggingEvent arg0) {
        if (this.layout != null) {
            String logText = this.layout.format(arg0);
            StringBuilder trace = new StringBuilder("");
            try {
                if (arg0.getThrowableInformation() != null) {
                    String[] throwableStrings = arg0.getThrowableInformation().getThrowableStrRep();
                    for (int i = 0; i < throwableStrings.length; ++i) {
                        trace.append(throwableStrings[i]).append("\n");
                    }
                }
                if (attributes.get(arg0.getLevel()) != null) {
                    styledDocument.insertString(styledDocument.getLength(), logText + trace.toString(), attributes.get(arg0.getLevel()));
                } else {
                    styledDocument.insertString(styledDocument.getLength(), logText, null);
                }
            }
            catch (BadLocationException e) {
                logTextArea.setText(logTextArea.getText() + this.layout.format(arg0));
            }
        }
    }

    @Override
    public void close() {
        logTextArea = null;
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }
}

