/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.configuration;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.ConsoleServicesFacade;
import org.pdfsam.guiclient.business.TextPaneAppender;
import org.pdfsam.guiclient.configuration.services.ConfigurationService;
import org.pdfsam.guiclient.configuration.services.ConfigurationServiceLocator;
import org.pdfsam.guiclient.utils.ThemeUtility;
import org.pdfsam.i18n.GettextResource;

public class Configuration {
    private static final Logger log = Logger.getLogger(Configuration.class.getPackage().getName());
    public static final int DEFAULT_POOL_SIZE = 3;
    private static Configuration configObject;
    private ConfigurationService configurationService;
    private int screenResolution = 0;

    private Configuration() {
        this.initialize();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone configuration object.");
    }

    public static synchronized Configuration getInstance() {
        if (configObject == null) {
            configObject = new Configuration();
        }
        return configObject;
    }

    private void initialize() {
        try {
            this.configurationService = ConfigurationServiceLocator.LOCATOR.getConfigurationService();
            this.initializeLookAndFeel();
            this.initializeLoggingLevel();
            this.screenResolution = Toolkit.getDefaultToolkit().getScreenResolution();
        }
        catch (Exception e) {
            log.fatal("Error loading configuration.", e);
        }
    }

    private void initializeLookAndFeel() throws Exception {
        if (ThemeUtility.isPlastic(this.configurationService.getLookAndFeel())) {
            ThemeUtility.setTheme(this.configurationService.getTheme());
        }
        UIManager.setLookAndFeel(ThemeUtility.getLAF(this.configurationService.getLookAndFeel()));
    }

    private void initializeLoggingLevel() {
        int logLevel = this.configurationService.getLoggingLevel();
        try {
            TextPaneAppender appender = (TextPaneAppender)Logger.getLogger("org.pdfsam").getAppender("JLogPanel");
            Level loggingLevel = Level.toLevel(logLevel, Level.DEBUG);
            log.info(GettextResource.gettext((ResourceBundle)this.getI18nResourceBundle(), (String)"Logging level set to ") + loggingLevel);
            appender.setThreshold(loggingLevel);
        }
        catch (Exception e) {
            log.warn(GettextResource.gettext((ResourceBundle)this.getI18nResourceBundle(), (String)"Unable to set logging level."), e);
        }
    }

    public ResourceBundle getI18nResourceBundle() {
        return this.configurationService.getI18nResourceBundle();
    }

    public String getDefaultEnvironment() {
        return this.configurationService.getDefaultEnvironment();
    }

    public void setDefaultEnvironment(String environmentPath) {
        this.configurationService.setDefaultEnvironment(environmentPath);
    }

    public ConsoleServicesFacade getConsoleServicesFacade() {
        return this.configurationService.getConsoleServicesFacade();
    }

    public int getLoggingLevel() {
        return this.configurationService.getLoggingLevel();
    }

    public boolean isCheckForUpdates() {
        return this.configurationService.isCheckForUpdates();
    }

    public void setCheckForUpdates(boolean checkForUpdateds) {
        this.configurationService.setCheckForUpdates(checkForUpdateds);
    }

    public String getDefaultWorkingDirectory() {
        return this.configurationService.getDefaultWorkingDirectory();
    }

    public void setDefaultWorkingDirectory(String defaultDirectory) {
        this.configurationService.setDefaultWorkingDirectory(defaultDirectory);
    }

    public boolean isPlaySounds() {
        return this.configurationService.isPlaySounds();
    }

    public void setPlaySounds(boolean playSounds) {
        this.configurationService.setPlaySounds(playSounds);
    }

    public int getScreenResolution() {
        return this.screenResolution;
    }

    public int getThumbCreatorPoolSize() {
        return this.configurationService.getThumbCreatorPoolSize();
    }

    public String getThumbnailsCreatorIdentifier() {
        return this.configurationService.getThumbnailsCreatorIdentifier();
    }

    public void setThumbnailsCreatorIdentifier(String thumbnailsCreatorIdentifier) {
        this.configurationService.setThumbnailsCreatorIdentifier(thumbnailsCreatorIdentifier);
    }

    public String getSelectedLanguage() {
        return this.configurationService.getLanguage();
    }

    public void setSelectedLanguage(String language) {
        this.configurationService.setLanguage(language);
    }

    public String getConfigurationInformations() {
        return this.configurationService.getConfigurationInformations();
    }

    public String getPluginAbsolutePath() {
        return this.configurationService.getPluginAbsolutePath();
    }

    public int getLookAndFeel() {
        return this.configurationService.getLookAndFeel();
    }

    public void setLookAndFeel(int lookAndFeel) {
        this.configurationService.setLookAndFeel(lookAndFeel);
    }

    public int getTheme() {
        return this.configurationService.getTheme();
    }

    public void setTheme(int theme) {
        this.configurationService.setTheme(theme);
    }

    public void setLoggingLevel(int level) {
        this.configurationService.setLoggingLevel(level);
    }

    public boolean isAskOverwriteConfirmation() {
        return this.configurationService.isAskOverwriteConfirmation();
    }

    public void setAskOverwriteConfirmation(boolean askOverwriteConfirmation) {
        this.configurationService.setAskOverwriteConfirmation(askOverwriteConfirmation);
    }

    public boolean isHighQualityThumbnails() {
        return this.configurationService.isHighQualityThumbnils();
    }

    public int getThumbnailSize() {
        return this.configurationService.getThumbnailSize();
    }

    public void save() throws IOException {
        this.configurationService.save();
    }
}

