/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PageRotation;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class RotateParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = 1489004151951843863L;
    public static final String F_ARG = "f";
    public static final String P_ARG = "p";
    public static final String O_ARG = "o";
    public static final String R_ARG = "r";
    private File outputFile;
    private PdfFile[] inputFileList;
    private String outputFilesPrefix = "";
    private PageRotation rotation = null;

    public RotateParsedCommand() {
    }

    public RotateParsedCommand(PdfFile[] inputFileList, File outputFile, String outputFilesPrefix, PageRotation rotation) {
        this.inputFileList = inputFileList;
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.rotation = rotation;
    }

    public RotateParsedCommand(PdfFile[] inputFileList, File outputFile, String outputFilesPrefix, PageRotation rotation, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.inputFileList = inputFileList;
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.rotation = rotation;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public PdfFile[] getInputFileList() {
        return this.inputFileList;
    }

    public void setInputFileList(PdfFile[] inputFileList) {
        this.inputFileList = inputFileList;
    }

    public String getOutputFilesPrefix() {
        return this.outputFilesPrefix;
    }

    public void setOutputFilesPrefix(String outputFilesPrefix) {
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public String getCommand() {
        return "rotate";
    }

    public PageRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(PageRotation rotation) {
        this.rotation = rotation;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        if (this.inputFileList != null) {
            for (int i = 0; i < this.inputFileList.length; ++i) {
                retVal.append(this.inputFileList[i] == null ? "" : "[inputFileList[" + i + "]=" + this.inputFileList[i].getFile().getAbsolutePath() + "]");
            }
        }
        retVal.append("[outputFilesPrefix=" + this.outputFilesPrefix + "]");
        retVal.append("[rotation=" + this.rotation + "]");
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

