/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jcmdline.FileParam;
import jcmdline.IntParam;
import jcmdline.LongParam;
import jcmdline.Parameter;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import org.pdfsam.console.business.parser.handlers.interfaces.AbstractCmdHandler;

public class SplitCmdHandler
extends AbstractCmdHandler {
    private static final String COMMAND_DESCRIPTION = "Split a pdf document.";
    private final List splitOptions = new ArrayList<Parameter>(Arrays.asList(new FileParam("o", "output directory", 65526, false, false), new PdfFileParam("f", "input pdf file to split", 65519, false, false), new StringParam("p", "prefix for the output files name", true), new StringParam("s", "split type {[BURST], [ODD], [EVEN], [SPLIT], [NSPLIT], [SIZE], [BLEVEL]}", new String[]{"BURST", "ODD", "EVEN", "SPLIT", "NSPLIT", "SIZE", "BLEVEL"}, false), new StringParam("n", "page number to split at if -s is SPLIT or NSPLIT", true), new LongParam("b", "size in bytes to split at if -s is SIZE", true), new IntParam("bl", "bookmarks depth to split if -s is BLEVEL", true), new StringParam("b_regexp", "regexp to match the bookmark name during the a split by bookmark level.", true)));
    private final List splitArguments = new ArrayList<Parameter>(Arrays.asList(new StringParam("command", "command to execute {[split]}", new String[]{"split"}, false)));
    private static final String SPLIT_HELP_TEXT = "Split pdf file. \nYou must specify '-f /home/user/infile.pdf' option to set the input file you want to split (use filename:password if the file is password protected).\nYou must specify '-o /home/user' to set the output directory.\nYou must specify '-s split_type' to set the split type. Possible values: {[BURST], [ODD], [EVEN], [SPLIT], [NSPLIT], [BLEVEL]}\n'-p prefix_' to specify a prefix for output names of files. If it contains \"[CURRENTPAGE]\" or \"[TIMESTAMP]\" it performs variable substitution. (Ex. [BASENAME]_prefix_[CURRENTPAGE] generates FileName_prefix_005.pdf)\nAvailable prefix variables: [CURRENTPAGE], [TIMESTAMP], [BASENAME].\n'-n number' to specify a page number to split at if -s is SPLIT or NSPLIT.\n'-b number' to specify a number of bytes to split at if -s is SIZE.\n'-bl number' to specify the bookmarks depth to split at if -s is BLEVEL.\n'-b_regexp regexp' to specify a regexp that will match the bookmarks name during a split by bookmark level. The split will be performed only for those bookmarks matching the regexp.";
    public static final String SPLIT_EXAMPLES = "Example: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -s BURST -p splitted_ split\nExample: java -jar pdfsam-console-2.4.3e.jar -f /tmp/1.pdf -o /tmp -s NSPLIT -n 4 split\n";

    public Collection getArguments() {
        return this.splitArguments;
    }

    public String getCommandDescription() {
        return COMMAND_DESCRIPTION;
    }

    public String getHelpExamples() {
        return SPLIT_EXAMPLES;
    }

    public String getHelpMessage() {
        return SPLIT_HELP_TEXT;
    }

    public Collection getOptions() {
        return this.splitOptions;
    }
}

