/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Iterator;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.UnpackParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class UnpackCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        UnpackParsedCommand parsedCommandDTO = new UnpackParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidDirectory(outFile);
        parsedCommandDTO.setOutputFile(outFile);
        PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
        FileParam dOption = (FileParam)cmdLineHandler.getOption("d");
        if (!fOption.isSet() && !dOption.isSet()) throw new ParseException(25);
        if (fOption.isSet()) {
            Iterator fIterator = fOption.getPdfFiles().iterator();
            while (fIterator.hasNext()) {
                PdfFile currentFile = (PdfFile)fIterator.next();
                ValidationUtility.assertValidPdfExtension(currentFile.getFile().getName());
            }
            parsedCommandDTO.setInputFileList(FileUtility.getPdfFiles(fOption.getPdfFiles()));
        }
        if (!dOption.isSet()) return parsedCommandDTO;
        File inputDir = dOption.getFile();
        ValidationUtility.assertValidDirectory(inputDir);
        parsedCommandDTO.setInputDirectory(inputDir);
        return parsedCommandDTO;
    }
}

