/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestEnvironment;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public class DigestTools {
    public static IDigest createDigest(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof IDigest) {
            return (IDigest)object;
        }
        if (object instanceof String) {
            if (StringTools.isEmpty((String)object)) {
                return null;
            }
            object = Base64.decode((String)object);
        }
        if (object instanceof ILocator) {
            object = LocatorTools.getBytes((ILocator)object);
        }
        if (object instanceof ILocatorSupport) {
            object = LocatorTools.getBytes(((ILocatorSupport)object).getLocator());
        }
        if (object instanceof byte[]) {
            return DigestEnvironment.get().decode((byte[])object);
        }
        if (object instanceof IArgs) {
            IArgs iArgs = (IArgs)object;
            byte[] byArray = ArgTools.getByteArray(iArgs, "der", null);
            if (byArray == null) {
                byArray = ArgTools.getByteArray(iArgs, "raw", null);
                String string = ArgTools.getString(iArgs, "algorithm", "SHA256");
                if (byArray != null) {
                    return DigestEnvironment.get().createDigest(string, byArray);
                }
            } else {
                return DigestEnvironment.get().decode(byArray);
            }
        }
        try {
            return ConverterRegistry.get().convert(object, IDigest.class);
        }
        catch (ConversionException conversionException) {
            throw new IOException("can't convert " + object + " to digest");
        }
    }

    public static IDigester createDigesterSHA1() {
        try {
            return DigestEnvironment.get().createDigester("SHA1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IllegalStateException("SHA1 digest not supported");
        }
    }

    public static IDigest digest(IDigester iDigester, InputStream inputStream) throws IOException {
        return DigestTools.digest(iDigester, inputStream, 1024);
    }

    public static IDigest digest(IDigester iDigester, InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        while (n2 != -1) {
            iDigester.update(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        return iDigester.digest();
    }

    public static int suggestBufferSize(long l) {
        int n = l < 32768L ? 1024 : (l < 0x100000L ? 32768 : 98304);
        return n;
    }
}

