/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.enumeration;

import de.intarsys.tools.enumeration.CanonicalFromEnumItemConverter;
import de.intarsys.tools.enumeration.EnumMeta;
import de.intarsys.tools.message.Message;
import java.util.HashMap;
import java.util.Map;

public abstract class EnumItem
implements Comparable {
    private static final Map META;
    protected static int WEIGHT;
    private String iconName;
    private final String id;
    private Object label;
    private final int weight;
    private final EnumMeta<EnumItem> meta;

    static {
        new CanonicalFromEnumItemConverter();
        META = new HashMap();
        WEIGHT = 0;
    }

    protected static EnumMeta getMeta(Class clazz) {
        EnumMeta enumMeta = (EnumMeta)META.get(clazz);
        if (enumMeta == null) {
            enumMeta = new EnumMeta(clazz);
            META.put(clazz, enumMeta);
        }
        return enumMeta;
    }

    protected EnumItem(EnumMeta enumMeta, String string, Object object, int n) {
        this.meta = enumMeta;
        this.meta.addItem(this);
        this.id = string;
        this.label = object;
        this.weight = n;
    }

    protected EnumItem(String string) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = new Message(this, this.id);
        this.weight = WEIGHT++;
    }

    protected EnumItem(String string, int n) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = new Message(this, this.id);
        this.weight = n;
    }

    protected EnumItem(String string, Message message) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = message;
        this.weight = WEIGHT++;
    }

    protected EnumItem(String string, Message message, int n) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = message;
        this.weight = n;
    }

    protected EnumItem(String string, String string2) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = string2;
        this.weight = WEIGHT++;
    }

    protected EnumItem(String string, String string2, int n) {
        this.meta = EnumItem.getMeta(this.getClass());
        this.meta.addItem(this);
        this.id = string;
        this.label = string2;
        this.weight = n;
    }

    public int compareTo(Object object) {
        EnumItem enumItem = (EnumItem)object;
        return this.getWeight() - enumItem.getWeight();
    }

    protected String getDefaultLabel() {
        return this.id;
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return this.iconName;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label instanceof Message) {
            this.label = ((Message)this.label).get();
        }
        return (String)this.label;
    }

    public String getLocalizedLabel() {
        return this.getLabel();
    }

    protected EnumMeta getMeta() {
        return this.meta;
    }

    public String getTip() {
        return this.getLabel();
    }

    protected int getWeight() {
        return this.weight;
    }

    protected void setDefault() {
        this.getMeta().setDefault(this);
    }

    protected void setIconName(String string) {
        this.iconName = string;
    }

    protected void setLabel(String string) {
        this.label = string;
    }

    public String toString() {
        return this.getLabel();
    }
}

