/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgumentDeclaration;
import de.intarsys.tools.functor.DeclarationException;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IDeclaration;
import de.intarsys.tools.functor.IDeclarationBlock;
import de.intarsys.tools.functor.IDeclarationElement;
import de.intarsys.tools.functor.IDeclarationSupport;
import java.util.Iterator;

public class ArgumentDeclarator {
    private boolean lazy = true;
    private boolean strict = false;
    private static final Object UNDEFINED = new Object();

    public ArgumentDeclarator() {
    }

    public ArgumentDeclarator(boolean bl, boolean bl2) {
        this.strict = bl;
        this.lazy = bl2;
    }

    protected void apply(ArgumentDeclaration argumentDeclaration, int n, IArgs iArgs, IArgs iArgs2) throws DeclarationException {
        IArgs.IBinding iBinding;
        String string = argumentDeclaration.getName();
        Class clazz = argumentDeclaration.getType();
        IArgs.IBinding iBinding2 = iBinding = iArgs.declare(string);
        if (iArgs2 != iArgs) {
            iBinding2 = iArgs2.declare(string);
        }
        Object object = UNDEFINED;
        IDeclarationBlock iDeclarationBlock = argumentDeclaration.getDeclarationBlock();
        if (iBinding.isDefined()) {
            object = iBinding.getValue();
        } else if (argumentDeclaration.isDefaultDefined()) {
            try {
                object = argumentDeclaration.getDefaultValue();
            }
            catch (FunctorInvocationException functorInvocationException) {
                throw new DeclarationException(functorInvocationException);
            }
        } else if (iDeclarationBlock != null && iDeclarationBlock.size() > 0) {
            object = Args.create();
        }
        if (object != UNDEFINED) {
            if (object instanceof IArgs && iDeclarationBlock != null && iDeclarationBlock.size() > 0) {
                new ArgumentDeclarator(this.strict, this.lazy).apply(iDeclarationBlock, (IArgs)object);
            }
            try {
                if (clazz != Object.class) {
                    object = ConverterRegistry.get().convert(object, clazz);
                }
            }
            catch (ConversionException conversionException) {
                throw new DeclarationException("Unable to convert value for argument '" + argumentDeclaration.getName() + "' to type '" + argumentDeclaration.getType().getName() + "'", conversionException);
            }
            iBinding2.setValue(object);
        }
    }

    protected void apply(IDeclaration iDeclaration, int n, IArgs iArgs, IArgs iArgs2) throws DeclarationException {
        if (iDeclaration instanceof ArgumentDeclaration) {
            ArgumentDeclaration argumentDeclaration = (ArgumentDeclaration)iDeclaration;
            this.apply(argumentDeclaration, n, iArgs, iArgs2);
        } else if (iDeclaration instanceof IDeclarationBlock) {
            this.apply((IDeclarationBlock)iDeclaration, iArgs, iArgs2);
        } else if (iDeclaration instanceof IDeclarationSupport) {
            this.apply(((IDeclarationSupport)((Object)iDeclaration)).getDeclarationBlock(), iArgs, iArgs2);
        }
    }

    public IArgs apply(IDeclarationBlock iDeclarationBlock, IArgs iArgs) throws DeclarationException {
        IArgs iArgs2 = iArgs;
        if (this.strict) {
            iArgs2 = new Args();
        }
        this.apply(iDeclarationBlock, iArgs, iArgs2);
        if (this.strict) {
            Iterator<IArgs.IBinding> iterator = iArgs2.bindings();
            if (!this.lazy || this.lazy && iterator.hasNext()) {
                iArgs.clear();
                while (iterator.hasNext()) {
                    IArgs.IBinding iBinding = iterator.next();
                    if (iBinding.getName() == null) continue;
                    iArgs.put(iBinding.getName(), iBinding.getValue());
                }
            }
        }
        return iArgs;
    }

    protected void apply(IDeclarationBlock iDeclarationBlock, IArgs iArgs, IArgs iArgs2) throws DeclarationException {
        IDeclarationElement[] iDeclarationElementArray = iDeclarationBlock.getDeclarationElements();
        int n = 0;
        while (n < iDeclarationElementArray.length) {
            this.apply(iDeclarationElementArray[n], n, iArgs, iArgs2);
            ++n;
        }
    }
}

