/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.monitor;

import de.intarsys.tools.dom.ElementConfigurationException;
import de.intarsys.tools.dom.ElementTools;
import de.intarsys.tools.dom.IElementConfigurable;
import de.intarsys.tools.monitor.AbstractMonitorTrace;
import de.intarsys.tools.monitor.IMonitor;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.Trace;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public abstract class AbstractMonitor
implements IMonitor,
IElementConfigurable {
    private static Level defaultLevel = Level.INFO;
    private String name;
    private Logger logger;
    private Level level = defaultLevel;
    private LinkedList traces = new LinkedList();
    private int collectAll = 0;
    private int logCycle = 100;
    private int traceCount = 0;
    private ThreadLocal<AbstractMonitorTrace> tracePerThread = new ThreadLocal<AbstractMonitorTrace>(){

        @Override
        protected AbstractMonitorTrace initialValue() {
            return AbstractMonitor.this.createMonitorTrace();
        }
    };

    public static Level getDefaultLevel() {
        return defaultLevel;
    }

    public static void setDefaultLevel(Level level) {
        defaultLevel = level;
    }

    public AbstractMonitor() {
        this("");
    }

    public AbstractMonitor(String string) {
        this.name = string;
        this.logger = Logger.getLogger(string);
    }

    @Override
    public final ITrace attach() {
        AbstractMonitorTrace abstractMonitorTrace = (AbstractMonitorTrace)this.getCurrentTrace();
        abstractMonitorTrace.start();
        Trace.registerTrace(abstractMonitorTrace);
        return abstractMonitorTrace;
    }

    @Override
    public void configure(Element element) throws ElementConfigurationException {
        Object object;
        this.setName(ElementTools.getPathString(element, "name", ""));
        this.setCollectAll(ElementTools.getPathInt(element, "collect.count", 0));
        String string = ElementTools.getPathString(element, "logger", this.getName());
        if (string != null) {
            object = Logger.getLogger(string);
            this.setLogger((Logger)object);
        }
        object = defaultLevel.getName();
        String string2 = ElementTools.getPathString(element, "level", (String)object);
        this.setLevel(Level.parse(string2));
        int n = ElementTools.getPathInt(element, "logcycle", 100);
        this.setLogCycle(n);
    }

    protected abstract AbstractMonitorTrace createMonitorTrace();

    @Override
    public final void detach() {
        AbstractMonitorTrace abstractMonitorTrace = (AbstractMonitorTrace)this.getCurrentTrace();
        abstractMonitorTrace.stop();
    }

    protected LinkedList getBasicTraces() {
        return this.traces;
    }

    public int getCollectAll() {
        return this.collectAll;
    }

    @Override
    public ITrace getCurrentTrace() {
        return this.tracePerThread.get();
    }

    public Level getLevel() {
        return this.level;
    }

    public int getLogCycle() {
        return this.logCycle;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public synchronized List getTraces() {
        ArrayList arrayList = new ArrayList(this.traces);
        return arrayList;
    }

    @Override
    public void reset() {
        this.traceLog();
        this.traces = new LinkedList();
        this.traceCount = 0;
    }

    public void setCollectAll(int n) {
        this.collectAll = n;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public void setLogCycle(int n) {
        this.logCycle = n;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Deprecated
    public void start() {
        this.attach();
    }

    protected synchronized void started(ITrace iTrace) {
    }

    @Deprecated
    public void stop() {
        this.detach();
    }

    protected synchronized void stopped(ITrace iTrace) {
        Trace.unregisterTrace(iTrace);
        if (this.getCollectAll() > 0) {
            this.getBasicTraces().add(iTrace);
            this.tracePerThread.set(this.createMonitorTrace());
            if (this.getCollectAll() < this.getBasicTraces().size()) {
                this.getBasicTraces().removeFirst();
            }
        }
        ++this.traceCount;
        if (this.getLogCycle() != -1 && this.traceCount >= this.getLogCycle()) {
            this.reset();
        }
    }

    protected void traceLog() {
        if (this.getLogger() != null) {
            this.getLogger().logp(this.getLevel(), "", "", this.toString());
        }
    }
}

