type token =
  | TUnknown of (Parse_info.info)
  | EOF of (Parse_info.info)
  | TCommentSpace of (Parse_info.info)
  | TCommentNewline of (Parse_info.info)
  | TComment of (Parse_info.info)
  | TCommentMisc of (Parse_info.info)
  | TInt of (string * Parse_info.info)
  | TFloat of (string * Parse_info.info)
  | TChar of (string * Parse_info.info)
  | TString of (string * Parse_info.info)
  | TLowerIdent of (string * Parse_info.info)
  | TUpperIdent of (string * Parse_info.info)
  | TLabelUse of (string * Parse_info.info)
  | TLabelDecl of (string * Parse_info.info)
  | TOptLabelUse of (string * Parse_info.info)
  | TOptLabelDecl of (string * Parse_info.info)
  | Tfun of (Parse_info.info)
  | Tfunction of (Parse_info.info)
  | Trec of (Parse_info.info)
  | Ttype of (Parse_info.info)
  | Tof of (Parse_info.info)
  | Tif of (Parse_info.info)
  | Tthen of (Parse_info.info)
  | Telse of (Parse_info.info)
  | Tmatch of (Parse_info.info)
  | Twith of (Parse_info.info)
  | Twhen of (Parse_info.info)
  | Tlet of (Parse_info.info)
  | Tin of (Parse_info.info)
  | Tas of (Parse_info.info)
  | Ttry of (Parse_info.info)
  | Texception of (Parse_info.info)
  | Tbegin of (Parse_info.info)
  | Tend of (Parse_info.info)
  | Tfor of (Parse_info.info)
  | Tdo of (Parse_info.info)
  | Tdone of (Parse_info.info)
  | Tdownto of (Parse_info.info)
  | Twhile of (Parse_info.info)
  | Tto of (Parse_info.info)
  | Tval of (Parse_info.info)
  | Texternal of (Parse_info.info)
  | Ttrue of (Parse_info.info)
  | Tfalse of (Parse_info.info)
  | Tmodule of (Parse_info.info)
  | Topen of (Parse_info.info)
  | Tfunctor of (Parse_info.info)
  | Tinclude of (Parse_info.info)
  | Tsig of (Parse_info.info)
  | Tstruct of (Parse_info.info)
  | Tclass of (Parse_info.info)
  | Tnew of (Parse_info.info)
  | Tinherit of (Parse_info.info)
  | Tconstraint of (Parse_info.info)
  | Tinitializer of (Parse_info.info)
  | Tmethod of (Parse_info.info)
  | Tobject of (Parse_info.info)
  | Tprivate of (Parse_info.info)
  | Tvirtual of (Parse_info.info)
  | Tlazy of (Parse_info.info)
  | Tmutable of (Parse_info.info)
  | Tassert of (Parse_info.info)
  | Tand of (Parse_info.info)
  | Tor of (Parse_info.info)
  | Tmod of (Parse_info.info)
  | Tlor of (Parse_info.info)
  | Tlsl of (Parse_info.info)
  | Tlsr of (Parse_info.info)
  | Tlxor of (Parse_info.info)
  | Tasr of (Parse_info.info)
  | Tland of (Parse_info.info)
  | TOParen of (Parse_info.info)
  | TCParen of (Parse_info.info)
  | TOBrace of (Parse_info.info)
  | TCBrace of (Parse_info.info)
  | TOBracket of (Parse_info.info)
  | TCBracket of (Parse_info.info)
  | TOBracketPipe of (Parse_info.info)
  | TPipeCBracket of (Parse_info.info)
  | TOBracketLess of (Parse_info.info)
  | TGreaterCBracket of (Parse_info.info)
  | TOBraceLess of (Parse_info.info)
  | TGreaterCBrace of (Parse_info.info)
  | TOBracketGreater of (Parse_info.info)
  | TColonGreater of (Parse_info.info)
  | TDot of (Parse_info.info)
  | TDotDot of (Parse_info.info)
  | TComma of (Parse_info.info)
  | TEq of (Parse_info.info)
  | TAssign of (Parse_info.info)
  | TAssignMutable of (Parse_info.info)
  | TColon of (Parse_info.info)
  | TColonColon of (Parse_info.info)
  | TBang of (Parse_info.info)
  | TBangEq of (Parse_info.info)
  | TTilde of (Parse_info.info)
  | TPipe of (Parse_info.info)
  | TSemiColon of (Parse_info.info)
  | TSemiColonSemiColon of (Parse_info.info)
  | TQuestion of (Parse_info.info)
  | TQuestionQuestion of (Parse_info.info)
  | TUnderscore of (Parse_info.info)
  | TStar of (Parse_info.info)
  | TArrow of (Parse_info.info)
  | TQuote of (Parse_info.info)
  | TBackQuote of (Parse_info.info)
  | TAnd of (Parse_info.info)
  | TAndAnd of (Parse_info.info)
  | TSharp of (Parse_info.info)
  | TMinusDot of (Parse_info.info)
  | TPlusDot of (Parse_info.info)
  | TPlus of (Parse_info.info)
  | TMinus of (Parse_info.info)
  | TLess of (Parse_info.info)
  | TGreater of (Parse_info.info)
  | TPrefixOperator of (string * Parse_info.info)
  | TInfixOperator of (string * Parse_info.info)
  | TSharpDirective of (Parse_info.info)

val interface :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_ml.toplevel list
val implementation :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> Ast_ml.toplevel list
