/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scilab.forge.jlatexmath.AlphabetRegistration;
import org.scilab.forge.jlatexmath.AlphabetRegistrationException;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.DefaultTeXFontParser;
import org.scilab.forge.jlatexmath.Extension;
import org.scilab.forge.jlatexmath.FontAlreadyLoadedException;
import org.scilab.forge.jlatexmath.FontInfo;
import org.scilab.forge.jlatexmath.Metrics;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.SymbolAtom;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;
import org.scilab.forge.jlatexmath.TeXParser;
import org.scilab.forge.jlatexmath.TextStyleMappingNotFoundException;
import org.scilab.forge.jlatexmath.XMLResourceParseException;

public class DefaultTeXFont
implements TeXFont {
    private static String[] defaultTextStyleMappings;
    protected static final int NONE = -1;
    protected static final int NUMBERS = 0;
    protected static final int CAPITALS = 1;
    protected static final int SMALL = 2;
    protected static final int UNICODE = 3;
    private static final int NUMBER_OF_FONT_IDS = 256;
    private static Map<String, CharFont[]> textStyleMappings;
    private static Map<String, CharFont> symbolMappings;
    private static FontInfo[] fontInfo;
    private static Map<String, Float> parameters;
    private static Map<String, Number> generalSettings;
    private static boolean magnificationEnable;
    protected static final int TOP = 0;
    protected static final int MID = 1;
    protected static final int REP = 2;
    protected static final int BOT = 3;
    protected static final int WIDTH = 0;
    protected static final int HEIGHT = 1;
    protected static final int DEPTH = 2;
    protected static final int IT = 3;
    public static List<Character.UnicodeBlock> loadedAlphabets;
    public static Map<Character.UnicodeBlock, AlphabetRegistration> registeredAlphabets;
    protected float factor = 1.0f;
    public boolean isBold = false;
    public boolean isRoman = false;
    public boolean isSs = false;
    public boolean isTt = false;
    public boolean isIt = false;
    private final float size;

    public DefaultTeXFont(float f) {
        this.size = f;
    }

    public DefaultTeXFont(float f, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this(f, 1.0f, bl, bl2, bl3, bl4, bl5);
    }

    public DefaultTeXFont(float f, float f2, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.size = f;
        this.factor = f2;
        this.isBold = bl;
        this.isRoman = bl2;
        this.isSs = bl3;
        this.isTt = bl4;
        this.isIt = bl5;
    }

    public static void addTeXFontDescription(String string) throws ResourceParseException {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        DefaultTeXFont.addTeXFontDescription(fileInputStream, string);
    }

    public static void addTeXFontDescription(InputStream inputStream, String string) throws ResourceParseException {
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser(inputStream, string);
        fontInfo = defaultTeXFontParser.parseFontDescriptions(fontInfo);
        textStyleMappings.putAll(defaultTeXFontParser.parseTextStyleMappings());
        symbolMappings.putAll(defaultTeXFontParser.parseSymbolMappings());
    }

    public static void addTeXFontDescription(Object object, InputStream inputStream, String string) throws ResourceParseException {
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser(object, inputStream, string);
        fontInfo = defaultTeXFontParser.parseFontDescriptions(fontInfo);
        defaultTeXFontParser.parseExtraPath();
        textStyleMappings.putAll(defaultTeXFontParser.parseTextStyleMappings());
        symbolMappings.putAll(defaultTeXFontParser.parseSymbolMappings());
    }

    public static void addAlphabet(Character.UnicodeBlock unicodeBlock, InputStream inputStream, String string, InputStream inputStream2, String string2, InputStream inputStream3, String string3) throws ResourceParseException {
        if (!loadedAlphabets.contains(unicodeBlock)) {
            DefaultTeXFont.addTeXFontDescription(inputStream, string);
            SymbolAtom.addSymbolAtom(inputStream2, string2);
            TeXFormula.addSymbolMappings(inputStream3, string3);
            loadedAlphabets.add(unicodeBlock);
        }
    }

    public static void addAlphabet(Object object, Character.UnicodeBlock[] unicodeBlockArray, String string) throws ResourceParseException {
        int n;
        boolean bl = false;
        for (n = 0; !bl && n < unicodeBlockArray.length; ++n) {
            bl = loadedAlphabets.contains(unicodeBlockArray[n]) || bl;
        }
        if (!bl) {
            TeXParser.isLoading = true;
            DefaultTeXFont.addTeXFontDescription(object, object.getClass().getResourceAsStream(string), string);
            for (n = 0; n < unicodeBlockArray.length; ++n) {
                loadedAlphabets.add(unicodeBlockArray[n]);
            }
            TeXParser.isLoading = false;
        }
    }

    public static void addAlphabet(Character.UnicodeBlock unicodeBlock, String string) {
        String string2 = "fonts/" + string + "/language_" + string + ".xml";
        String string3 = "fonts/" + string + "/symbols_" + string + ".xml";
        String string4 = "fonts/" + string + "/mappings_" + string + ".xml";
        try {
            DefaultTeXFont.addAlphabet(unicodeBlock, TeXFormula.class.getResourceAsStream(string2), string2, TeXFormula.class.getResourceAsStream(string3), string3, TeXFormula.class.getResourceAsStream(string4), string4);
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
            // empty catch block
        }
    }

    public static void addAlphabet(AlphabetRegistration alphabetRegistration) {
        try {
            if (alphabetRegistration != null) {
                DefaultTeXFont.addAlphabet(alphabetRegistration.getPackage(), alphabetRegistration.getUnicodeBlock(), alphabetRegistration.getTeXFontFileName());
            }
        }
        catch (FontAlreadyLoadedException fontAlreadyLoadedException) {
        }
        catch (AlphabetRegistrationException alphabetRegistrationException) {
            System.err.println(alphabetRegistrationException.toString());
        }
    }

    public static void registerAlphabet(AlphabetRegistration alphabetRegistration) {
        Character.UnicodeBlock[] unicodeBlockArray = alphabetRegistration.getUnicodeBlock();
        for (int i = 0; i < unicodeBlockArray.length; ++i) {
            registeredAlphabets.put(unicodeBlockArray[i], alphabetRegistration);
        }
    }

    public TeXFont copy() {
        return new DefaultTeXFont(this.size, this.factor, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    public TeXFont deriveFont(float f) {
        return new DefaultTeXFont(f, this.factor, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    public TeXFont scaleFont(float f) {
        return new DefaultTeXFont(this.size, f, this.isBold, this.isRoman, this.isSs, this.isTt, this.isIt);
    }

    public float getScaleFactor() {
        return this.factor;
    }

    public float getAxisHeight(int n) {
        return DefaultTeXFont.getParameter("axisheight") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getBigOpSpacing1(int n) {
        return DefaultTeXFont.getParameter("bigopspacing1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getBigOpSpacing2(int n) {
        return DefaultTeXFont.getParameter("bigopspacing2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getBigOpSpacing3(int n) {
        return DefaultTeXFont.getParameter("bigopspacing3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getBigOpSpacing4(int n) {
        return DefaultTeXFont.getParameter("bigopspacing4") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getBigOpSpacing5(int n) {
        return DefaultTeXFont.getParameter("bigopspacing5") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    private Char getChar(char c, CharFont[] charFontArray, int n) {
        int n2;
        int n3;
        if (c >= '0' && c <= '9') {
            n3 = 0;
            n2 = c - 48;
        } else if (c >= 'a' && c <= 'z') {
            n3 = 2;
            n2 = c - 97;
        } else if (c >= 'A' && c <= 'Z') {
            n3 = 1;
            n2 = c - 65;
        } else {
            n3 = 3;
            n2 = c;
        }
        if (charFontArray[n3] == null) {
            return this.getDefaultChar(c, n);
        }
        return this.getChar(new CharFont((char)(charFontArray[n3].c + n2), charFontArray[n3].fontId), n);
    }

    public Char getChar(char c, String string, int n) throws TextStyleMappingNotFoundException {
        CharFont[] charFontArray = textStyleMappings.get(string);
        if (charFontArray == null) {
            throw new TextStyleMappingNotFoundException(string);
        }
        return this.getChar(c, charFontArray, n);
    }

    public Char getChar(CharFont charFont, int n) {
        float f = DefaultTeXFont.getSizeFactor(n);
        int n2 = this.isBold ? charFont.boldFontId : charFont.fontId;
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n2];
        if (this.isBold && charFont.fontId == charFont.boldFontId) {
            n2 = fontInfo.getBoldId();
            fontInfo = DefaultTeXFont.fontInfo[n2];
            charFont = new CharFont(charFont.c, n2, n);
        }
        if (this.isRoman) {
            n2 = fontInfo.getRomanId();
            fontInfo = DefaultTeXFont.fontInfo[n2];
            charFont = new CharFont(charFont.c, n2, n);
        }
        if (this.isSs) {
            n2 = fontInfo.getSsId();
            fontInfo = DefaultTeXFont.fontInfo[n2];
            charFont = new CharFont(charFont.c, n2, n);
        }
        if (this.isTt) {
            n2 = fontInfo.getTtId();
            fontInfo = DefaultTeXFont.fontInfo[n2];
            charFont = new CharFont(charFont.c, n2, n);
        }
        if (this.isIt) {
            n2 = fontInfo.getItId();
            fontInfo = DefaultTeXFont.fontInfo[n2];
            charFont = new CharFont(charFont.c, n2, n);
        }
        Font font = fontInfo.getFont();
        return new Char(charFont.c, font, n2, this.getMetrics(charFont, this.factor * f));
    }

    public Char getChar(String string, int n) throws SymbolMappingNotFoundException {
        CharFont charFont = symbolMappings.get(string);
        if (charFont == null) {
            throw new SymbolMappingNotFoundException(string);
        }
        return this.getChar(charFont, n);
    }

    public Char getDefaultChar(char c, int n) {
        if (c >= '0' && c <= '9') {
            return this.getChar(c, defaultTextStyleMappings[0], n);
        }
        if (c >= 'a' && c <= 'z') {
            return this.getChar(c, defaultTextStyleMappings[2], n);
        }
        return this.getChar(c, defaultTextStyleMappings[1], n);
    }

    public float getDefaultRuleThickness(int n) {
        return DefaultTeXFont.getParameter("defaultrulethickness") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getDenom1(int n) {
        return DefaultTeXFont.getParameter("denom1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getDenom2(int n) {
        return DefaultTeXFont.getParameter("denom2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public Extension getExtension(Char char_, int n) {
        Font font = char_.getFont();
        int n2 = char_.getFontCode();
        float f = DefaultTeXFont.getSizeFactor(n);
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n2];
        int[] nArray = fontInfo.getExtension(char_.getChar());
        Char[] charArray = new Char[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            charArray[i] = nArray[i] == -1 ? null : new Char((char)nArray[i], font, n2, this.getMetrics(new CharFont((char)nArray[i], n2), f));
        }
        return new Extension(charArray[0], charArray[1], charArray[2], charArray[3]);
    }

    public float getKern(CharFont charFont, CharFont charFont2, int n) {
        if (charFont.fontId == charFont2.fontId) {
            FontInfo fontInfo = DefaultTeXFont.fontInfo[charFont.fontId];
            return fontInfo.getKern(charFont.c, charFont2.c, DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT);
        }
        return 0.0f;
    }

    public CharFont getLigature(CharFont charFont, CharFont charFont2) {
        if (charFont.fontId == charFont2.fontId) {
            FontInfo fontInfo = DefaultTeXFont.fontInfo[charFont.fontId];
            return fontInfo.getLigature(charFont.c, charFont2.c);
        }
        return null;
    }

    private Metrics getMetrics(CharFont charFont, float f) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[charFont.fontId];
        float[] fArray = fontInfo.getMetrics(charFont.c);
        return new Metrics(fArray[0], fArray[1], fArray[2], fArray[3], f * TeXFormula.PIXELS_PER_POINT, f);
    }

    public int getMuFontId() {
        return generalSettings.get("mufontid").intValue();
    }

    public Char getNextLarger(Char char_, int n) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[char_.getFontCode()];
        CharFont charFont = fontInfo.getNextLarger(char_.getChar());
        FontInfo fontInfo2 = DefaultTeXFont.fontInfo[charFont.fontId];
        return new Char(charFont.c, fontInfo2.getFont(), charFont.fontId, this.getMetrics(charFont, DefaultTeXFont.getSizeFactor(n)));
    }

    public float getNum1(int n) {
        return DefaultTeXFont.getParameter("num1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getNum2(int n) {
        return DefaultTeXFont.getParameter("num2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getNum3(int n) {
        return DefaultTeXFont.getParameter("num3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getQuad(int n, int n2) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n2];
        return fontInfo.getQuad(DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT);
    }

    public float getSize() {
        return this.size;
    }

    public float getSkew(CharFont charFont, int n) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[charFont.fontId];
        char c = fontInfo.getSkewChar();
        if (c == '\uffffffff') {
            return 0.0f;
        }
        return this.getKern(charFont, new CharFont(c, charFont.fontId), n);
    }

    public float getSpace(int n) {
        int n2 = generalSettings.get("spacefontid").intValue();
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n2];
        return fontInfo.getSpace(DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT);
    }

    public float getSub1(int n) {
        return DefaultTeXFont.getParameter("sub1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSub2(int n) {
        return DefaultTeXFont.getParameter("sub2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSubDrop(int n) {
        return DefaultTeXFont.getParameter("subdrop") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSup1(int n) {
        return DefaultTeXFont.getParameter("sup1") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSup2(int n) {
        return DefaultTeXFont.getParameter("sup2") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSup3(int n) {
        return DefaultTeXFont.getParameter("sup3") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getSupDrop(int n) {
        return DefaultTeXFont.getParameter("supdrop") * DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public float getXHeight(int n, int n2) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n2];
        return fontInfo.getXHeight(DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT);
    }

    public float getEM(int n) {
        return DefaultTeXFont.getSizeFactor(n) * TeXFormula.PIXELS_PER_POINT;
    }

    public boolean hasNextLarger(Char char_) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[char_.getFontCode()];
        return fontInfo.getNextLarger(char_.getChar()) != null;
    }

    public void setBold(boolean bl) {
        this.isBold = bl;
    }

    public boolean getBold() {
        return this.isBold;
    }

    public void setRoman(boolean bl) {
        this.isRoman = bl;
    }

    public boolean getRoman() {
        return this.isRoman;
    }

    public void setTt(boolean bl) {
        this.isTt = bl;
    }

    public boolean getTt() {
        return this.isTt;
    }

    public void setIt(boolean bl) {
        this.isIt = bl;
    }

    public boolean getIt() {
        return this.isIt;
    }

    public void setSs(boolean bl) {
        this.isSs = bl;
    }

    public boolean getSs() {
        return this.isSs;
    }

    public boolean hasSpace(int n) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[n];
        return fontInfo.hasSpace();
    }

    public boolean isExtensionChar(Char char_) {
        FontInfo fontInfo = DefaultTeXFont.fontInfo[char_.getFontCode()];
        return fontInfo.getExtension(char_.getChar()) != null;
    }

    public static void setMathSizes(float f, float f2, float f3, float f4) {
        if (magnificationEnable) {
            generalSettings.put("scriptfactor", Float.valueOf(Math.abs(f3 / f)));
            generalSettings.put("scriptscriptfactor", Float.valueOf(Math.abs(f4 / f)));
            generalSettings.put("textfactor", Float.valueOf(Math.abs(f2 / f)));
            TeXIcon.defaultSize = Math.abs(f);
        }
    }

    public static void setMagnification(float f) {
        if (magnificationEnable) {
            TeXIcon.magFactor = f / 1000.0f;
        }
    }

    public static void enableMagnification(boolean bl) {
        magnificationEnable = bl;
    }

    private static float getParameter(String string) {
        Float f = parameters.get(string);
        if (f == null) {
            return 0.0f;
        }
        return f.floatValue();
    }

    public static float getSizeFactor(int n) {
        if (n < 2) {
            return 1.0f;
        }
        if (n < 4) {
            return generalSettings.get("textfactor").floatValue();
        }
        if (n < 6) {
            return generalSettings.get("scriptfactor").floatValue();
        }
        return generalSettings.get("scriptscriptfactor").floatValue();
    }

    static {
        fontInfo = new FontInfo[0];
        magnificationEnable = true;
        loadedAlphabets = new ArrayList<Character.UnicodeBlock>();
        registeredAlphabets = new HashMap<Character.UnicodeBlock, AlphabetRegistration>();
        DefaultTeXFontParser defaultTeXFontParser = new DefaultTeXFontParser();
        loadedAlphabets.add(Character.UnicodeBlock.of('a'));
        fontInfo = defaultTeXFontParser.parseFontDescriptions(fontInfo);
        parameters = defaultTeXFontParser.parseParameters();
        textStyleMappings = defaultTeXFontParser.parseTextStyleMappings();
        defaultTextStyleMappings = defaultTeXFontParser.parseDefaultTextStyleMappings();
        symbolMappings = defaultTeXFontParser.parseSymbolMappings();
        generalSettings = defaultTeXFontParser.parseGeneralSettings();
        generalSettings.put("textfactor", 1);
        int n = generalSettings.get("mufontid").intValue();
        if (n < 0 || n >= fontInfo.length || fontInfo[n] == null) {
            throw new XMLResourceParseException("DefaultTeXFont.xml", "GeneralSettings", "mufontid", "contains an unknown font id!");
        }
    }
}

