/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IntObjectHashMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLBufferStorage;
import javax.media.opengl.GLException;
import jogamp.opengl.Debug;
import jogamp.opengl.GLBufferStateTracker;

public class GLBufferObjectTracker {
    protected static final boolean DEBUG;
    private final IntObjectHashMap bufferName2StorageMap = new IntObjectHashMap();
    private static final String GL_INVALID_OPERATION = "GL_INVALID_OPERATION";
    private static final String GL_INVALID_VALUE = "GL_INVALID_VALUE";
    private static final String warning = "WARNING";
    private static final String msgClazzName = "GLBufferObjectTracker";
    private static final String msgUnmapped = "notifyBufferUnmapped()";
    private static final String msgCreateBound = "createBoundBufferStorage()";
    private static final String msgCreateNamed = "createNamedBufferStorage()";
    private static final String msgMapBuffer = "mapBuffer()";

    public GLBufferObjectTracker() {
        this.bufferName2StorageMap.setKeyNotFoundValue(null);
    }

    public final synchronized void createBufferStorage(GLBufferStateTracker gLBufferStateTracker, GL gL, int n, long l, Buffer buffer, int n2, int n3, CreateStorageDispatch createStorageDispatch, long l2) throws GLException {
        boolean bl;
        int n4;
        int n5 = gL.glGetError();
        if (DEBUG && 0 != n5) {
            System.err.printf("%s.%s glerr-pre 0x%X%n", msgClazzName, msgCreateBound, n5);
        }
        if (0 == (n4 = gLBufferStateTracker.getBoundBufferObject(n, gL))) {
            throw new GLException(String.format("%s: Buffer for target 0x%X not bound", GL_INVALID_OPERATION, n));
        }
        boolean bl2 = 0 != n2;
        boolean bl3 = bl = bl2 && 0L > l || !bl2 && 0L >= l;
        if (bl) {
            throw new GLException(String.format("%s: Invalid size %d for buffer %d on target 0x%X", GL_INVALID_VALUE, l, n4, n));
        }
        createStorageDispatch.create(n, l, buffer, bl2 ? n2 : n3, l2);
        int n6 = gL.glGetError();
        if (0 != n6) {
            throw new GLException(String.format("GL-Error 0x%X while creating %s storage for target 0x%X -> buffer %d of size %d with data %s", n6, bl2 ? "mutable" : "immutable", n, n4, l, buffer));
        }
        GLBufferStorageImpl gLBufferStorageImpl = new GLBufferStorageImpl(n4, l, n2, n3);
        GLBufferStorageImpl gLBufferStorageImpl2 = (GLBufferStorageImpl)this.bufferName2StorageMap.put(n4, (Object)gLBufferStorageImpl);
        if (DEBUG) {
            System.err.printf("%s.%s target: 0x%X -> %d: %s -> %s%n", msgClazzName, msgCreateBound, n, n4, gLBufferStorageImpl2, gLBufferStorageImpl);
        }
        if (null != gLBufferStorageImpl2) {
            gLBufferStorageImpl2.setMappedBuffer(null);
        }
    }

    public final synchronized void createBufferStorage(GL gL, int n, long l, Buffer buffer, int n2, int n3, CreateStorageDispatch createStorageDispatch, long l2) throws GLException {
        boolean bl;
        int n4 = gL.glGetError();
        if (DEBUG && 0 != n4) {
            System.err.printf("%s.%s glerr-pre 0x%X%n", msgClazzName, msgCreateNamed, n4);
        }
        if (0L > l) {
            throw new GLException(String.format("%s: Invalid size %d for buffer %d", GL_INVALID_VALUE, l, n));
        }
        boolean bl2 = bl = 0 != n2;
        if (!bl) {
            throw new InternalError("Immutable glNamedBufferStorageEXT not supported yet");
        }
        createStorageDispatch.create(n, l, buffer, n2, l2);
        int n5 = gL.glGetError();
        if (0 != n5) {
            throw new GLException(String.format("GL-Error 0x%X while creating %s storage for buffer %d of size %d with data %s", n5, "mutable", n, l, buffer));
        }
        GLBufferStorageImpl gLBufferStorageImpl = new GLBufferStorageImpl(n, l, n2, 0);
        GLBufferStorageImpl gLBufferStorageImpl2 = (GLBufferStorageImpl)this.bufferName2StorageMap.put(n, (Object)gLBufferStorageImpl);
        if (DEBUG) {
            System.err.printf("%s.%s direct: %d: %s -> %s%n", msgClazzName, msgCreateNamed, n, gLBufferStorageImpl2, gLBufferStorageImpl);
        }
        if (null != gLBufferStorageImpl2) {
            gLBufferStorageImpl2.setMappedBuffer(null);
        }
    }

    public final synchronized void notifyBuffersDeleted(int n, int[] nArray, int n2) {
        for (int i = 0; i < n; ++i) {
            this.notifyBufferDeleted(nArray[i + n2], i, n);
        }
    }

    public final synchronized void notifyBuffersDeleted(int n, IntBuffer intBuffer) {
        int n2 = intBuffer.position();
        for (int i = 0; i < n; ++i) {
            this.notifyBufferDeleted(intBuffer.get(i + n2), i, n);
        }
    }

    private final synchronized void notifyBufferDeleted(int n, int n2, int n3) {
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.put(n, null);
        if (DEBUG) {
            System.err.printf("%s.notifyBuffersDeleted()[%d/%d]: %d: %s -> null%n", msgClazzName, n2 + 1, n3, n, gLBufferStorageImpl);
        }
        if (null == gLBufferStorageImpl) {
            if (DEBUG) {
                System.err.printf("%s: %s.notifyBuffersDeleted()[%d/%d]: Buffer %d not tracked%n", warning, msgClazzName, n2 + 1, n3, n);
                Thread.dumpStack();
            }
            return;
        }
        gLBufferStorageImpl.setMappedBuffer(null);
    }

    public final synchronized GLBufferStorage mapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n, int n2, MapBufferAllDispatch mapBufferAllDispatch, long l) throws GLException {
        return this.mapBufferImpl(gLBufferStateTracker, gL, n, false, 0L, 0L, n2, (MapBufferDispatch)mapBufferAllDispatch, l);
    }

    public final synchronized GLBufferStorage mapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n, long l, long l2, int n2, MapBufferRangeDispatch mapBufferRangeDispatch, long l3) throws GLException {
        return this.mapBufferImpl(gLBufferStateTracker, gL, n, true, l, l2, n2, (MapBufferDispatch)mapBufferRangeDispatch, l3);
    }

    public final synchronized GLBufferStorage mapBuffer(int n, int n2, MapBufferAllDispatch mapBufferAllDispatch, long l) throws GLException {
        return this.mapBufferImpl(0, n, true, false, 0L, 0L, n2, (MapBufferDispatch)mapBufferAllDispatch, l);
    }

    public final synchronized GLBufferStorage mapBuffer(int n, long l, long l2, int n2, MapBufferRangeDispatch mapBufferRangeDispatch, long l3) throws GLException {
        return this.mapBufferImpl(0, n, true, true, l, l2, n2, (MapBufferDispatch)mapBufferRangeDispatch, l3);
    }

    private final synchronized GLBufferStorage mapBufferImpl(GLBufferStateTracker gLBufferStateTracker, GL gL, int n, boolean bl, long l, long l2, int n2, MapBufferDispatch mapBufferDispatch, long l3) throws GLException {
        int n3 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        if (0 == n3) {
            throw new GLException(String.format("%s.%s: %s Buffer for target 0x%X not bound", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n));
        }
        return this.mapBufferImpl(n, n3, false, bl, l, l2, n2, mapBufferDispatch, l3);
    }

    private final synchronized GLBufferStorage mapBufferImpl(int n, int n2, boolean bl, boolean bl2, long l, long l2, int n3, MapBufferDispatch mapBufferDispatch, long l3) throws GLException {
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n2);
        if (null == gLBufferStorageImpl) {
            throw new GLException("Buffer with name " + n2 + " not tracked");
        }
        if (null != gLBufferStorageImpl.getMappedBuffer()) {
            throw new GLException(String.format("%s.%s: %s Buffer storage of target 0x%X -> %d: %s is already mapped", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n, n2, gLBufferStorageImpl));
        }
        long l4 = gLBufferStorageImpl.getSize();
        if (0L > l4) {
            throw new GLException(String.format("%s.%s: %s Buffer storage of target 0x%X -> %d: %s is of less-than zero", msgClazzName, msgMapBuffer, GL_INVALID_OPERATION, n, n2, gLBufferStorageImpl));
        }
        if (!bl2) {
            l2 = l4;
            l = 0L;
        }
        if (l2 + l > l4) {
            throw new GLException(String.format("%s.%s: %s Out of range: offset %d, length %d, buffer storage of target 0x%X -> %d: %s", msgClazzName, msgMapBuffer, GL_INVALID_VALUE, l, l2, n, n2, gLBufferStorageImpl));
        }
        if (0L >= l2 || 0L > l) {
            throw new GLException(String.format("%s.%s: %s Invalid values: offset %d, length %d, buffer storage of target 0x%X -> %d: %s", msgClazzName, msgMapBuffer, GL_INVALID_VALUE, l, l2, n, n2, gLBufferStorageImpl));
        }
        if (0L == l4) {
            return gLBufferStorageImpl;
        }
        long l5 = bl ? (bl2 ? ((MapBufferRangeDispatch)mapBufferDispatch).mapBuffer(n2, l, l2, n3, l3) : ((MapBufferAllDispatch)mapBufferDispatch).mapBuffer(n2, n3, l3)) : (bl2 ? ((MapBufferRangeDispatch)mapBufferDispatch).mapBuffer(n, l, l2, n3, l3) : ((MapBufferAllDispatch)mapBufferDispatch).mapBuffer(n, n3, l3));
        if (0L == l5) {
            if (DEBUG) {
                System.err.printf("%s.%s: %s MapBuffer null result for target 0x%X -> %d: %s, off %d, len %d, acc 0x%X%n", msgClazzName, msgMapBuffer, warning, n, n2, gLBufferStorageImpl, l, l2, n3);
                Thread.dumpStack();
            }
        } else {
            ByteBuffer byteBuffer = mapBufferDispatch.allocNioByteBuffer(l5, l2);
            Buffers.nativeOrder((ByteBuffer)byteBuffer);
            if (DEBUG) {
                System.err.printf("%s.%s: Target 0x%X -> %d: %s, off %d, len %d, acc 0x%X%n", msgClazzName, msgClazzName, n, n2, gLBufferStorageImpl.toString(false), l, l2, n3);
            }
            gLBufferStorageImpl.setMappedBuffer(byteBuffer);
        }
        return gLBufferStorageImpl;
    }

    public final synchronized boolean unmapBuffer(GLBufferStateTracker gLBufferStateTracker, GL gL, int n, UnmapBufferDispatch unmapBufferDispatch, long l) {
        GLBufferStorageImpl gLBufferStorageImpl;
        int n2 = gLBufferStateTracker.getBoundBufferObject(n, gL);
        if (0 == n2) {
            if (DEBUG) {
                System.err.printf("%s: %s.%s: Buffer for target 0x%X not bound%n", warning, msgClazzName, msgUnmapped, n);
                Thread.dumpStack();
            }
            gLBufferStorageImpl = null;
        } else {
            gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n2);
            if (DEBUG && null == gLBufferStorageImpl) {
                System.err.printf("%s: %s.%s: Buffer %d not tracked%n", warning, msgClazzName, msgUnmapped, n2);
                Thread.dumpStack();
            }
        }
        boolean bl = unmapBufferDispatch.unmap(n, l);
        if (bl && null != gLBufferStorageImpl) {
            gLBufferStorageImpl.setMappedBuffer(null);
        }
        if (DEBUG) {
            System.err.printf("%s.%s %s target: 0x%X -> %d: %s%n", msgClazzName, msgUnmapped, bl ? "OK" : "Failed", n, n2, gLBufferStorageImpl.toString(false));
            if (!bl) {
                Thread.dumpStack();
            }
        }
        return bl;
    }

    public final synchronized boolean unmapBuffer(int n, UnmapBufferDispatch unmapBufferDispatch, long l) {
        boolean bl;
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n);
        if (DEBUG && null == gLBufferStorageImpl) {
            System.err.printf("%s: %s.%s: Buffer %d not tracked%n", warning, msgClazzName, msgUnmapped, n);
            Thread.dumpStack();
        }
        if ((bl = unmapBufferDispatch.unmap(n, l)) && null != gLBufferStorageImpl) {
            gLBufferStorageImpl.setMappedBuffer(null);
        }
        if (DEBUG) {
            System.err.printf("%s.%s %s %d: %s%n", msgClazzName, msgUnmapped, bl ? "OK" : "Failed", n, gLBufferStorageImpl.toString(false));
            if (!bl) {
                Thread.dumpStack();
            }
        }
        return bl;
    }

    public final synchronized long getBufferSize(int n) {
        GLBufferStorageImpl gLBufferStorageImpl = (GLBufferStorageImpl)this.bufferName2StorageMap.get(n);
        if (null == gLBufferStorageImpl) {
            if (DEBUG) {
                System.err.printf("%s: %s.getBufferSize(): Buffer %d not tracked%n", warning, msgClazzName, n);
                Thread.dumpStack();
            }
            return 0L;
        }
        return gLBufferStorageImpl.getSize();
    }

    public final synchronized GLBufferStorage getBufferStorage(int n) {
        return (GLBufferStorageImpl)this.bufferName2StorageMap.get(n);
    }

    public final synchronized void clear() {
        if (DEBUG) {
            System.err.printf("%s.clear() - Thread %s%n", msgClazzName, Thread.currentThread().getName());
        }
        this.bufferName2StorageMap.clear();
    }

    static {
        Debug.initSingleton();
        DEBUG = Debug.isPropertyDefined((String)"jogl.debug.GLBufferObjectTracker", (boolean)true);
    }

    public static interface CreateStorageDispatch {
        public void create(int var1, long var2, Buffer var4, int var5, long var6);
    }

    static final class GLBufferStorageImpl
    extends GLBufferStorage {
        GLBufferStorageImpl(int n, long l, int n2, int n3) {
            super(n, l, n2, n3);
        }

        final void setMappedBuffer(ByteBuffer byteBuffer) {
            if (DEBUG) {
                System.err.printf("%s.GLBufferStorage.setMappedBuffer: %s: %s -> %s%n", GLBufferObjectTracker.msgClazzName, this.toString(true), this.mappedBuffer, byteBuffer);
            }
            this.mappedBuffer = byteBuffer;
        }
    }

    public static interface MapBufferAllDispatch
    extends MapBufferDispatch {
        public long mapBuffer(int var1, int var2, long var3);
    }

    public static interface MapBufferDispatch {
        public ByteBuffer allocNioByteBuffer(long var1, long var3);
    }

    public static interface MapBufferRangeDispatch
    extends MapBufferDispatch {
        public long mapBuffer(int var1, long var2, long var4, int var6, long var7);
    }

    public static interface UnmapBufferDispatch {
        public boolean unmap(int var1, long var2);
    }
}

