/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.api.Transformer;
import org.gradle.internal.Cast;
import org.gradle.internal.Factories;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.AddProjectionsAction;
import org.gradle.model.internal.core.ChildNodeInitializerStrategy;
import org.gradle.model.internal.core.DeferredModelAction;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelMapGroovyView;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.ModelViewState;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.NoInputsModelAction;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerContext;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeBackedModelMap<T>
extends ModelMapGroovyView<T>
implements ManagedInstance {
    private final ModelType<T> elementType;
    private final ModelRuleDescriptor sourceDescriptor;
    private final MutableModelNode modelNode;
    private final String description;
    private final boolean eager;
    private final ModelViewState viewState;
    private final ChildNodeInitializerStrategy<? super T> creatorStrategy;

    public NodeBackedModelMap(String description, ModelType<T> elementType, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, boolean eager, ModelViewState viewState, ChildNodeInitializerStrategy<? super T> creatorStrategy) {
        this.description = description;
        this.eager = eager;
        this.viewState = viewState;
        this.creatorStrategy = creatorStrategy;
        this.elementType = elementType;
        this.modelNode = modelNode;
        this.sourceDescriptor = sourceDescriptor;
    }

    public NodeBackedModelMap(ModelType<T> type, ModelRuleDescriptor sourceDescriptor, MutableModelNode modelNode, boolean eager, ModelViewState viewState, ChildNodeInitializerStrategy<? super T> childStrategy) {
        this(NodeBackedModelMap.derivedDescription(modelNode, type), type, sourceDescriptor, modelNode, eager, viewState, childStrategy);
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingRegistry(final ModelType<T> baseItemModelType, final NodeInitializerRegistry nodeInitializerRegistry) {
        return new ChildNodeInitializerStrategy<T>(){

            @Override
            public <S extends T> NodeInitializer initializer(ModelType<S> type) {
                if (!baseItemModelType.isAssignableFrom(type) || baseItemModelType.equals(type)) {
                    throw new IllegalArgumentException(String.format("%s is not a subtype of %s", type, baseItemModelType));
                }
                return nodeInitializerRegistry.getNodeInitializer(NodeInitializerContext.forType(type));
            }
        };
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingParentNode(final ModelType<T> baseItemModelType) {
        return NodeBackedModelMap.createUsingParentNode(new Transformer<NamedEntityInstantiator<T>, MutableModelNode>(){

            public NamedEntityInstantiator<T> transform(MutableModelNode modelNode) {
                return modelNode.getPrivateData(NodeBackedModelMap.instantiatorTypeOf(baseItemModelType));
            }
        });
    }

    public static <T> ChildNodeInitializerStrategy<T> createUsingParentNode(final Transformer<? extends NamedEntityInstantiator<T>, ? super MutableModelNode> instantiatorTransform) {
        return new ChildNodeInitializerStrategy<T>(){

            @Override
            public <S extends T> NodeInitializer initializer(final ModelType<S> type) {
                return new NodeInitializer(){

                    @Override
                    public Multimap<ModelActionRole, ModelAction> getActions(ModelReference<?> subject, ModelRuleDescriptor descriptor) {
                        return ImmutableSetMultimap.builder().put((Object)ModelActionRole.Discover, AddProjectionsAction.of(subject, descriptor, UnmanagedModelProjection.of(type))).put((Object)ModelActionRole.Create, (Object)DirectNodeNoInputsModelAction.of(subject, descriptor, (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

                            public void execute(MutableModelNode modelNode) {
                                NamedEntityInstantiator instantiator = (NamedEntityInstantiator)instantiatorTransform.transform((Object)modelNode.getParent());
                                Object item = instantiator.create(modelNode.getPath().getName(), type.getConcreteClass());
                                modelNode.setPrivateData(type, item);
                            }
                        })).build();
                    }
                };
            }
        };
    }

    public static <I> ModelType<NamedEntityInstantiator<I>> instantiatorTypeOf(ModelType<I> type) {
        return new ModelType.Builder<NamedEntityInstantiator<I>>(){}.where(new ModelType.Parameter<I>(){}, type).build();
    }

    @Override
    public MutableModelNode getBackingNode() {
        return this.modelNode;
    }

    @Override
    public ModelType<?> getManagedType() {
        return ModelType.of(this.getClass());
    }

    @Override
    public <S> void afterEach(Class<S> type, Action<? super S> configAction) {
        this.doFinalizeAll(ModelType.of(type), configAction);
    }

    public <S> void afterEach(Class<S> type, DeferredModelAction configAction) {
        this.doFinalizeAll(ModelType.of(type), configAction);
    }

    @Override
    public void afterEach(Action<? super T> configAction) {
        this.doFinalizeAll(this.elementType, configAction);
    }

    public void afterEach(DeferredModelAction configAction) {
        this.doFinalizeAll(this.elementType, configAction);
    }

    @Override
    public void all(Action<? super T> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "all()");
        ModelReference<T> subject = ModelReference.of(this.elementType);
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    public void all(DeferredModelAction configAction) {
        this.viewState.assertCanMutate();
        ModelReference<T> subject = ModelReference.of(this.elementType);
        this.modelNode.applyToAllLinks(ModelActionRole.Initialize, this.toInitializeAction(subject, configAction, ModelActionRole.Mutate));
    }

    @Override
    public void beforeEach(Action<? super T> configAction) {
        this.doBeforeEach(this.elementType, configAction);
    }

    public void beforeEach(DeferredModelAction configAction) {
        this.doBeforeEach(this.elementType, configAction);
    }

    @Override
    public <S> void beforeEach(Class<S> type, Action<? super S> configAction) {
        this.doBeforeEach(ModelType.of(type), configAction);
    }

    public <S> void beforeEach(Class<S> type, DeferredModelAction configAction) {
        this.doBeforeEach(ModelType.of(type), configAction);
    }

    @Override
    public boolean containsKey(Object name) {
        this.viewState.assertCanReadChildren();
        return name instanceof String && this.modelNode.hasLink((String)name, this.elementType);
    }

    @Override
    public boolean containsValue(Object item) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void create(String name) {
        this.doCreate(name, this.elementType, (Action)null);
    }

    @Override
    public void create(String name, Action<? super T> configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    public void create(String name, DeferredModelAction configAction) {
        this.doCreate(name, this.elementType, configAction);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type) {
        this.doCreate(name, ModelType.of(type), (Action)null);
    }

    @Override
    public <S extends T> void create(String name, Class<S> type, Action<? super S> configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    public <S extends T> void create(String name, Class<S> type, DeferredModelAction configAction) {
        this.doCreate(name, ModelType.of(type), configAction);
    }

    @Override
    public void put(String name, T instance) {
        Class type = (Class)Cast.uncheckedCast(instance.getClass());
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "put()");
        this.modelNode.addLink(ModelRegistrations.unmanagedInstance(ModelReference.of(this.modelNode.getPath().child(name), type), Factories.constant(instance)).descriptor(descriptor).build());
    }

    private <S> void doBeforeEach(ModelType<S> type, Action<? super S> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "beforeEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Defaults, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    private <S> void doBeforeEach(ModelType<S> type, DeferredModelAction configAction) {
        this.viewState.assertCanMutate();
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Defaults, this.toInitializeAction(subject, configAction, ModelActionRole.Defaults));
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, DeferredModelAction action) {
        ModelPath childPath = this.modelNode.getPath().child(name);
        this.doCreate(childPath, type, action.getDescriptor(), this.toInitializeAction(ModelReference.of(childPath, type), action, ModelActionRole.Initialize));
    }

    private <S extends T> void doCreate(String name, ModelType<S> type, @Nullable Action<? super S> initAction) {
        ModelPath childPath = this.modelNode.getPath().child(name);
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "create(%s)", name);
        if (initAction != null) {
            this.doCreate(childPath, type, descriptor, NoInputsModelAction.of(ModelReference.of(childPath, type), descriptor, initAction));
        } else {
            this.doCreate(childPath, type, descriptor, null);
        }
    }

    private <S extends T> void doCreate(ModelPath childPath, ModelType<S> type, ModelRuleDescriptor descriptor, @Nullable ModelAction initAction) {
        this.viewState.assertCanMutate();
        NodeInitializer nodeInitializer = this.creatorStrategy.initializer(type);
        ModelRegistrations.Builder builder = ModelRegistrations.of(childPath, nodeInitializer).descriptor(descriptor);
        if (initAction != null) {
            builder.action(ModelActionRole.Initialize, initAction);
        }
        ModelRegistration registration = builder.build();
        this.modelNode.addLink(registration);
        if (this.eager) {
            this.modelNode.getLink(childPath.getName()).ensureUsable();
        }
    }

    private <S> void doFinalizeAll(ModelType<S> type, Action<? super S> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "afterEach()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Finalize, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    private <S> void doFinalizeAll(ModelType<S> type, DeferredModelAction configAction) {
        this.viewState.assertCanMutate();
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Initialize, this.toInitializeAction(subject, configAction, ModelActionRole.Finalize));
    }

    @Override
    @Nullable
    public T get(Object name) {
        return this.get((String)name);
    }

    @Override
    @Nullable
    public T get(String name) {
        this.viewState.assertCanReadChildren();
        MutableModelNode link = this.modelNode.getLink(name);
        if (link == null) {
            return null;
        }
        link.ensureUsable();
        if (this.viewState.isCanMutate()) {
            return link.asMutable(this.elementType, this.sourceDescriptor, null).getInstance();
        }
        return link.asImmutable(this.elementType, this.sourceDescriptor).getInstance();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<String> keySet() {
        this.viewState.assertCanReadChildren();
        return this.modelNode.getLinkNames(this.elementType);
    }

    @Override
    public void named(String name, Action<? super T> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "named(%s)", name);
        ModelReference<T> subject = ModelReference.of(this.modelNode.getPath().child(name), this.elementType);
        this.modelNode.applyToLink(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    @Override
    public void named(String name, Class<? extends RuleSource> ruleSource) {
        this.viewState.assertCanMutate();
        this.modelNode.applyToLink(name, ruleSource);
    }

    public void named(String name, DeferredModelAction action) {
        this.viewState.assertCanMutate();
        ModelReference<Object> subject = ModelReference.of(this.modelNode.getPath().child(name));
        this.modelNode.applyToLink(ModelActionRole.Initialize, this.toInitializeAction(subject, action, ModelActionRole.Mutate));
    }

    private ModelAction toInitializeAction(ModelReference<?> subject, final DeferredModelAction action, final ModelActionRole role) {
        return DirectNodeNoInputsModelAction.of(subject, action.getDescriptor(), (Action<? super MutableModelNode>)new Action<MutableModelNode>(){

            public void execute(MutableModelNode node) {
                action.execute(node, role);
            }
        });
    }

    @Override
    public int size() {
        this.viewState.assertCanReadChildren();
        return this.modelNode.getLinkCount(this.elementType);
    }

    public String toString() {
        return this.description;
    }

    private static String derivedDescription(ModelNode modelNode, ModelType<?> elementType) {
        return ModelMap.class.getSimpleName() + '<' + elementType.getDisplayName() + "> '" + modelNode.getPath() + "'";
    }

    public <S extends T> ModelMap<S> toSubType(Class<S> type) {
        ChildNodeInitializerStrategy creatorStrategy = (ChildNodeInitializerStrategy)Cast.uncheckedCast(this.creatorStrategy);
        return new NodeBackedModelMap<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, this.eager, this.viewState, creatorStrategy);
    }

    @Override
    public Collection<T> values() {
        this.viewState.assertCanReadChildren();
        Iterable values = Iterables.transform(this.keySet(), (Function)new Function<String, T>(){

            public T apply(@Nullable String name) {
                return NodeBackedModelMap.this.get(name);
            }
        });
        return Lists.newArrayList((Iterable)values);
    }

    @Override
    public Iterator<T> iterator() {
        this.viewState.assertCanReadChildren();
        return Iterators.transform(this.keySet().iterator(), (Function)new Function<String, T>(){

            public T apply(@Nullable String name) {
                return NodeBackedModelMap.this.get(name);
            }
        });
    }

    @Override
    public <S> void withType(Class<S> type, Action<? super S> configAction) {
        this.viewState.assertCanMutate();
        ModelRuleDescriptor descriptor = NestedModelRuleDescriptor.append(this.sourceDescriptor, "withType()");
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Mutate, NoInputsModelAction.of(subject, descriptor, configAction));
    }

    public <S> void withType(Class<S> type, DeferredModelAction configAction) {
        this.viewState.assertCanMutate();
        ModelReference<S> subject = ModelReference.of(type);
        this.modelNode.applyToAllLinks(ModelActionRole.Initialize, this.toInitializeAction(subject, configAction, ModelActionRole.Mutate));
    }

    @Override
    public <S> void withType(Class<S> type, Class<? extends RuleSource> rules) {
        this.viewState.assertCanMutate();
        this.modelNode.applyToLinks(ModelType.of(type), rules);
    }

    @Override
    public <S> ModelMap<S> withType(Class<S> type) {
        if (type.equals(this.elementType.getConcreteClass())) {
            return (ModelMap)Cast.uncheckedCast((Object)this);
        }
        if (this.elementType.getConcreteClass().isAssignableFrom(type)) {
            Class castType = (Class)Cast.uncheckedCast(type);
            ModelMap<S> subType = this.toSubType(castType);
            return (ModelMap)Cast.uncheckedCast(subType);
        }
        return new NodeBackedModelMap<S>(ModelType.of(type), this.sourceDescriptor, this.modelNode, this.eager, this.viewState, new ChildNodeInitializerStrategy<S>(){

            @Override
            public <D extends S> NodeInitializer initializer(ModelType<D> type) {
                throw new IllegalArgumentException(String.format("Cannot create an item of type %s as this is not a subtype of %s.", type, NodeBackedModelMap.this.elementType.toString()));
            }
        });
    }

    @Override
    public Void methodMissing(String name, Object argsObj) {
        Object[] args = (Object[])argsObj;
        if (args.length == 2 && args[0] instanceof Class && args[1] instanceof DeferredModelAction) {
            Class itemType = (Class)Cast.uncheckedCast((Object)args[0]);
            DeferredModelAction action = (DeferredModelAction)Cast.uncheckedCast((Object)args[1]);
            this.doCreate(name, ModelType.of(itemType), action);
            return null;
        }
        if (args.length == 1 && args[0] instanceof DeferredModelAction) {
            DeferredModelAction action = (DeferredModelAction)Cast.uncheckedCast((Object)args[0]);
            this.named(name, action);
            return null;
        }
        return super.methodMissing(name, argsObj);
    }
}

