/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.binary;

import org.apache.commons.lang.StringUtils;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Nullable;
import org.gradle.api.internal.AbstractBuildableModelElement;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.reflect.DirectInstantiator;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.reflect.ObjectInstantiationException;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.core.ModelMaps;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.ModelInstantiationException;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryTasksCollection;
import org.gradle.platform.base.internal.FixedBuildAbility;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class BaseBinarySpec
extends AbstractBuildableModelElement
implements BinarySpecInternal {
    private final DomainObjectSet<LanguageSourceSet> inputSourceSets = new DefaultDomainObjectSet(LanguageSourceSet.class);
    private static ThreadLocal<BinaryInfo> nextBinaryInfo = new ThreadLocal();
    private final BinaryTasksCollection tasks;
    private final String name;
    private final MutableModelNode modelNode;
    private final MutableModelNode componentNode;
    private final MutableModelNode sources;
    private final Class<? extends BinarySpec> publicType;
    private BinaryNamingScheme namingScheme;
    private boolean disabled;

    public static <T extends BaseBinarySpec> T create(Class<? extends BinarySpec> publicType, Class<T> implementationType, String name, MutableModelNode modelNode, @Nullable MutableModelNode componentNode, Instantiator instantiator, ITaskFactory taskFactory) {
        nextBinaryInfo.set(new BinaryInfo(name, publicType, implementationType, modelNode, componentNode, taskFactory, instantiator));
        try {
            BaseBinarySpec baseBinarySpec = (BaseBinarySpec)DirectInstantiator.INSTANCE.newInstance(implementationType, new Object[0]);
            return (T)baseBinarySpec;
        }
        catch (ObjectInstantiationException e) {
            throw new ModelInstantiationException(String.format("Could not create binary of type %s", publicType.getSimpleName()), e.getCause());
        }
        finally {
            nextBinaryInfo.set(null);
        }
    }

    public BaseBinarySpec() {
        this(nextBinaryInfo.get());
    }

    private BaseBinarySpec(BinaryInfo info) {
        if (info == null) {
            throw new ModelInstantiationException("Direct instantiation of a BaseBinarySpec is not permitted. Use a BinaryTypeBuilder instead.");
        }
        this.name = info.name;
        this.publicType = info.publicType;
        this.modelNode = info.modelNode;
        this.componentNode = info.componentNode;
        this.tasks = (BinaryTasksCollection)info.instantiator.newInstance(DefaultBinaryTasksCollection.class, new Object[]{this, info.taskFactory});
        this.sources = ModelMaps.addModelMapNode((MutableModelNode)this.modelNode, LanguageSourceSet.class, (String)"sources");
        ComponentSpec component = this.getComponent();
        this.namingScheme = DefaultBinaryNamingScheme.component(component == null ? null : component.getName()).withBinaryName(this.name).withBinaryType(this.getTypeName());
    }

    @Override
    public Class<? extends BinarySpec> getPublicType() {
        return this.publicType;
    }

    @Nullable
    public ComponentSpec getComponent() {
        return this.getComponentAs(ComponentSpec.class);
    }

    @Nullable
    protected <T extends ComponentSpec> T getComponentAs(Class<T> componentType) {
        if (this.componentNode != null && this.componentNode.canBeViewedAs(ModelType.of(componentType))) {
            return (T)((ComponentSpec)this.componentNode.asImmutable(ModelType.of(componentType), this.componentNode.getDescriptor()).getInstance());
        }
        return null;
    }

    protected String getTypeName() {
        return this.publicType.getSimpleName();
    }

    @Override
    public String getProjectScopedName() {
        ComponentSpec owner = this.getComponent();
        return owner == null ? this.name : owner.getName() + StringUtils.capitalize((String)this.name);
    }

    @Override
    public String getDisplayName() {
        ComponentSpec owner = this.getComponent();
        if (owner == null) {
            return String.format("%s '%s'", this.getTypeName(), this.name);
        }
        return String.format("%s '%s:%s'", this.getTypeName(), owner.getName(), this.name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public void setBuildable(boolean buildable) {
        this.disabled = !buildable;
    }

    @Override
    public final boolean isBuildable() {
        return this.getBuildAbility().isBuildable();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getSource() {
        DeprecationLogger.nagUserOfReplacedProperty((String)"source", (String)"inputs");
        return this.getInputs();
    }

    @Override
    public DomainObjectSet<LanguageSourceSet> getInputs() {
        return this.inputSourceSets;
    }

    @Override
    public ModelMap<LanguageSourceSet> getSources() {
        return ModelMaps.asMutableView((MutableModelNode)this.sources, LanguageSourceSet.class, (String)(this.modelNode.toString() + ".getSources()"));
    }

    @Override
    public BinaryTasksCollection getTasks() {
        return this.tasks;
    }

    @Override
    public boolean isLegacyBinary() {
        return false;
    }

    @Override
    public BinaryNamingScheme getNamingScheme() {
        return this.namingScheme;
    }

    @Override
    public void setNamingScheme(BinaryNamingScheme namingScheme) {
        this.namingScheme = namingScheme;
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public final BinaryBuildAbility getBuildAbility() {
        if (this.disabled) {
            return new FixedBuildAbility(false);
        }
        return this.getBinaryBuildAbility();
    }

    protected BinaryBuildAbility getBinaryBuildAbility() {
        return new FixedBuildAbility(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BinaryInfo {
        private final String name;
        private final Class<? extends BinarySpec> publicType;
        private final MutableModelNode modelNode;
        private final MutableModelNode componentNode;
        private final ITaskFactory taskFactory;
        private final Instantiator instantiator;

        private BinaryInfo(String name, Class<? extends BinarySpec> publicType, Class<? extends BaseBinarySpec> implementationType, MutableModelNode modelNode, MutableModelNode componentNode, ITaskFactory taskFactory, Instantiator instantiator) {
            this.name = name;
            this.publicType = publicType;
            this.modelNode = modelNode;
            this.componentNode = componentNode;
            this.taskFactory = taskFactory;
            this.instantiator = instantiator;
        }
    }
}

