/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.internal.configure;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Transformer;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.language.nativeplatform.HeaderExportingSourceSet;
import org.gradle.model.Defaults;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.RuleSource;
import org.gradle.nativeplatform.BuildType;
import org.gradle.nativeplatform.BuildTypeContainer;
import org.gradle.nativeplatform.Flavor;
import org.gradle.nativeplatform.FlavorContainer;
import org.gradle.nativeplatform.NativeBinarySpec;
import org.gradle.nativeplatform.NativeComponentSpec;
import org.gradle.nativeplatform.internal.TargetedNativeComponentInternal;
import org.gradle.nativeplatform.internal.configure.NativeBinaries;
import org.gradle.nativeplatform.internal.resolve.NativeDependencyResolver;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.platform.internal.NativePlatforms;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultBinaryNamingScheme;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeComponentRules
extends RuleSource {
    @Defaults
    public void applyHeaderSourceSetConventions(final NativeComponentSpec component) {
        component.getSources().withType(HeaderExportingSourceSet.class).afterEach((Action)new Action<HeaderExportingSourceSet>(){

            public void execute(HeaderExportingSourceSet headerSourceSet) {
                if (headerSourceSet.getExportedHeaders().getSrcDirs().isEmpty()) {
                    headerSourceSet.getExportedHeaders().srcDir((Object)String.format("src/%s/headers", component.getName()));
                }
                headerSourceSet.getImplicitHeaders().setSrcDirs((Iterable)headerSourceSet.getSource().getSrcDirs());
                headerSourceSet.getImplicitHeaders().include(new String[]{"**/*.h"});
            }
        });
    }

    @Finalize
    public static void createBinaries(NativeComponentSpec nativeComponent, PlatformResolvers platforms, BuildTypeContainer buildTypes, FlavorContainer flavors, ServiceRegistry serviceRegistry) {
        NativePlatforms nativePlatforms = (NativePlatforms)serviceRegistry.get(NativePlatforms.class);
        NativeDependencyResolver nativeDependencyResolver = (NativeDependencyResolver)serviceRegistry.get(NativeDependencyResolver.class);
        NativeComponentRules.createBinariesImpl(nativeComponent, platforms, (Set<? extends BuildType>)((Object)buildTypes), (Set<? extends Flavor>)((Object)flavors), nativePlatforms, nativeDependencyResolver);
    }

    static void createBinariesImpl(NativeComponentSpec nativeComponent, PlatformResolvers platforms, Set<? extends BuildType> buildTypes, Set<? extends Flavor> flavors, NativePlatforms nativePlatforms, NativeDependencyResolver nativeDependencyResolver) {
        if (!(nativeComponent instanceof TargetedNativeComponentInternal)) {
            return;
        }
        TargetedNativeComponentInternal targetedComponent = (TargetedNativeComponentInternal)((Object)nativeComponent);
        List<NativePlatform> resolvedPlatforms = NativeComponentRules.resolvePlatforms(targetedComponent, nativePlatforms, platforms);
        for (NativePlatform platform : resolvedPlatforms) {
            BinaryNamingScheme namingScheme = DefaultBinaryNamingScheme.component((String)nativeComponent.getName());
            namingScheme = namingScheme.withVariantDimension((Named)platform, resolvedPlatforms);
            NativeComponentRules.executeForEachBuildType(nativeComponent, (NativePlatformInternal)platform, namingScheme, buildTypes, flavors, nativeDependencyResolver);
        }
    }

    private static List<NativePlatform> resolvePlatforms(TargetedNativeComponentInternal targetedComponent, NativePlatforms nativePlatforms, final PlatformResolvers platforms) {
        List<PlatformRequirement> targetPlatforms = targetedComponent.getTargetPlatforms();
        if (targetPlatforms.isEmpty()) {
            PlatformRequirement requirement = DefaultPlatformRequirement.create((String)nativePlatforms.getDefaultPlatformName());
            targetPlatforms = Collections.singletonList(requirement);
        }
        return CollectionUtils.collect((List)targetPlatforms, (Transformer)new Transformer<NativePlatform, PlatformRequirement>(){

            public NativePlatform transform(PlatformRequirement platformRequirement) {
                return (NativePlatform)platforms.resolve(NativePlatform.class, platformRequirement);
            }
        });
    }

    private static void executeForEachBuildType(NativeComponentSpec projectNativeComponent, NativePlatformInternal platform, BinaryNamingScheme namingScheme, Set<? extends BuildType> allBuildTypes, Set<? extends Flavor> allFlavors, NativeDependencyResolver nativeDependencyResolver) {
        Set<BuildType> targetBuildTypes = ((TargetedNativeComponentInternal)((Object)projectNativeComponent)).chooseBuildTypes(allBuildTypes);
        for (BuildType buildType : targetBuildTypes) {
            BinaryNamingScheme namingSchemeWithBuildType = namingScheme.withVariantDimension((Named)buildType, targetBuildTypes);
            NativeComponentRules.executeForEachFlavor(projectNativeComponent, platform, buildType, namingSchemeWithBuildType, allFlavors, nativeDependencyResolver);
        }
    }

    private static void executeForEachFlavor(NativeComponentSpec projectNativeComponent, NativePlatform platform, BuildType buildType, BinaryNamingScheme namingScheme, Set<? extends Flavor> allFlavors, NativeDependencyResolver nativeDependencyResolver) {
        Set<Flavor> targetFlavors = ((TargetedNativeComponentInternal)((Object)projectNativeComponent)).chooseFlavors(allFlavors);
        for (Flavor flavor : targetFlavors) {
            BinaryNamingScheme namingSchemeWithFlavor = namingScheme.withVariantDimension((Named)flavor, targetFlavors);
            NativeBinaries.createNativeBinaries(projectNativeComponent, (ModelMap<NativeBinarySpec>)projectNativeComponent.getBinaries().withType(NativeBinarySpec.class), nativeDependencyResolver, namingSchemeWithFlavor, platform, buildType, flavor);
        }
    }
}

