/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.report.log;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.spockframework.report.log.IReportLogListener;
import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.IStandardStreamsListener;
import org.spockframework.runtime.model.Attachment;
import org.spockframework.runtime.model.BlockInfo;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.runtime.model.Tag;
import org.spockframework.util.CollectionUtil;
import org.spockframework.util.ExceptionUtil;
import org.spockframework.util.IFunction;
import org.spockframework.util.TextUtil;

class ReportLogEmitter
implements IRunListener,
IStandardStreamsListener {
    private final List<IReportLogListener> listeners = new ArrayList<IReportLogListener>();
    private SpecInfo currentSpec;
    private FeatureInfo currentFeature;
    private boolean specFailed;
    private boolean featureFailed;

    ReportLogEmitter() {
    }

    public void addListener(IReportLogListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void standardOut(String message) {
        this.standardStream(message, "output");
    }

    @Override
    public void standardErr(String message) {
        this.standardStream(message, "errorOutput");
    }

    private void standardStream(String message, String key) {
        if (this.currentFeature != null) {
            this.emit(CollectionUtil.mapOf("package", this.currentSpec.getPackage(), "name", this.currentSpec.getName(), "features", CollectionUtil.listOf(CollectionUtil.mapOf("name", this.currentFeature.getName(), key, CollectionUtil.listOf(message)))));
        } else if (this.currentSpec != null) {
            this.emit(CollectionUtil.mapOf("package", this.currentSpec.getPackage(), "name", this.currentSpec.getName(), key, CollectionUtil.listOf(message)));
        }
    }

    @Override
    public void beforeSpec(SpecInfo spec) {
        this.currentSpec = spec;
        this.specFailed = false;
        this.emit(CollectionUtil.putAll(CollectionUtil.mapOf("package", spec.getPackage(), "name", spec.getName(), "start", this.getCurrentTime()), this.renderNarrative(spec.getNarrative()), this.renderTags(spec.getTags())));
    }

    @Override
    public void beforeFeature(FeatureInfo feature) {
        this.currentFeature = feature;
        this.featureFailed = false;
        this.emit(CollectionUtil.mapOf("package", feature.getSpec().getBottomSpec().getPackage(), "name", feature.getSpec().getBottomSpec().getName(), "features", CollectionUtil.listOf(CollectionUtil.putAll(CollectionUtil.mapOf("name", feature.getName(), "start", this.getCurrentTime()), this.renderBlocks(feature.getBlocks()), this.renderTags(feature.getTags())))));
    }

    @Override
    public void beforeIteration(IterationInfo iteration) {
    }

    @Override
    public void afterIteration(IterationInfo iteration) {
    }

    @Override
    public void afterFeature(FeatureInfo feature) {
        this.emit(CollectionUtil.mapOf("package", feature.getSpec().getBottomSpec().getPackage(), "name", feature.getSpec().getBottomSpec().getName(), "features", CollectionUtil.listOf(CollectionUtil.putAll(CollectionUtil.mapOf("name", feature.getName(), "end", this.getCurrentTime(), "result", this.featureFailed ? "failed" : "passed"), this.renderAttachments(feature.getAttachments())))));
        this.currentFeature = null;
    }

    @Override
    public void afterSpec(SpecInfo spec) {
        this.emit(CollectionUtil.putAll(CollectionUtil.mapOf("package", spec.getPackage(), "name", spec.getName(), "end", this.getCurrentTime(), "result", this.specFailed ? "failed" : "passed"), this.renderAttachments(spec.getAttachments())));
        this.currentSpec = null;
    }

    @Override
    public void error(ErrorInfo error) {
        this.specFailed = true;
        SpecInfo spec = ((SpecInfo)error.getMethod().getParent()).getBottomSpec();
        FeatureInfo feature = error.getMethod().getFeature();
        if (feature != null) {
            this.featureFailed = true;
            this.emit(CollectionUtil.mapOf("package", spec.getPackage(), "name", spec.getName(), "features", CollectionUtil.listOf(CollectionUtil.mapOf("name", feature.getName(), "exceptions", CollectionUtil.listOf(ExceptionUtil.printStackTrace(error.getException()))))));
        } else {
            this.emit(CollectionUtil.mapOf("package", spec.getPackage(), "name", spec.getName(), "exceptions", CollectionUtil.listOf(ExceptionUtil.printStackTrace(error.getException()))));
        }
    }

    @Override
    public void specSkipped(SpecInfo spec) {
        long now = this.getCurrentTime();
        this.emit(CollectionUtil.putAll(CollectionUtil.mapOf("package", spec.getPackage(), "name", spec.getName(), "start", now, "end", now, "result", "skipped"), this.renderNarrative(spec.getNarrative()), this.renderTags(spec.getTags())));
    }

    @Override
    public void featureSkipped(FeatureInfo feature) {
        long now = this.getCurrentTime();
        this.emit(CollectionUtil.mapOf("package", feature.getSpec().getBottomSpec().getPackage(), "name", feature.getSpec().getBottomSpec().getName(), "features", CollectionUtil.listOf(CollectionUtil.putAll(CollectionUtil.mapOf("name", feature.getName(), "start", now, "end", now, "result", "skipped"), this.renderBlocks(feature.getBlocks()), this.renderTags(feature.getTags())))));
    }

    protected long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private Map renderTags(List<Tag> tags) {
        if (tags.isEmpty()) {
            return Collections.emptyMap();
        }
        ArrayList<Object> result = CollectionUtil.filterMap(tags, new IFunction<Tag, Object>(){

            @Override
            public Object apply(Tag tag) {
                return CollectionUtil.filterNullValues(CollectionUtil.mapOf("name", tag.getName(), "key", tag.getKey(), "value", tag.getValue(), "url", tag.getUrl()));
            }
        });
        return CollectionUtil.mapOf("tags", result);
    }

    private Map renderNarrative(String narrative) {
        return narrative != null ? CollectionUtil.mapOf("narrative", narrative) : Collections.emptyMap();
    }

    private Map renderBlocks(List<BlockInfo> blocks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < blocks.size(); ++i) {
            BlockInfo block = blocks.get(i);
            if (block.getTexts().isEmpty()) continue;
            String name = block.getKind().name();
            String label = name.equals("SETUP") ? "Given" : TextUtil.capitalize(name.toLowerCase());
            for (int j = 0; j < block.getTexts().size(); ++j) {
                String text = block.getTexts().get(j);
                if (j == 0) {
                    builder.append(label);
                } else {
                    builder.append("And");
                }
                builder.append(" ");
                builder.append(text);
                if (i >= blocks.size() - 1 && j >= block.getTexts().size() - 1) continue;
                builder.append("\n");
            }
        }
        String result = builder.toString();
        return result.length() > 0 ? CollectionUtil.mapOf("narrative", result) : Collections.emptyMap();
    }

    private Map renderAttachments(List<Attachment> attachments) {
        ArrayList<Object> result = CollectionUtil.filterMap(attachments, new IFunction<Attachment, Object>(){

            @Override
            public Object apply(Attachment attachment) {
                return CollectionUtil.mapOf("name", attachment.getName(), "url", attachment.getUrl());
            }
        });
        return result != null ? CollectionUtil.mapOf("attachments", result) : Collections.emptyMap();
    }

    private void emit(Map log) {
        for (IReportLogListener listener : this.listeners) {
            listener.emitted(log);
        }
    }
}

