/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.bag;

import com.gs.collections.api.bag.MutableBag;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.bag.ImmutableBagMultimap;
import com.gs.collections.api.multimap.bag.MutableBagMultimap;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.bag.mutable.HashBag;
import com.gs.collections.impl.block.procedure.checked.CheckedObjectIntProcedure;
import com.gs.collections.impl.block.procedure.checked.CheckedProcedure2;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import com.gs.collections.impl.multimap.bag.ImmutableBagMultimapImpl;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashBagMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableBag<V>>
implements MutableBagMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 1L;

    public HashBagMultimap() {
    }

    public HashBagMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.keysView().size() * 2, 16));
        this.putAll(multimap);
    }

    public HashBagMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new HashBagMultimap<K, V>(multimap);
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap() {
        return new HashBagMultimap<K, V>();
    }

    public static <K, V> HashBagMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new HashBagMultimap<K, V>(pairs);
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableBag<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    @Override
    protected MutableBag<V> createCollection() {
        return HashBag.newBag();
    }

    public HashBagMultimap<K, V> newEmpty() {
        return new HashBagMultimap<K, V>();
    }

    public MutableBagMultimap<K, V> toMutable() {
        return new HashBagMultimap<K, V>(this);
    }

    public ImmutableBagMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableBag<V>>(){

            public void value(K key, MutableBag<V> bag) {
                map.put(key, (Object)bag.toImmutable());
            }
        });
        return new ImmutableBagMultimapImpl(map);
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        int keysCount = this.map.size();
        out.writeInt(keysCount);
        this.map.forEachKeyValue((Procedure2)new CheckedProcedure2<K, MutableBag<V>>(){

            @Override
            public void safeValue(K key, MutableBag<V> bag) throws IOException {
                out.writeObject(key);
                out.writeInt(bag.sizeDistinct());
                bag.forEachWithOccurrences((ObjectIntProcedure)new CheckedObjectIntProcedure<V>(){

                    @Override
                    public void safeValue(V value, int count) throws IOException {
                        out.writeObject(value);
                        out.writeInt(count);
                    }
                });
            }
        });
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int keyCount = in.readInt();
        this.map = UnifiedMap.newMap(keyCount);
        for (int i = 0; i < keyCount; ++i) {
            Object key = in.readObject();
            int valuesSize = in.readInt();
            MutableBag bag = Bags.mutable.of();
            for (int j = 0; j < valuesSize; ++j) {
                Object value = in.readObject();
                int count = in.readInt();
                bag.addOccurrences(value, count);
            }
            this.putAll(key, bag);
        }
    }
}

