/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.file;

import de.intarsys.tools.attachment.Attachment;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileAttachmentTools {
    private static final Logger Log = LogTools.getLogger(FileTools.class);

    protected static String createAttachmentName(String string, String string2, String string3) {
        String string4 = StringTools.getCommonPrefix(string, string3, true);
        int n = string.length() - string4.length();
        int n2 = string3.length() - string4.length();
        String string5 = string2;
        string5 = string5.substring(0, string5.length() - n);
        string5 = String.valueOf(string5) + string3.substring(string3.length() - n2);
        return string5;
    }

    public static List createAttachments(File file, File[] fileArray, String string) {
        if (StringTools.isEmpty(string)) {
            return Collections.EMPTY_LIST;
        }
        String string2 = null;
        String string3 = null;
        if (file != null) {
            string2 = file.getName().toLowerCase();
            string3 = FileTools.getBaseName(string2);
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray = string.toLowerCase().split(";");
        int n = 0;
        while (n < fileArray.length) {
            File file2 = fileArray[n];
            String string4 = file2.getName().toLowerCase();
            if (!string4.equals(string2)) {
                String string5 = FileTools.getBaseName(string4);
                if (file == null || string5.equals(string2) || string5.equals(string3)) {
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (string4.endsWith(stringArray[n2])) {
                            arrayList.add(file2);
                            break;
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static List createAttachments(File file, String string) {
        File file2;
        File file3;
        if (file.isDirectory()) {
            file3 = file;
            file2 = null;
        } else {
            file3 = file.getParentFile();
            file2 = file;
        }
        if (file3 == null) {
            return null;
        }
        File[] fileArray = file3.listFiles();
        return FileAttachmentTools.createAttachments(file2, fileArray, string);
    }

    public static void deleteAttachments(List list) {
        for (Object object : list) {
            ILocator iLocator;
            if (object instanceof Attachment) {
                object = ((Attachment)object).getAttached();
            }
            if (object instanceof File) {
                if (!((File)object).exists() || ((File)object).delete()) continue;
                Log.log(Level.WARNING, "deleting '" + object + "' failed");
                continue;
            }
            if (object instanceof ILocator) {
                if (!((ILocator)object).exists()) continue;
                try {
                    ((ILocator)object).delete();
                }
                catch (IOException iOException) {
                    Log.log(Level.WARNING, "deleting '" + object + "' failed");
                }
                continue;
            }
            if (!(object instanceof ILocatorSupport) || !(iLocator = ((ILocatorSupport)object).getLocator()).exists()) continue;
            try {
                iLocator.delete();
            }
            catch (IOException iOException) {
                Log.log(Level.WARNING, "deleting '" + iLocator + "' failed");
            }
        }
    }

    public static File moveAttachment(File file, File file2, File file3, boolean bl) throws IOException {
        return FileAttachmentTools.moveAttachment(file, file2, file3, bl, false);
    }

    public static File moveAttachment(File file, File file2, File file3, boolean bl, boolean bl2) throws IOException {
        if (file == null || file3 == null || file2 == null) {
            return file2;
        }
        String string = file.getName();
        String string2 = file3.getName();
        File file4 = file3.isDirectory() ? file3 : file3.getParentFile();
        if (file4 == null) {
            return file2;
        }
        try {
            File file5 = FileAttachmentTools.moveAttachment(string, file2, string2, file4, bl, bl2);
            return file5;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("failed to move attachment '" + file2 + "' attached to '" + file + "' (" + exception.getMessage() + ")");
        }
    }

    protected static File moveAttachment(String string, Object object, String string2, File file, boolean bl, boolean bl2) throws IOException {
        Object object2;
        if (object instanceof Attachment) {
            object = ((Attachment)object).getAttached();
        }
        if (object instanceof ILocatorSupport) {
            object = ((ILocatorSupport)object).getLocator();
        }
        if (object instanceof FileLocator) {
            object = ((FileLocator)object).getFile();
        }
        if (object instanceof File) {
            object2 = (File)object;
            if (((File)object2).exists()) {
                long l = 0L;
                if (bl2) {
                    l = ((File)object2).lastModified();
                }
                String string3 = ((File)object2).getName();
                String string4 = FileAttachmentTools.createAttachmentName(string, string2, string3);
                File file2 = new File(file, string4);
                if (bl) {
                    if (Log.isLoggable(Level.FINE)) {
                        Log.log(Level.FINE, "move '" + ((File)object2).getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'");
                    }
                    FileTools.renameFile((File)object2, file2);
                } else {
                    if (Log.isLoggable(Level.FINE)) {
                        Log.log(Level.FINE, "copy '" + ((File)object2).getAbsolutePath() + "' to '" + file2.getAbsolutePath() + "'");
                    }
                    FileTools.copyFile((File)object2, file2);
                }
                if (l != 0L) {
                    file2.setLastModified(l);
                }
                return file2;
            }
            Log.log(Level.FINE, "attachment '" + ((File)object2).getAbsolutePath() + "' no longer available");
        }
        if (object instanceof ILocator) {
            object2 = (ILocator)object;
            if (object2.exists()) {
                String string5 = object2.getTypedName();
                String string6 = FileAttachmentTools.createAttachmentName(string, string2, string5);
                File file3 = new File(file, string6);
                if (Log.isLoggable(Level.FINE)) {
                    Log.log(Level.FINE, "create file '" + file3.getAbsolutePath() + "'");
                }
                InputStream inputStream = null;
                FileOutputStream fileOutputStream = null;
                try {
                    inputStream = object2.getInputStream();
                    fileOutputStream = new FileOutputStream(file3);
                    StreamTools.copyStream(inputStream, fileOutputStream);
                }
                catch (Throwable throwable) {
                    StreamTools.close(inputStream);
                    StreamTools.close(fileOutputStream);
                    throw throwable;
                }
                StreamTools.close(inputStream);
                StreamTools.close(fileOutputStream);
                if (bl) {
                    if (Log.isLoggable(Level.FINE)) {
                        Log.log(Level.FINE, "delete locator '" + object2.getFullName() + "'");
                    }
                    object2.delete();
                }
                return file3;
            }
            Log.log(Level.FINE, "attachment '" + object2.getFullName() + "' no longer available");
        }
        return null;
    }

    public static List moveAttachments(File file, List list, File file2, boolean bl) throws IOException {
        return FileAttachmentTools.moveAttachments(file, list, file2, bl, false);
    }

    public static List moveAttachments(File file, List list, File file2, boolean bl, boolean bl2) throws IOException {
        if (file == null || file2 == null || list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = file.getName();
        String string2 = file2.getName();
        File file3 = file2.isDirectory() ? file2 : file2.getParentFile();
        if (file3 == null) {
            return list;
        }
        for (Object e : list) {
            try {
                File file4 = FileAttachmentTools.moveAttachment(string, e, string2, file3, bl, bl2);
                if (file4 == null) continue;
                arrayList.add(file4);
            }
            catch (Exception exception) {
                throw new IOException("failed to move attachment '" + e + "' attached to '" + file + "' (" + exception.getMessage() + ")");
            }
        }
        return arrayList;
    }
}

