/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.panels;

import java.awt.Dimension;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.business.actions.LoadEnvironmentAction;
import org.pdfsam.guiclient.business.actions.SaveEnvironmentAction;
import org.pdfsam.guiclient.business.listeners.LogActionListener;
import org.pdfsam.guiclient.business.listeners.mediators.ApplicationExitMediator;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class JButtonsPanel
extends JPanel {
    private static final long serialVersionUID = 203934401531647182L;
    private static final Logger log = Logger.getLogger(JButtonsPanel.class.getPackage().getName());
    private JToolBar toolBar;
    private JButton buttonSaveEnv;
    private JButton buttonLoadEnv;
    private JButton buttonSaveLog;
    private JButton buttonClearLog;
    private JButton buttonExit;
    private LogActionListener logActionListener;
    private ApplicationExitMediator exitMediator;

    public JButtonsPanel(SaveEnvironmentAction saveAction, LoadEnvironmentAction loadAction, ApplicationExitMediator exitMediator, LogActionListener logActionListener) {
        this.logActionListener = logActionListener;
        this.exitMediator = exitMediator;
        this.init(saveAction, loadAction);
    }

    private void init(SaveEnvironmentAction saveAction, LoadEnvironmentAction loadAction) {
        try {
            this.setLayout(new BoxLayout(this, 0));
            this.setPreferredSize(new Dimension(600, 30));
            this.toolBar = new JToolBar("Toolbar", 0);
            this.toolBar.setFloatable(true);
            this.toolBar.setRollover(true);
            this.toolBar.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
            this.buttonSaveEnv = new JButton();
            this.buttonSaveEnv.setAction(saveAction);
            this.buttonSaveEnv.setText("");
            this.buttonLoadEnv = new JButton();
            this.buttonLoadEnv.setAction(loadAction);
            this.buttonLoadEnv.setText("");
            this.buttonSaveLog = new JButton(new ImageIcon(this.getClass().getResource("/images/edit-save.png")));
            this.buttonSaveLog.setActionCommand("savelog");
            this.buttonSaveLog.setToolTipText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Save log"));
            this.buttonSaveLog.addActionListener(this.logActionListener);
            this.buttonClearLog = new JButton(new ImageIcon(this.getClass().getResource("/images/edit-clear.png")));
            this.buttonClearLog.setActionCommand("clearlog");
            this.buttonClearLog.setToolTipText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Clear log"));
            this.buttonClearLog.addActionListener(this.logActionListener);
            this.buttonExit = new JButton(new ImageIcon(this.getClass().getResource("/images/exit.png")));
            this.buttonExit.setActionCommand("saveAndExit");
            this.buttonExit.setToolTipText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Exit"));
            this.buttonExit.addActionListener(this.exitMediator);
            this.toolBar.add(this.buttonSaveEnv);
            this.toolBar.add(this.buttonLoadEnv);
            this.toolBar.addSeparator();
            this.toolBar.add(this.buttonSaveLog);
            this.toolBar.add(this.buttonClearLog);
            this.toolBar.addSeparator();
            this.toolBar.add(this.buttonExit);
            this.add(this.toolBar);
        }
        catch (Exception e) {
            log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to initialize button bar."), e);
        }
    }
}

