/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.utils;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class DialogUtility {
    public static final int AT_LEAST_ONE_DOC = 0;
    public static final int ONE_DOC = 1;
    public static final int TWO_DOC = 2;
    public static final int FILE_DESTINATION = 0;
    public static final int DIRECTORY_DESTINATION = 1;

    public static int showConfirmOuputLocationDialog(Component comp, String suggestedDir) {
        return JOptionPane.showOptionDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Output file location is not correct") + ".\n" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Would you like to change it to") + " " + suggestedDir + " ?", GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Output location error"), 1, 3, null, null, null);
    }

    public static void showWarningNoDocsSelected(Component comp, int msgType) {
        String msg = GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select at least one pdf document.");
        if (2 == msgType) {
            msg = GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select two pdf documents.");
        } else if (1 == msgType) {
            msg = GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a pdf document.");
        }
        JOptionPane.showMessageDialog(comp, msg, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Warning"), 2);
    }

    public static void showWarningAddingDocument(Component comp) {
        JOptionPane.showMessageDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please wait while all files are processed."), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Still adding files"), 2);
    }

    public static void showWarningNoDestinationSelected(Component comp, int msgType) {
        String msg = 0 == msgType ? GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a destination file.") : GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a destination directory.");
        JOptionPane.showMessageDialog(comp, msg, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"No destination selected"), 2);
    }

    public static int askForOverwriteOutputFileDialog(Component comp, String filename) {
        return JOptionPane.showOptionDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Selected output file already exists ") + filename + "\n" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Would you like to overwrite it?"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Output location error"), 1, 3, null, null, null);
    }

    public static int askForOverwriteConfirmation(Component comp) {
        return JOptionPane.showOptionDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please note that output files will overwrite existing files of the same name without warning.") + "\n" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Do you confirm to overwrite?"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Confirm overwrite"), 1, 3, null, null, null);
    }

    public static void errorValidatingBounds(Component comp, String bounds) {
        JOptionPane.showMessageDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Provided pages selection is not valid") + " (" + bounds + ")\n" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Limits must be a comma separated list of \"page_number\" or \"page_number-page_number\""), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Limits are not valid"), 0);
    }

    public static void errorGenericDialog(Component comp, String title, String message) {
        JOptionPane.showMessageDialog(comp, message, title, 0);
    }

    public static String askForDocumentPasswordDialog(Component comp, String filename) {
        String retVal = null;
        JPasswordField passwordField = new JPasswordField();
        Object[] message = new Object[]{GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please provide the password to open the encrypted document"), filename, passwordField};
        passwordField.requestFocus();
        if (JOptionPane.showOptionDialog(comp, message, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Password request"), 2, 3, null, null, null) == 0) {
            retVal = String.valueOf(passwordField.getPassword());
        }
        return retVal;
    }

    public static int askForEmptySelectionPanel(Component comp) {
        return JOptionPane.showConfirmDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Selection list is full, would you like to empty it and load the new document?"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"List full"), 0, 3);
    }

    public static int askForPdfVersionConfilct(Component comp, String lowestVersion) {
        return JOptionPane.showConfirmDialog(comp, GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"The lowest available pdf version is ") + lowestVersion + ".\n" + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"You selected a lower output pdf version, continue anyway ?"), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Pdf version conflict"), 0, 2);
    }
}

