/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XRefFallbackParser
extends AbstractXRefParser {
    private STTrailerXRefSection xRefSection;
    private List trailers = new ArrayList();

    public XRefFallbackParser(STDocument sTDocument, COSDocumentParser cOSDocumentParser) {
        super(sTDocument, cOSDocumentParser);
        this.xRefSection = new STTrailerXRefSection(sTDocument);
    }

    private void checkXRefSections() throws IOException, COSLoadException {
        if (this.trailers.isEmpty()) {
            COSLoadError cOSLoadError = new COSLoadError("no trailer found");
            this.handleError(cOSLoadError);
        }
        boolean bl = false;
        int n = this.trailers.size() - 1;
        while (n >= 0) {
            COSDictionary cOSDictionary = (COSDictionary)this.trailers.get(n);
            if (cOSDictionary.containsKey(COSTrailer.DK_Root)) {
                this.getXRefSection().cosSetDict(cOSDictionary);
                bl = true;
                break;
            }
            --n;
        }
        if (!bl) {
            COSLoadError cOSLoadError = new COSLoadError("trailer doesn't contain a root entry");
            this.handleError(cOSLoadError);
        }
        this.getXRefSection().setSize(this.getXRefSection().getMaxObjectNumber());
    }

    protected STTrailerXRefSection getXRefSection() {
        return this.xRefSection;
    }

    @Override
    public STXRefSection parse(IRandomAccess iRandomAccess) throws IOException, COSLoadException {
        iRandomAccess.seek(0L);
        while (this.readUptoNewLine(iRandomAccess)) {
            long l = iRandomAccess.getOffset();
            try {
                COSDictionary cOSDictionary = this.getParser().parseTrailer(iRandomAccess);
                this.trailers.add(cOSDictionary);
                continue;
            }
            catch (IOException iOException) {
            }
            catch (COSLoadException cOSLoadException) {
                // empty catch block
            }
            try {
                int n = this.getParser().readInteger(iRandomAccess, true);
                if (n != 0) {
                    int n2 = this.getParser().readInteger(iRandomAccess, true);
                    byte[] byArray = this.getParser().readToken(iRandomAccess);
                    if (Arrays.equals(PDFParser.TOKEN_obj, byArray)) {
                        this.getXRefSection().addEntry(new STXRefEntryOccupied(n, n2, (int)l));
                        continue;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            iRandomAccess.seek(l);
        }
        this.checkXRefSections();
        return this.getXRefSection();
    }

    private boolean readUptoNewLine(IRandomAccess iRandomAccess) throws IOException {
        int n;
        do {
            if ((n = iRandomAccess.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(n));
        if (n == PDFParser.CHAR_CR) {
            n = iRandomAccess.read();
            if (n == -1) {
                return false;
            }
            if (n != PDFParser.CHAR_LF) {
                iRandomAccess.seekBy(-1L);
            }
        }
        return true;
    }
}

