/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.io.IOException;
import java.io.InputStream;

public class PlatformImageTools {
    public static boolean matchColorSpace(PDImage pDImage, String string) {
        PDColorSpace pDColorSpace = pDImage.getColorSpace();
        if ("GRAY".equals(string) && (pDColorSpace == PDCSDeviceGray.SINGLETON || pDColorSpace instanceof PDCSIndexed || pDColorSpace instanceof PDCSICCBased && AwtColorSpaceFactory.get().createColorSpace(pDColorSpace).getNumComponents() == 1)) {
            return true;
        }
        return ("RGB".equals(string) || "YCbCr".equals(string)) && (pDImage.getColorSpace() == PDCSDeviceRGB.SINGLETON || pDColorSpace instanceof PDCSICCBased && AwtColorSpaceFactory.get().createColorSpace(pDColorSpace).getNumComponents() == 3);
    }

    public static boolean matchColorSpaceType(PDImage pDImage, InputStream inputStream) throws IOException {
        String string;
        if (pDImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            return true;
        }
        try {
            string = ImageTools.extractJPEGColorSpaceType((InputStream)inputStream);
        }
        catch (ImageException imageException) {
            string = "YCbCr";
        }
        return PlatformImageTools.matchColorSpace(pDImage, string);
    }
}

