/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Classifier;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Datatype;
import com.ibm.xmi.framework.DeclarationFactory;
import com.ibm.xmi.framework.DeclarationWriterWrapper;
import com.ibm.xmi.framework.Feature;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.Value;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class UML2Java {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    FileOutputStream fs;
    FileOutputStream reportfos;
    OutputStreamWriter os;
    OutputStreamWriter reportosw;
    String modelName;
    String directory;
    String topPackage;
    String currentPackage;
    String report;
    Vector duplicateFeatureNames = new Vector();
    Vector namespaces = new Vector();
    Hashtable defsToNames = new Hashtable();
    Hashtable defsToChangedNames = new Hashtable();
    Hashtable duplicateNamesToClasses = new Hashtable();
    Hashtable namespacesToNames = new Hashtable();
    boolean interfaces = false;
    boolean ignorePackages = false;
    boolean oneConstructor = false;
    private Vector classes;
    private String mySuperClass = "XMIObjectImpl";
    private DeclarationWriterWrapper wrapper = new DeclarationWriterWrapper(AdapterFactoryRegister.getAdapterFactory().createDeclarationWriterAdapter());

    private String abbreviation(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            if (Character.isUpperCase(string.charAt(n)) && string2.length() < 2) {
                string2 = string2 + string.charAt(n);
            }
            ++n;
        }
        if (string2.length() == 2) {
            return string2;
        }
        string2 = string.length() < 2 ? string.toUpperCase() : string.substring(0, 2).toUpperCase();
        return string2;
    }

    private void addToDuplicates(String string, XMIClass xMIClass) {
        ArrayList arrayList = this.wrapper.getAllSuperclasses(xMIClass);
        arrayList.add(xMIClass);
        ArrayList arrayList2 = new ArrayList();
        if (this.duplicateNamesToClasses.get(string) == null) {
            this.duplicateNamesToClasses.put(string, arrayList2);
        } else {
            arrayList2 = (ArrayList)this.duplicateNamesToClasses.get(string);
        }
        int n = 0;
        while (n < arrayList.size()) {
            if (!arrayList2.contains(arrayList.get(n))) {
                arrayList2.add(arrayList.get(n));
            }
            ++n;
        }
    }

    private String capName(String string) {
        return string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private boolean changeName(Data data) {
        String string = this.shortName(data);
        XMIClass xMIClass = null;
        int n = this.wrapper.getType(data);
        if (data instanceof Feature) {
            xMIClass = (XMIClass)((Feature)data).getXMIOwner();
        }
        if (this.duplicateNamesToClasses.get(string) == null) {
            return true;
        }
        Vector vector = (Vector)this.duplicateNamesToClasses.get(string);
        return vector.contains(xMIClass);
    }

    private void computeClassNames(Vector vector) {
        Vector vector2 = (Vector)this.classes.clone();
        this.getPackages(vector, vector2);
        int n = 0;
        while (n < vector2.size()) {
            Data data = (Data)vector2.elementAt(n);
            String string = data.getXMIName();
            string = string.replace('.', '_');
            string = string.replace(':', '_');
            this.defsToNames.put(data, string);
            ++n;
        }
    }

    private void computeFeatureConflicts() {
        int n = 0;
        while (n < this.classes.size()) {
            String string;
            XMIClass xMIClass = (XMIClass)this.classes.elementAt(n);
            Collection collection = this.wrapper.getAllFeatures(xMIClass);
            Iterator iterator = this.wrapper.getProperties(collection).iterator();
            Iterator iterator2 = this.wrapper.getLinks(collection).iterator();
            Vector<String> vector = new Vector<String>();
            while (iterator.hasNext()) {
                string = this.stripNamespace(this.shortName((Data)iterator.next()));
                if (vector.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector.addElement(string);
            }
            while (iterator2.hasNext()) {
                string = this.stripNamespace(this.shortName((Data)iterator2.next()));
                if (vector.contains(string)) {
                    this.addToDuplicates(string, xMIClass);
                }
                if (vector.contains(string) && !this.duplicateFeatureNames.contains(string)) {
                    this.duplicateFeatureNames.addElement(string);
                    continue;
                }
                vector.addElement(string);
            }
            ++n;
        }
    }

    private boolean containsIgnoreCase(Vector vector, String string) {
        int n = 0;
        while (n < vector.size()) {
            if (((String)vector.elementAt(n)).equalsIgnoreCase(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String duplicateName(Data data) {
        if (!this.changeName(data)) {
            return this.shortName(data);
        }
        String string = this.getFullName(data);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return string;
        }
        int n2 = string.lastIndexOf(".", n - 1);
        String string2 = string.substring(n2 + 1, n);
        string2 = this.abbreviation(string2);
        string2 = string2 + this.capName(this.stripNamespace(this.shortName(data)));
        if (this.report != null && this.defsToChangedNames.get(data) == null) {
            this.reportOut(string + " renamed to " + string2);
            this.defsToChangedNames.put(data, data);
        }
        return string2;
    }

    private void endFile() {
        try {
            this.os.close();
            this.fs.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void getClasses(Package package_) {
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            Namespace namespace;
            Object e = iterator.next();
            if (e instanceof XMIClass) {
                namespace = ((Data)e).getXMINamespace();
                if (namespace != null && !this.namespaces.contains(namespace)) {
                    this.namespaces.addElement(namespace);
                    this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
                }
                this.classes.addElement(e);
                continue;
            }
            if (!(e instanceof Package)) continue;
            namespace = ((Data)e).getXMINamespace();
            if (namespace != null && !this.namespaces.contains(namespace)) {
                this.namespaces.addElement(namespace);
                this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
            }
            this.getClasses((Package)e);
        }
    }

    private void getClasses(Vector vector) {
        this.classes = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Namespace namespace;
            if (vector.elementAt(n) instanceof XMIClass) {
                namespace = ((Data)vector.elementAt(n)).getXMINamespace();
                if (namespace != null && !this.namespaces.contains(namespace)) {
                    this.namespaces.addElement(namespace);
                    this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
                }
                this.classes.addElement(vector.elementAt(n));
            } else if (vector.elementAt(n) instanceof Package) {
                namespace = ((Data)vector.elementAt(n)).getXMINamespace();
                if (namespace != null && !this.namespaces.contains(namespace)) {
                    this.namespaces.addElement(namespace);
                    this.namespacesToNames.put(namespace, "ixafn" + this.namespaces.size());
                }
                this.getClasses((Package)vector.elementAt(n));
            }
            ++n;
        }
    }

    private void getPackages(Package package_, Vector vector) {
        if (!vector.contains(package_)) {
            vector.addElement(package_);
        }
        Iterator iterator = package_.getXMIContents().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Package)) continue;
            this.getPackages((Package)e, vector);
        }
    }

    private void getPackages(Vector vector, Vector vector2) {
        int n = 0;
        while (n < vector.size()) {
            if (vector.elementAt(n) instanceof Package) {
                this.getPackages((Package)vector.elementAt(n), vector2);
            }
            ++n;
        }
    }

    private String getFullName(Data data) {
        if (data.getXMIOwner() == null) {
            return this.stripNamespace(data.getXMIName());
        }
        String string = this.stripNamespace(data.getXMIName());
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return this.getFullName(data.getXMIOwner()) + "." + string;
    }

    private String getJavaType(String string) {
        if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
            return "int";
        }
        if (string.equalsIgnoreCase("boolean")) {
            return "boolean";
        }
        if (string.equalsIgnoreCase("float")) {
            return "float";
        }
        return "String";
    }

    private String getName(Data data, int n) {
        String string = this.getFullName(data);
        int n2 = string.lastIndexOf(".");
        int n3 = n;
        while (n3 > 0 && n2 > 0) {
            n2 = string.lastIndexOf(".", n2 - 1);
            --n3;
        }
        if (n2 > 0) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private String getUMLAttributeType(Data data) {
        String string;
        Value value;
        if (data instanceof Feature && data.getXMISource() == null) {
            String string2;
            Feature feature = (Feature)data;
            Classifier classifier = feature.getXMIType();
            if (classifier instanceof Datatype && (string2 = this.wrapper.getXMIName(classifier)) != null) {
                int n = string2.indexOf(":");
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                if (string2.equalsIgnoreCase("boolean")) {
                    return "boolean";
                }
                return string2;
            }
            return "String";
        }
        if (data.getXMISource() == null || this.wrapper.getType(data) == 6) {
            String string3;
            Object object;
            String string4 = "String";
            if (this.wrapper.getType(data) == 6 && (object = this.wrapper.getFeatureType(data)) != null && (string3 = this.wrapper.getXMIName(object)) != null) {
                int n = string3.indexOf(":");
                if (n != -1) {
                    string3 = string3.substring(n + 1);
                }
                if (string3.equalsIgnoreCase("boolean")) {
                    string4 = "boolean";
                }
            }
            return string4;
        }
        XMIObject xMIObject = (XMIObject)data.getXMISource();
        Value value2 = xMIObject.getXMIValue("Foundation.Core.StructuralFeature.type");
        Data data2 = null;
        if (value2 != null) {
            data2 = (XMIObject)value2.getXMIValue();
        }
        if (data2 != null && (data2.getXMIName().equals("Foundation.Data_Types.Primitive") || this.isDatatype((XMIObject)data2)) && (value = data2.getXMIValue("Foundation.Core.ModelElement.name")) != null && (string = (String)value.getXMIValue()) != null) {
            if (string.equalsIgnoreCase("int") || string.equalsIgnoreCase("integer")) {
                return "int";
            }
            if (string.equalsIgnoreCase("float")) {
                return "float";
            }
        }
        return "String";
    }

    private boolean isDatatype(XMIObject xMIObject) {
        if (xMIObject.getXMIName().equals("Foundation.Core.Data_Type")) {
            return true;
        }
        Iterator iterator = this.wrapper.getProperties(xMIObject.getXMIValues()).iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject2;
            Value value;
            Data data = (Data)iterator.next();
            if (!data.getXMIName().equals("Foundation.Core.ModelElement.stereotype") || (value = (xMIObject2 = (XMIObject)((Value)data).getXMIValue()).getXMIValue("Foundation.Core.ModelElement.name")) == null || !value.getXMIValue().equals("datatype")) continue;
            return true;
        }
        return false;
    }

    private boolean isJavaType(Data data) {
        String string = this.getJavaType(this.getUMLAttributeType(data));
        return string.equals("int") || string.equals("float") || string.equals("boolean");
    }

    private String linkType(Data data) {
        if (this.wrapper.getType(data) == 3) {
            return "ContainerLink";
        }
        if (this.wrapper.getType(data) == 2) {
            return "RefLink";
        }
        return "ContainLink";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0 || stringArray[0].equals("?")) {
            System.out.println("Generate Java classes from a UML model.  The arguments are:");
            System.out.println("-model Name of UML XMI file. (required)");
            System.out.println("-dir Directory to put code (optional)");
            System.out.println("-package Top-level Java package for code (optional)");
            System.out.println("-report File that contains renamed properties and links (optional)");
            System.out.println("-namespaceName The name of the namespace for the model (optional)");
            System.out.println("-namespaceURI URI of the namespace for the model (optional)");
            System.out.println("-namespacefile XML file containing namespaces for the model (optional)");
            System.out.println("-interfaces If present, generate an interface and impl for each class in model (optinal)");
            System.out.println("-ignorePackages If present, puts all classes in one Java package, renaming if needed (optional)");
            System.out.println("-oneConstructor If present, generates one constructor with no parameters (optional)");
            System.out.println("-superClass If present, the generated implementation classes inherit from this class rather than XMIObjectImpl (optional)");
            System.out.println("-filepath File path for loading a model in multiple files (optional)");
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        UML2Java uML2Java = new UML2Java();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-model") && n + 1 < stringArray.length) {
                string = stringArray[++n];
            } else if (stringArray[n].equals("-dir") && n + 1 < stringArray.length) {
                string2 = stringArray[++n];
            } else if (stringArray[n].equals("-package") && n + 1 < stringArray.length) {
                string3 = stringArray[++n];
            } else if (stringArray[n].equals("-report") && n + 1 < stringArray.length) {
                string4 = stringArray[++n];
            } else if (stringArray[n].equals("-namespaceName") && n + 1 < stringArray.length) {
                string5 = stringArray[++n];
            } else if (stringArray[n].equals("-namespaceURI") && n + 1 < stringArray.length) {
                string6 = stringArray[++n];
            } else if (stringArray[n].equals("-namespacefile") && n + 1 < stringArray.length) {
                string8 = stringArray[++n];
            } else if (stringArray[n].equals("-superClass") && n + 1 < stringArray.length) {
                uML2Java.setSuperClass(stringArray[++n]);
            } else if (stringArray[n].equals("-filepath") && n + 1 < stringArray.length) {
                string7 = stringArray[++n];
            } else if (stringArray[n].equals("-interfaces")) {
                uML2Java.setInterfaces(true);
            } else if (stringArray[n].equals("-ignorePackages")) {
                uML2Java.setIgnorePackages(true);
            } else if (stringArray[n].equals("-oneConstructor")) {
                uML2Java.setOneConstructor(true);
            }
            ++n;
        }
        if (string == null) {
            System.out.println("Must specify a model file with -model option.");
            return;
        }
        if (string2 == null) {
            string2 = System.getProperty("user.dir");
        }
        try {
            int n2;
            XMIFiles xMIFiles = new XMIFiles();
            if (string7 != null) {
                xMIFiles.setFilepath(string7);
            }
            XMIFile xMIFile = xMIFiles.load(string, 1, false);
            xMIFiles.loadAll();
            DeclarationFactory declarationFactory = null;
            declarationFactory = string8 != null ? new DeclarationFactory(string8) : (string5 != null ? new DeclarationFactory(string5, string6) : new DeclarationFactory());
            Iterator iterator = declarationFactory.makeDeclarations(xMIFiles.getContainer()).iterator();
            Vector vector = new Vector();
            while (iterator.hasNext()) {
                vector.addElement(iterator.next());
            }
            int n3 = string.lastIndexOf(File.separatorChar);
            if (n3 > 0) {
                string = string.substring(n3 + 1);
            }
            if ((n2 = string.indexOf(46)) > 0) {
                uML2Java.setModelName(string.substring(0, n2));
            } else {
                uML2Java.setModelName(stringArray[0]);
            }
            uML2Java.setReport(string4);
            uML2Java.makeJava(string2, string3, vector);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeFactory(Vector vector) {
        if (this.topPackage == null) {
            this.setFile("UserFactory");
        } else {
            this.setFile(this.topPackage + ".UserFactory");
        }
        if (this.topPackage != null) {
            this.out("package " + this.topPackage + ";\n");
        }
        this.out("import com.ibm.xmi.framework.*;");
        this.out("import com.ibm.xmi.framework.Package;");
        this.out("import java.util.*;\n");
        this.out("public class UserFactory extends FactoryAdapter {");
        this.out("\tstatic private Model ixafm;\n");
        this.out("\tstatic private HashMap ixafntc, ixafntcn;\n");
        this.out("\tpublic UserFactory() {");
        this.out("\t\tFactoryRegister.registerFactory(this);");
        this.out("\t}\n");
        this.makeFactoryMethod(vector);
        this.makeFactoryDefs(vector);
        this.out("} // UserFactory");
        this.endFile();
    }

    private void makeFactoryDefs(Vector vector) {
        Object object;
        Iterator iterator;
        XMIClass xMIClass;
        Object object2;
        Object object3;
        Object object4;
        Enumeration enumeration;
        Object object5;
        this.out("\tpublic Model getModel() {");
        this.out("\t\tif (ixafm != null)");
        this.out("\t\t\treturn ixafm;\n");
        this.out("\t\tixafm = new Model(\"" + this.modelName + "\");\n");
        this.out("\t\ttry {");
        int n = 0;
        while (n < this.namespaces.size()) {
            object5 = (Namespace)this.namespaces.elementAt(n);
            if (((Namespace)object5).getURI() != null) {
                this.out("\t\t\tcom.ibm.xmi.framework.Namespace ixafn" + (n + 1) + " = new com.ibm.xmi.framework.Namespace(\"" + ((Namespace)object5).getPrefix() + "\", \"" + ((Namespace)object5).getURI() + "\");");
            } else {
                this.out("\t\t\tcom.ibm.xmi.framework.Namespace ixafn" + (n + 1) + " = new com.ibm.xmi.framework.Namespace(\"" + ((Namespace)object5).getPrefix() + "\", null);");
            }
            ++n;
        }
        object5 = new Vector();
        this.getPackages(vector, (Vector)object5);
        int n2 = 0;
        while (n2 < ((Vector)object5).size()) {
            enumeration = (Data)((Vector)object5).elementAt(n2);
            object4 = (String)this.defsToNames.get(enumeration);
            if (enumeration.getXMIOwner() != null) {
                this.out("\t\t\tPackage " + (String)object4 + " = makePackage(" + this.defsToNames.get(enumeration.getXMIOwner()) + ", \"" + this.stripNamespace(enumeration.getXMIName()) + "\");");
            } else {
                this.out("\t\t\tPackage " + (String)object4 + " = makePackage(null, \"" + this.stripNamespace(enumeration.getXMIName()) + "\");");
            }
            if (enumeration.getXMINamespace() != null) {
                this.out("\t\t\t" + (String)object4 + ".setXMINamespace(" + this.namespacesToNames.get(enumeration.getXMINamespace()) + ");");
            }
            ++n2;
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (Data)enumeration.nextElement();
            if (!(object4 instanceof XMIClass)) continue;
            object3 = (String)this.defsToNames.get(object4);
            if (object4.getXMIOwner() != null) {
                this.out("\t\t\tXMIClass " + (String)object3 + " = makeXMIClass(" + this.defsToNames.get(object4.getXMIOwner()) + ", \"" + this.stripNamespace(object4.getXMIName()) + "\");");
            } else {
                this.out("\t\t\tXMIClass " + (String)object3 + " = makeXMIClass(null, \"" + this.stripNamespace(object4.getXMIName()) + "\");");
            }
            if (object4.getXMINamespace() == null) continue;
            this.out("\t\t\t" + (String)object3 + ".setXMINamespace(" + this.namespacesToNames.get(object4.getXMINamespace()) + ");");
        }
        this.out("");
        boolean bl = false;
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object3 = (Data)enumeration.nextElement();
            if (!(object3 instanceof XMIClass)) continue;
            object2 = (String)this.defsToNames.get(object3);
            xMIClass = (XMIClass)object3;
            iterator = this.wrapper.getSuperclasses(xMIClass).iterator();
            while (iterator.hasNext()) {
                bl = true;
                object = (XMIClass)iterator.next();
                this.out("\t\t\t" + (String)object2 + ".addSuperclass(" + this.defsToNames.get(object) + ");");
            }
            iterator = this.wrapper.getSubclasses(xMIClass).iterator();
            while (iterator.hasNext()) {
                bl = true;
                object = (XMIClass)iterator.next();
                this.out("\t\t\t" + (String)object2 + ".addSubclass(" + this.defsToNames.get(object) + ");");
            }
        }
        if (bl) {
            this.out("");
            bl = false;
        }
        enumeration = this.classes.elements();
        if (this.namespaces.size() > 0) {
            this.out("\t\t\tcom.ibm.xmi.framework.Feature ixaff;");
        }
        while (enumeration.hasMoreElements()) {
            Object object6;
            Object object7;
            object3 = (Data)enumeration.nextElement();
            if (!(object3 instanceof XMIClass)) continue;
            object2 = (String)this.defsToNames.get(object3);
            xMIClass = (XMIClass)object3;
            iterator = this.wrapper.getProperties(this.wrapper.getFeatures(xMIClass)).iterator();
            while (iterator.hasNext()) {
                object = (Data)iterator.next();
                object7 = object.getXMINamespace();
                if (this.wrapper.getType(object) == 8) {
                    bl = true;
                    if (!(object instanceof Feature)) {
                        if (object7 == null) {
                            this.out("\t\t\tmake" + this.propType((Data)object) + "(" + (String)object2 + ", \"" + object.getXMIName() + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object)) + ");");
                            continue;
                        }
                        this.out("\t\t\tixafp = make" + this.propType((Data)object) + "(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object)) + ");");
                        this.out("\t\t\tixafp.setXMINamespace(" + this.namespacesToNames.get(object7) + ");");
                        continue;
                    }
                    if (object7 == null) {
                        this.out("\t\t\tmakeFeature(" + (String)object2 + ", \"" + object.getXMIName() + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object)) + ", Value.OBJECT, null);");
                        continue;
                    }
                    this.out("\t\t\tixaff = makeFeature(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object)) + ", Value.OBJECT, null);");
                    this.out("\t\t\tixaff.setXMINamespace(" + this.namespacesToNames.get(object7) + ");");
                    continue;
                }
                bl = true;
                if (!(object instanceof Feature)) {
                    if (object7 == null) {
                        this.out("\t\t\tmake" + this.propType((Data)object) + "(" + (String)object2 + ", \"" + object.getXMIName() + "\");");
                        continue;
                    }
                    this.out("\t\t\tixafp = make" + this.propType((Data)object) + "(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\");");
                    this.out("\t\t\tixafp.setXMINamespace(" + this.namespacesToNames.get(object7) + ");");
                    continue;
                }
                object6 = "";
                if (this.wrapper.getType(object) == 7) {
                    object6 = "Value.DATA";
                } else if (this.wrapper.getType(object) == 6) {
                    object6 = "Value.ENUM";
                }
                if (object7 == null) {
                    this.out("\t\t\tmakeFeature(" + (String)object2 + ", \"" + object.getXMIName() + "\", null, " + (String)object6 + ", null);");
                    continue;
                }
                this.out("\t\t\tixaff = makeFeature(" + (String)object2 + ", \"" + this.stripNamespace(object.getXMIName()) + "\", null, " + (String)object6 + ", null);");
                this.out("\t\t\tixaff.setXMINamespace(" + this.namespacesToNames.get(object7) + ");");
            }
            object = this.wrapper.getLinks(this.wrapper.getFeatures(xMIClass)).iterator();
            while (object.hasNext()) {
                bl = true;
                object7 = (Data)object.next();
                object6 = object7.getXMINamespace();
                if (!(object7 instanceof Feature)) continue;
                int n3 = this.wrapper.getType(object7);
                String string = "";
                if (n3 == 2) {
                    string = "Value.REFERENCE";
                } else if (n3 == 3) {
                    string = "Value.CONTAINER";
                } else if (n3 == 4) {
                    string = "Value.CONTAINED";
                }
                if (object6 == null) {
                    this.out("\t\t\tmakeFeature(" + (String)object2 + ", \"" + object7.getXMIName() + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object7)) + ", " + string + ", null);");
                    continue;
                }
                this.out("\t\t\tixaff = makeFeature(" + (String)object2 + ", \"" + this.stripNamespace(object7.getXMIName()) + "\", " + this.defsToNames.get(this.wrapper.getFeatureType(object7)) + ", " + string + ", null);");
                this.out("\t\t\tixaff.setXMINamespace(" + this.namespacesToNames.get(object6) + ");");
            }
            if (!bl) continue;
            this.out("");
            bl = false;
        }
        object3 = new Vector();
        enumeration = ((Vector)object5).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (object2.getXMIOwner() != null) continue;
            ((Vector)object3).addElement(object2);
        }
        enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (object2.getXMIOwner() != null) continue;
            ((Vector)object3).addElement(object2);
        }
        enumeration = ((Vector)object3).elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Data)enumeration.nextElement();
            if (!(object2 instanceof XMIClass) && !(object2 instanceof Package)) continue;
            this.out("\t\t\tixafm.add(" + this.defsToNames.get(object2) + ");");
        }
        this.out("");
        this.out("\t\t} catch(XMIException e) {");
        this.out("\t\t\te.printStackTrace();");
        this.out("\t\t}");
        this.out("\t\treturn ixafm;");
        this.out("\t}\n");
    }

    private void makeFactoryMethod(Vector vector) {
        this.out("\tprivate void init() {");
        this.out("\t\tixafntcn = new HashMap();");
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            Data data = (Data)enumeration.nextElement();
            if (!(data instanceof XMIClass)) continue;
            String string = data.getXMIName();
            String string2 = this.getFullName(data);
            String string3 = "";
            string3 = this.ignorePackages ? (String)this.defsToNames.get(data) : this.getFullName(data);
            if (this.topPackage != null) {
                string3 = this.topPackage + "." + string3;
            }
            if (this.interfaces) {
                string3 = string3 + "Impl";
            }
            this.out("\t\tixafntcn.put(\"" + string + "\", \"" + string3 + "\");");
            this.out("\t\tixafntcn.put(\"" + string2 + "\", \"" + string3 + "\");");
        }
        this.out("\t}\n");
        this.out("\tpublic XMIObject makeXMIObject(String xmiName) {");
        this.out("\t\tif (ixafntc == null)");
        this.out("\t\t\tixafntc = new HashMap();");
        this.out("");
        this.out("\t\tjava.lang.Class cls = (java.lang.Class) ixafntc.get(xmiName);");
        this.out("");
        this.out("\t\tif (cls == null) {");
        this.out("\t\t\tif (ixafntcn == null)");
        this.out("\t\t\t\tinit();");
        this.out("");
        this.out("\t\t\tString name = (String) ixafntcn.get(xmiName);");
        this.out("");
        this.out("\t\t\ttry {");
        this.out("\t\t\t\tif (name != null)");
        this.out("\t\t\t\t\tcls = java.lang.Class.forName(name);");
        this.out("\t\t\t}");
        this.out("\t\t\tcatch (ClassNotFoundException e) {}");
        this.out("");
        this.out("\t\t\tif (cls != null)");
        this.out("\t\t\t\tixafntc.put(xmiName, cls);");
        this.out("\t\t}");
        this.out("");
        this.out("\t\tif (cls == null)");
        this.out("\t\t\treturn super.makeXMIObject(xmiName);");
        this.out("\t\telse {");
        this.out("\t\t\tjava.lang.Object o = null;");
        this.out("");
        this.out("\t\t\ttry {");
        this.out("\t\t\t\to = cls.newInstance();");
        this.out("\t\t\t}");
        this.out("\t\t\tcatch (Exception e) {}");
        this.out("");
        this.out("\t\t\treturn (XMIObject) o;");
        this.out("\t\t}");
        this.out("\t}\n");
        if (this.namespaces.size() > 0) {
            this.out("\tpublic XMIObject makeXMIObject(String xmiName, com.ibm.xmi.framework.Namespace n) {");
            this.out("\t\tif (n.getPrefix() == null || n.getPrefix().equals(\"\"))");
            this.out("\t\t\treturn makeXMIObject(xmiName);");
            this.out("\t\telse");
            this.out("\t\t\treturn makeXMIObject(n.getPrefix() + \":\" + xmiName);");
            this.out("\t}\n");
        }
    }

    private String makeFileName(String string) {
        String string2 = string.replace('.', File.separatorChar);
        return this.directory + File.separatorChar + string2 + ".java";
    }

    private void makeImplementation(XMIClass xMIClass) {
        String string = "";
        if (this.topPackage != null) {
            string = string + this.topPackage + ".";
        }
        string = this.ignorePackages ? string + this.defsToNames.get(xMIClass) : string + this.getFullName(xMIClass);
        if (this.interfaces) {
            string = string + "Impl";
        }
        this.setFile(string);
        this.processDecl(xMIClass, true);
        this.processConstructors(xMIClass);
        this.processProperties(xMIClass, true);
        this.processLinks(xMIClass, true);
        this.processEnd(xMIClass, true);
        this.endFile();
    }

    private void makeInterface(XMIClass xMIClass) {
        String string = "";
        if (this.topPackage != null) {
            string = string + this.topPackage + ".";
        }
        string = this.ignorePackages ? string + this.defsToNames.get(xMIClass) : string + this.getFullName(xMIClass);
        this.setFile(string);
        this.processDecl(xMIClass, false);
        this.processProperties(xMIClass, false);
        this.processLinks(xMIClass, false);
        this.processEnd(xMIClass, false);
        this.endFile();
    }

    public void makeJava(String string, String string2, Vector vector) {
        if (vector == null) {
            return;
        }
        if (this.report != null) {
            try {
                this.reportfos = new FileOutputStream(this.report);
                this.reportosw = new OutputStreamWriter(this.reportfos);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.directory = string;
        this.topPackage = string2;
        this.getClasses(vector);
        this.computeFeatureConflicts();
        this.computeClassNames(vector);
        Enumeration enumeration = this.classes.elements();
        while (enumeration.hasMoreElements()) {
            XMIClass xMIClass = (XMIClass)enumeration.nextElement();
            if (this.interfaces) {
                this.makeInterface(xMIClass);
            }
            this.makeImplementation(xMIClass);
        }
        this.makeFactory(vector);
        if (this.report != null) {
            try {
                this.reportosw.close();
                this.reportfos.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void out(String string) {
        try {
            this.os.write(string, 0, string.length());
            this.os.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reportOut(String string) {
        try {
            this.reportosw.write(string, 0, string.length());
            this.reportosw.write(10);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String packageName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    private void processBasicProperty(Data data, boolean bl) {
        this.processGetSet(data, this.getJavaType(this.getUMLAttributeType(data)), true, bl);
    }

    private void processConstructors(XMIClass xMIClass) {
        String string = this.topPackage == null ? "UserFactory" : this.topPackage + ".UserFactory";
        this.out("\tprivate com.ibm.xmi.framework.Model getXMIModel() {");
        this.out("\t\t" + string + " f;\n");
        this.out("\t\tif (FactoryRegister.getFactory() instanceof " + string + ")");
        this.out("\t\t\tf = (" + string + ") FactoryRegister.getFactory();");
        this.out("\t\telse");
        this.out("\t\t\tf = new " + string + "();\n");
        this.out("\t\treturn f.getModel();");
        this.out("\t}\n");
        if (!this.interfaces) {
            if (this.ignorePackages) {
                this.out("\tpublic " + this.defsToNames.get(xMIClass) + "() {");
            } else {
                this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "() {");
            }
        } else if (this.ignorePackages) {
            this.out("\tpublic " + this.defsToNames.get(xMIClass) + "Impl() {");
        } else {
            this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "Impl() {");
        }
        this.out("\t\tsuper();");
        this.out("\t\ttry { setXMIName(\"" + this.stripNamespace(xMIClass.getXMIName()) + "\"); } catch (XMIException e) {}");
        this.out("\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        Namespace namespace = xMIClass.getXMINamespace();
        if (namespace == null) {
            this.out("\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(WriterAdapter.CLASS, \"" + this.stripNamespace(xMIClass.getXMIName()) + "\");");
        } else {
            this.out("\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + namespace.getPrefix() + "\", \"" + namespace.getURI() + "\");");
            this.out("\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, WriterAdapter.CLASS, \"" + this.stripNamespace(xMIClass.getXMIName()) + "\", false);");
        }
        this.out("\t\ttry { setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t}\n");
        if (!this.oneConstructor) {
            String string2 = new String();
            Iterator iterator = this.wrapper.getProperties(this.wrapper.getAllFeatures(xMIClass)).iterator();
            if (iterator.hasNext()) {
                Data data;
                while (iterator.hasNext()) {
                    data = (Data)iterator.next();
                    if (string2.length() > 0) {
                        string2 = string2 + ", ";
                    }
                    if (this.wrapper.getType(data) == 8) {
                        String string3 = "";
                        string3 = this.ignorePackages ? (String)this.defsToNames.get(this.wrapper.getFeatureType(data)) : this.getFullName((Data)this.wrapper.getFeatureType(data));
                        string2 = this.topPackage == null ? string2 + string3 : string2 + this.topPackage + "." + string3;
                    } else if (this.wrapper.getType(data) == 6 && this.wrapper.getFeatureType(data) != null && this.wrapper.getXMIName(this.wrapper.getFeatureType(data)).equalsIgnoreCase("boolean")) {
                        string2 = string2 + "boolean";
                    } else if (this.wrapper.getType(data) == 6) {
                        string2 = string2 + "String";
                    } else if (this.wrapper.getType(data) == 7) {
                        string2 = string2 + this.getJavaType(this.getUMLAttributeType(data));
                    }
                    string2 = string2 + " " + this.stripNamespace(this.shortName(data));
                }
                if (!this.interfaces) {
                    if (this.ignorePackages) {
                        this.out("\tpublic " + this.defsToNames.get(xMIClass) + "(" + string2 + ") {");
                    } else {
                        this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "(" + string2 + ") {");
                    }
                } else if (this.ignorePackages) {
                    this.out("\tpublic " + this.defsToNames.get(xMIClass) + "Impl(" + string2 + ") {");
                } else {
                    this.out("\tpublic " + this.stripNamespace(this.shortName(xMIClass)) + "Impl(" + string2 + ") {");
                }
                this.out("\t\tthis();");
                iterator = this.wrapper.getProperties(this.wrapper.getAllFeatures(xMIClass)).iterator();
                while (iterator.hasNext()) {
                    data = (Data)iterator.next();
                    this.out("\t\tset" + this.capName(this.stripNamespace(this.shortName(data))) + "(" + this.stripNamespace(this.shortName(data)) + ");");
                }
                this.out("\t}\n");
            }
        }
    }

    private void processDecl(XMIClass xMIClass, boolean bl) {
        String string = null;
        if (xMIClass.getXMIOwner() != null) {
            string = this.getFullName(xMIClass.getXMIOwner());
        }
        if (this.topPackage != null && string != null) {
            string = this.topPackage + "." + string;
        } else if (this.topPackage != null) {
            string = this.topPackage;
        }
        if (this.ignorePackages) {
            if (this.topPackage != null) {
                this.out("package " + this.topPackage + ";\n");
                this.currentPackage = this.topPackage;
            } else {
                this.currentPackage = "";
            }
        } else {
            if (string != null) {
                this.out("package " + string + ";\n");
            }
            this.currentPackage = string;
        }
        this.out("import com.ibm.xmi.framework.*;");
        this.out("import java.util.*;");
        if (string != null) {
            if (this.topPackage == null) {
                this.out("import UserFactory;");
            } else {
                this.out("import " + this.topPackage + ".UserFactory;");
            }
        }
        this.out("\n");
        String string2 = this.stripNamespace(this.shortName(xMIClass));
        if (this.ignorePackages) {
            string2 = (String)this.defsToNames.get(xMIClass);
        }
        if (this.interfaces && bl) {
            string2 = string2 + "Impl";
        }
        Iterator iterator = xMIClass.getXMISuperclasses().iterator();
        String string3 = new String();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                if (string3.length() > 0) {
                    string3 = string3 + ", ";
                }
                string3 = this.topPackage == null ? string3 + this.shortOrFullName((Data)iterator.next()) : string3 + this.topPackage + "." + this.shortOrFullName((Data)iterator.next());
            }
        } else {
            string3 = bl ? this.mySuperClass : "XMIObject";
        }
        if (bl && !this.interfaces) {
            this.out("public class " + string2 + " extends " + string3 + " {");
        } else if (bl && this.interfaces) {
            if (this.ignorePackages) {
                this.out("public class " + string2 + " extends " + this.mySuperClass + " implements " + this.defsToNames.get(xMIClass) + " {");
            } else {
                this.out("public class " + string2 + " extends " + this.mySuperClass + " implements " + this.stripNamespace(this.shortName(xMIClass)) + " {");
            }
        } else {
            this.out("public interface " + string2 + " extends " + string3 + " {");
        }
    }

    private void processDirectory(String string) {
        File file = new File(string);
        if (file.getParent() == null) {
            return;
        }
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
    }

    private void processEnd(XMIClass xMIClass, boolean bl) {
        if (bl && this.interfaces && this.ignorePackages) {
            this.out("} // " + this.defsToNames.get(xMIClass) + "Impl");
        } else if (bl && this.interfaces) {
            this.out("} // " + this.stripNamespace(xMIClass.getXMIName()) + "Impl");
        } else if (this.ignorePackages) {
            this.out("} // " + this.defsToNames.get(xMIClass));
        } else {
            this.out("} // " + this.stripNamespace(xMIClass.getXMIName()));
        }
    }

    private void processGetSet(Data data, String string, boolean bl, boolean bl2) {
        String string2 = this.stripNamespace(this.shortName(data));
        if (this.duplicateFeatureNames.contains(string2)) {
            string2 = this.duplicateName(data);
        }
        String string3 = this.capName(string2);
        String string4 = data.getXMIName();
        String string5 = "";
        if (!string.equals("String")) {
            string5 = this.capName(string);
        }
        if (this.topPackage != null && !bl) {
            string = this.topPackage + "." + string;
        }
        if (!bl2) {
            if (!string.equals("boolean")) {
                this.out("\tpublic " + this.shortOrFullName(string) + " get" + string3 + "();");
            } else {
                this.out("\tpublic " + this.shortOrFullName(string) + " is" + string3 + "();");
            }
            this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string) + " value);\n");
            return;
        }
        if (!string.equals("boolean")) {
            this.out("\tpublic " + this.shortOrFullName(string) + " get" + string3 + "() {");
        } else {
            this.out("\tpublic " + this.shortOrFullName(string) + " is" + string3 + "() {");
        }
        if (data instanceof Feature) {
            if (bl) {
                if (string.equals("int")) {
                    this.out("\t\treturn Integer.valueOf((String) getXMIValueOfValue(\"" + string4 + "\")).intValue();");
                } else if (string.equals("float")) {
                    this.out("\t\treturn Float.valueOf((String) getXMIValueOfValue(\"" + string4 + "\")).floatValue();");
                } else if (string.equals("boolean")) {
                    this.out("\t\treturn Boolean.valueOf((String) getXMIValueOfValue(\"" + string4 + "\")).booleanValue();");
                } else {
                    this.out("\t\treturn (String) getXMIValueOfValue(\"" + string4 + "\");");
                }
            } else {
                this.out("\t\treturn (" + this.shortOrFullName(string) + ") getXMIValueOfValue(\"" + string4 + "\");");
            }
        }
        this.out("\t}\n");
        this.out("\tpublic void set" + string3 + "(" + this.shortOrFullName(string) + " value) {");
        if (data instanceof Feature) {
            if (this.isJavaType(data) && !string.equals("String") && !string.equals("boolean")) {
                this.out("\t\tcom.ibm.xmi.framework.Value p = setXMIValue(\"" + string4 + "\", String.valueOf(value), Value.DATA);\n");
            } else if (string.equals("String") && this.wrapper.getType(data) == 6) {
                this.out("\t\tcom.ibm.xmi.framework.Value p = setXMIValue(\"" + string4 + "\", value, Value.ENUM);\n");
            } else if (!string.equals("String") && this.wrapper.getType(data) == 6) {
                this.out("\t\tcom.ibm.xmi.framework.Value p = setXMIValue(\"" + string4 + "\", String.valueOf(value), Value.ENUM);\n");
            } else if (string.equals("String")) {
                this.out("\t\tcom.ibm.xmi.framework.Value p = setXMIValue(\"" + string4 + "\", value, Value.DATA);\n");
            } else {
                this.out("\t\tcom.ibm.xmi.framework.Value p = setXMIValue(\"" + string4 + "\", value, Value.OBJECT);\n");
            }
        }
        this.out("\t\tif (p.getXMIDefiner() == null) {");
        this.out("\t\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        if (data.getXMINamespace() == null) {
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(getXMIDefiner(), \"" + string4 + "\");");
        } else {
            this.out("\t\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + data.getXMINamespace().getPrefix() + "\", \"" + data.getXMINamespace().getURI() + "\");");
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, getXMIDefiner(), \"" + this.stripNamespace(string4) + "\", false);");
        }
        this.out("\t\t\ttry { p.setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t\t}");
        this.out("\t}\n");
    }

    private void processLink(Data data, boolean bl) {
        String string = this.stripNamespace(this.shortName(data));
        if (this.duplicateFeatureNames.contains(string)) {
            string = this.duplicateName(data);
        }
        String string2 = this.capName(string);
        String string3 = this.getFullName((Data)this.wrapper.getFeatureType(data));
        String string4 = this.stripNamespace(data.getXMIName());
        if (this.ignorePackages) {
            string3 = (String)this.defsToNames.get(this.wrapper.getFeatureType(data));
        }
        if (this.topPackage != null) {
            string3 = this.topPackage + "." + string3;
        }
        if (!bl) {
            this.out("\tpublic Collection get" + string2 + "();");
            this.out("\tpublic void add" + string2 + "(" + this.shortOrFullName(string3) + " object);");
            this.out("\tpublic void remove" + string2 + "(" + this.shortOrFullName(string3) + " object);\n");
            return;
        }
        if (data instanceof Feature) {
            this.out("\tpublic Collection get" + string2 + "() {");
            this.out("\t\tjava.lang.Object v = getXMIValueOfValue(\"" + string4 + "\");");
            this.out("\t\tif (v instanceof java.util.Collection)");
            this.out("\t\t\treturn (Collection) v;");
            this.out("\t\tArrayList l = new ArrayList(1);");
            this.out("\t\tif (v instanceof XMIObject)");
            this.out("\t\t\tl.add(v);");
            this.out("\t\treturn l;");
            this.out("\t}\n");
        }
        this.out("\tpublic void add" + string2 + "(" + this.shortOrFullName(string3) + " object) {");
        if (data instanceof Feature) {
            int n = this.wrapper.getType(data);
            String string5 = "";
            if (n == 2) {
                string5 = "Value.REFERENCE";
            } else if (n == 3) {
                string5 = "Value.CONTAINER";
            } else if (n == 4) {
                string5 = "Value.CONTAINED";
            } else if (n == 8) {
                string5 = "Value.OBJECT";
            }
            this.out("\t\tcom.ibm.xmi.framework.Value l = addXMIValue(\"" + string4 + "\", object, " + string5 + ");\n");
        }
        this.out("\t\tif (l.getXMIDefiner() == null) {");
        this.out("\t\t\tcom.ibm.xmi.framework.Model m = getXMIModel();");
        if (data.getXMINamespace() == null) {
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(getXMIDefiner(), \"" + string4 + "\");");
        } else {
            this.out("\t\t\tcom.ibm.xmi.framework.Namespace n = new com.ibm.xmi.framework.Namespace(\"" + data.getXMINamespace().getPrefix() + "\", \"" + data.getXMINamespace().getURI() + "\");");
            this.out("\t\t\tcom.ibm.xmi.framework.Data definer = m.getDeclaration(n, getXMIDefiner(), \"" + string4 + "\", false);");
        }
        this.out("\t\t\ttry { l.setXMIDefiner(definer); } catch (XMIException e) {};");
        this.out("\t\t}");
        this.out("\t}\n");
        this.out("\tpublic void remove" + string2 + "(" + this.shortOrFullName(string3) + " object) {");
        if (data instanceof Feature) {
            this.out("\t\tjava.lang.Object v = getXMIValueOfValue(\"" + string4 + "\");");
            this.out("\t\tif (v == object)");
            this.out("\t\t\ttry { delete(getXMIValue(\"" + string4 + "\")); } catch (XMIException e) {};");
            this.out("\t\tif (v instanceof Collection) {");
            this.out("\t\t\t((Collection) v).remove(object);");
            this.out("\t\t\tif (((Collection) v).size() == 0)");
            this.out("\t\t\t\ttry { delete(getXMIValue(\"" + string4 + "\")); } catch (XMIException e) {};");
            this.out("\t\t}");
        }
        this.out("\t}\n");
    }

    private void processLinks(XMIClass xMIClass, boolean bl) {
        Data data;
        Object object;
        Vector vector = new Vector(5);
        if (bl && this.interfaces) {
            object = this.wrapper.getLinks(this.wrapper.getAllFeatures(xMIClass)).iterator();
            while (object.hasNext()) {
                vector.addElement(object.next());
            }
        } else {
            object = xMIClass.getXMIFeatures().iterator();
            while (object.hasNext()) {
                data = (Feature)object.next();
                if (data.getXMIValueType() != 2 && data.getXMIValueType() != 3 && data.getXMIValueType() != 4) continue;
                vector.addElement(data);
            }
        }
        if (vector != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                data = (Data)object.nextElement();
                this.processLink(data, bl);
            }
            this.out("");
        }
    }

    private void processObjectProperty(Data data, boolean bl) {
        String string;
        if (data instanceof Feature && (string = ((Feature)data).getXMIMultiplicity()) != null) {
            if (string.equals("0..*") || string.equals("0..n") || string.equals("*") || string.equals("n")) {
                this.processLink(data, bl);
            }
            return;
        }
        string = this.getFullName((Data)this.wrapper.getFeatureType(data));
        if (this.ignorePackages) {
            string = (String)this.defsToNames.get((Data)this.wrapper.getFeatureType(data));
        }
        this.processGetSet(data, string, false, bl);
    }

    private void processProperties(XMIClass xMIClass, boolean bl) {
        Iterator iterator = bl && this.interfaces ? this.wrapper.getProperties(this.wrapper.getAllFeatures(xMIClass)).iterator() : this.wrapper.getProperties(this.wrapper.getFeatures(xMIClass)).iterator();
        while (iterator.hasNext()) {
            Data data = (Data)iterator.next();
            if (this.wrapper.getType(data) == 6 || this.wrapper.getType(data) == 7) {
                this.processBasicProperty(data, bl);
                continue;
            }
            if (this.wrapper.getType(data) != 8) continue;
            this.processObjectProperty(data, bl);
        }
    }

    private String propType(Data data) {
        int n = this.wrapper.getType(data);
        if (n == 6) {
            return "EnumProperty";
        }
        if (n == 8) {
            return "ObjectProperty";
        }
        return "BasicProperty";
    }

    private void setFile(String string) {
        File file;
        String string2 = this.makeFileName(string);
        this.processDirectory(string2);
        File file2 = new File(string2);
        if (file2.getParent() != null && !(file = new File(file2.getParent())).exists()) {
            file.mkdirs();
        }
        try {
            this.fs = new FileOutputStream(string2);
            this.os = new OutputStreamWriter(this.fs);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setIgnorePackages(boolean bl) {
        this.ignorePackages = bl;
    }

    public void setInterfaces(boolean bl) {
        this.interfaces = bl;
    }

    private void setModelName(String string) {
        this.modelName = string;
    }

    private void setOneConstructor(boolean bl) {
        this.oneConstructor = bl;
    }

    private void setReport(String string) {
        this.report = string;
    }

    private void setNamespaceName(String string) {
    }

    private void setNamespaceURI(String string) {
    }

    private void setSuperClass(String string) {
        this.mySuperClass = string;
    }

    private String shortOrFullName(Data data) {
        if (this.ignorePackages) {
            return (String)this.defsToNames.get(data);
        }
        return this.shortOrFullName(this.stripNamespace(this.getFullName(data)));
    }

    private String shortOrFullName(String string) {
        if (this.currentPackage == null || !this.currentPackage.equals("") && this.currentPackage.equals(this.packageName(string))) {
            return this.shortName(string);
        }
        return string;
    }

    private String shortName(Data data) {
        return this.shortName(data.getXMIName());
    }

    private String shortName(String string) {
        int n = (string = string.trim()).lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }
}

