/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.diagram.draw.helper;

import com.baselet.diagram.draw.helper.StyleException;
import java.util.HashMap;

public class ColorOwn {
    public static final String EXAMPLE_TEXT = "color string (green,...) or code (#3c7a00,...)";
    public static final ColorOwn RED = new ColorOwn(255, 0, 0, Transparency.FOREGROUND);
    public static final ColorOwn GREEN = new ColorOwn(0, 255, 0, Transparency.FOREGROUND);
    public static final ColorOwn BLUE = new ColorOwn(0, 0, 255, Transparency.FOREGROUND);
    public static final ColorOwn YELLOW = new ColorOwn(255, 255, 0, Transparency.FOREGROUND);
    public static final ColorOwn MAGENTA = new ColorOwn(255, 0, 255, Transparency.FOREGROUND);
    public static final ColorOwn WHITE = new ColorOwn(255, 255, 255, Transparency.FOREGROUND);
    public static final ColorOwn BLACK = new ColorOwn(0, 0, 0, Transparency.FOREGROUND);
    public static final ColorOwn ORANGE = new ColorOwn(255, 165, 0, Transparency.FOREGROUND);
    public static final ColorOwn CYAN = new ColorOwn(0, 255, 255, Transparency.FOREGROUND);
    public static final ColorOwn DARK_GRAY = new ColorOwn(70, 70, 70, Transparency.FOREGROUND);
    public static final ColorOwn GRAY = new ColorOwn(120, 120, 120, Transparency.FOREGROUND);
    public static final ColorOwn LIGHT_GRAY = new ColorOwn(200, 200, 200, Transparency.FOREGROUND);
    public static final ColorOwn PINK = new ColorOwn(255, 175, 175, Transparency.FOREGROUND);
    public static final ColorOwn TRANSPARENT = WHITE.transparency(Transparency.FULL_TRANSPARENT);
    public static final ColorOwn SELECTION_FG = BLUE;
    public static final ColorOwn SELECTION_BG = new ColorOwn(0, 0, 255, Transparency.SELECTION_BACKGROUND);
    public static final ColorOwn STICKING_POLYGON = new ColorOwn(100, 180, 255, Transparency.FOREGROUND);
    public static final ColorOwn SYNTAX_HIGHLIGHTING = new ColorOwn(0, 100, 255, Transparency.FOREGROUND);
    public static final ColorOwn DEFAULT_FOREGROUND = BLACK;
    public static final ColorOwn DEFAULT_BACKGROUND = TRANSPARENT;
    public static final HashMap<String, ColorOwn> COLOR_MAP = new HashMap();
    private final int red;
    private final int green;
    private final int blue;
    private final int alpha;

    public ColorOwn(int n, int n2, int n3, Transparency transparency) {
        this(n, n2, n3, transparency.getAlpha());
    }

    public ColorOwn(int n, int n2, int n3, int n4) {
        this.red = n;
        this.green = n2;
        this.blue = n3;
        this.alpha = n4;
    }

    public ColorOwn(String string) {
        int n = Integer.decode(string);
        this.red = n >> 16 & 0xFF;
        this.green = n >> 8 & 0xFF;
        this.blue = n & 0xFF;
        this.alpha = Transparency.FOREGROUND.getAlpha();
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public ColorOwn transparency(Transparency transparency) {
        return this.transparency(transparency.getAlpha());
    }

    public ColorOwn transparency(int n) {
        return new ColorOwn(this.getRed(), this.getGreen(), this.getBlue(), n);
    }

    public ColorOwn darken(int n) {
        return new ColorOwn(Math.max(0, this.getRed() - n), Math.max(0, this.getGreen() - n), Math.max(0, this.getBlue() - n), this.getAlpha());
    }

    public static ColorOwn forStringOrNull(String string, Transparency transparency) {
        try {
            return ColorOwn.forString(string, transparency);
        }
        catch (StyleException styleException) {
            return null;
        }
    }

    public static ColorOwn forString(String string, Transparency transparency) {
        boolean bl = false;
        ColorOwn colorOwn = null;
        if (string == null) {
            bl = true;
        } else {
            for (String string2 : COLOR_MAP.keySet()) {
                if (!string.equalsIgnoreCase(string2)) continue;
                colorOwn = COLOR_MAP.get(string2);
                break;
            }
            if (colorOwn == null) {
                try {
                    colorOwn = new ColorOwn(string);
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            }
            if (colorOwn != null) {
                colorOwn = colorOwn.transparency(transparency);
            }
        }
        if (bl) {
            throw new StyleException("value must be a color string (green,...) or code (#3c7a00,...)");
        }
        return colorOwn;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.alpha;
        n = 31 * n + this.blue;
        n = 31 * n + this.green;
        n = 31 * n + this.red;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ColorOwn colorOwn = (ColorOwn)object;
        if (this.alpha != colorOwn.alpha) {
            return false;
        }
        if (this.blue != colorOwn.blue) {
            return false;
        }
        if (this.green != colorOwn.green) {
            return false;
        }
        return this.red == colorOwn.red;
    }

    public String toString() {
        return "ColorOwn [red=" + this.red + ", green=" + this.green + ", blue=" + this.blue + ", alpha=" + this.alpha + "]";
    }

    static {
        COLOR_MAP.put("black", BLACK);
        COLOR_MAP.put("blue", BLUE);
        COLOR_MAP.put("cyan", CYAN);
        COLOR_MAP.put("dark_gray", DARK_GRAY);
        COLOR_MAP.put("gray", GRAY);
        COLOR_MAP.put("green", GREEN);
        COLOR_MAP.put("light_gray", LIGHT_GRAY);
        COLOR_MAP.put("magenta", MAGENTA);
        COLOR_MAP.put("orange", ORANGE);
        COLOR_MAP.put("pink", PINK);
        COLOR_MAP.put("red", RED);
        COLOR_MAP.put("white", WHITE);
        COLOR_MAP.put("yellow", YELLOW);
    }

    public static enum Transparency {
        FOREGROUND(255),
        FULL_TRANSPARENT(0),
        BACKGROUND(125),
        SELECTION_BACKGROUND(20);

        private int alpha;

        private Transparency(int n2) {
            this.alpha = n2;
        }

        public int getAlpha() {
            return this.alpha;
        }
    }
}

