/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.basics.geom.PointDouble;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.StickLineChange;
import com.baselet.element.sticking.Stickable;
import com.baselet.element.sticking.StickableMap;
import com.baselet.element.sticking.StickingPolygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Stickables {
    private static Logger log = Logger.getLogger(Stickables.class);

    public static StickableMap getStickingPointsWhichAreConnectedToStickingPolygon(StickingPolygon stickingPolygon, Collection<? extends Stickable> collection) {
        int n = 9;
        log.debug((Object)("Polygon to check: " + stickingPolygon));
        StickableMap stickableMap = new StickableMap();
        for (Stickable stickable : collection) {
            for (PointDoubleIndexed pointDoubleIndexed : stickable.getStickablePoints()) {
                PointDouble pointDouble = Stickables.getAbsolutePosition(stickable, pointDoubleIndexed);
                for (StickingPolygon.StickLine stickLine : stickingPolygon.getStickLines()) {
                    log.trace((Object)("CHECK " + stickLine + "/" + pointDouble + "/" + n));
                    if (!stickLine.isConnected(pointDouble, n)) continue;
                    stickableMap.add(stickable, pointDoubleIndexed);
                }
            }
        }
        return stickableMap;
    }

    public static Map<Stickable, List<PointChange>> moveStickPointsBasedOnPolygonChanges(StickingPolygon stickingPolygon, StickingPolygon stickingPolygon2, StickableMap stickableMap, int n) {
        if (stickingPolygon == null || stickableMap == null || stickableMap.isEmpty()) {
            return Collections.emptyMap();
        }
        List<StickLineChange> list = Stickables.getChangedStickLines(stickingPolygon, stickingPolygon2);
        HashMap<Stickable, List<PointChange>> hashMap = new HashMap<Stickable, List<PointChange>>();
        for (Stickable stickable : stickableMap.getStickables()) {
            List<PointChange> list2 = Stickables.calculateStickingPointChanges(stickable, stickableMap.getStickablePoints(stickable), list, n);
            if (list2.isEmpty()) continue;
            hashMap.put(stickable, list2);
        }
        Stickables.applyChanges(hashMap, stickableMap);
        return hashMap;
    }

    public static void applyChanges(Map<Stickable, List<PointChange>> map, StickableMap stickableMap) {
        for (Map.Entry<Stickable, List<PointChange>> entry : map.entrySet()) {
            Stickable stickable = entry.getKey();
            List<PointDoubleIndexed> list = stickable.movePoints(entry.getValue());
            if (stickableMap == null) continue;
            stickableMap.setStickablePoints(stickable, list);
        }
    }

    private static List<StickLineChange> getChangedStickLines(StickingPolygon stickingPolygon, StickingPolygon stickingPolygon2) {
        ArrayList<StickLineChange> arrayList = new ArrayList<StickLineChange>();
        Iterator<StickingPolygon.StickLine> iterator = stickingPolygon.getStickLines().iterator();
        Iterator<StickingPolygon.StickLine> iterator2 = stickingPolygon2.getStickLines().iterator();
        while (iterator.hasNext()) {
            StickingPolygon.StickLine stickLine;
            StickingPolygon.StickLine stickLine2 = iterator.next();
            if (stickLine2.equals(stickLine = iterator2.next())) continue;
            arrayList.add(new StickLineChange(stickLine2, stickLine));
        }
        return arrayList;
    }

    private static List<PointChange> calculateStickingPointChanges(Stickable stickable, List<PointDoubleIndexed> list, List<StickLineChange> list2, int n) {
        ArrayList<PointChange> arrayList = new ArrayList<PointChange>();
        for (PointDoubleIndexed pointDoubleIndexed : list) {
            PointChange pointChange;
            PointDouble pointDouble = Stickables.getAbsolutePosition(stickable, pointDoubleIndexed);
            StickLineChange stickLineChange = Stickables.getNearestStickLineChangeWhichWillChangeTheStickPoint(list2, pointDouble, n);
            if (stickLineChange == null || (pointChange = Stickables.calcPointDiffBasedOnStickLineChange(pointDoubleIndexed.getIndex(), pointDouble, stickLineChange)).getDiffX() == 0 && pointChange.getDiffY() == 0) continue;
            arrayList.add(pointChange);
        }
        return arrayList;
    }

    static PointChange calcPointDiffBasedOnStickLineChange(Integer n, PointDouble pointDouble, StickLineChange stickLineChange) {
        StickingPolygon.StickLine stickLine = stickLineChange.getOld();
        StickingPolygon.StickLine stickLine2 = stickLineChange.getNew();
        int n2 = 0;
        int n3 = 0;
        if (stickLine2.getDirectionOfLine(true).isHorizontal()) {
            n3 = stickLine2.getStart().getY().intValue() - stickLine.getStart().getY().intValue();
            n2 = Stickables.calcOtherCoordinate(pointDouble, stickLine, stickLine2, 0, n3).getX().intValue();
        } else {
            n2 = stickLine2.getStart().getX().intValue() - stickLine.getStart().getX().intValue();
            n3 = Stickables.calcOtherCoordinate(pointDouble, stickLine, stickLine2, n2, 0).getY().intValue();
        }
        return new PointChange(n, n2, n3);
    }

    private static PointDouble calcOtherCoordinate(PointDouble pointDouble, StickingPolygon.StickLine stickLine, StickingPolygon.StickLine stickLine2, int n, int n2) {
        PointDouble pointDouble2 = new PointDouble(pointDouble.getX() + (double)n, pointDouble.getY() + (double)n2);
        if (stickLine.getLength() == stickLine2.getLength()) {
            return new PointDouble(stickLine2.getStart().getX().intValue() - stickLine.getStart().getX().intValue(), stickLine2.getStart().getY().intValue() - stickLine.getStart().getY().intValue());
        }
        if (stickLine2.getDistanceToPoint(pointDouble2) > 1.0) {
            PointDouble pointDouble3 = stickLine2.getStart().distance(pointDouble2) < stickLine2.getEnd().distance(pointDouble2) ? stickLine2.getStart() : stickLine2.getEnd();
            return new PointDouble(pointDouble3.getX() - pointDouble.getX(), pointDouble3.getY() - pointDouble.getY());
        }
        return new PointDouble(0.0, 0.0);
    }

    private static StickLineChange getNearestStickLineChangeWhichWillChangeTheStickPoint(List<StickLineChange> list, PointDouble pointDouble, int n) {
        Double d = null;
        StickLineChange stickLineChange = null;
        for (StickLineChange stickLineChange2 : list) {
            double d2 = stickLineChange2.getOld().getDistanceToPoint(pointDouble);
            if (!(d2 < (double)n) || d != null && !(d2 < d)) continue;
            d = d2;
            stickLineChange = stickLineChange2;
        }
        return stickLineChange;
    }

    private static PointDouble getAbsolutePosition(Stickable stickable, PointDouble pointDouble) {
        int n = stickable.getRealRectangle().getX() + pointDouble.getX().intValue();
        int n2 = stickable.getRealRectangle().getY() + pointDouble.getY().intValue();
        return new PointDouble(n, n2);
    }
}

