/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator.java.jp;

import com.baselet.generator.java.Field;
import com.baselet.generator.java.JavaClass;
import com.baselet.generator.java.Method;
import com.baselet.generator.java.jp.ClassParserException;
import com.baselet.generator.java.jp.JpConstructor;
import com.baselet.generator.java.jp.JpField;
import com.baselet.generator.java.jp.JpMethod;
import japa.parser.JavaParser;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.TypeDeclaration;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class JpJavaClass
implements JavaClass {
    private final Logger log = Logger.getLogger(JpJavaClass.class);
    private CompilationUnit cu;
    private final List<MethodDeclaration> methods = new ArrayList<MethodDeclaration>();
    private final List<ConstructorDeclaration> constructors = new ArrayList<ConstructorDeclaration>();
    private ClassOrInterfaceDeclaration clazz;
    private final List<FieldDeclaration> fields = new ArrayList<FieldDeclaration>();

    public JpJavaClass(String filename) throws ClassParserException {
        FileInputStream in = null;
        try {
            try {
                in = new FileInputStream(filename);
                this.cu = JavaParser.parse((InputStream)in);
            }
            catch (Exception e) {
                throw new ClassParserException("Javaparser library failed to parse " + filename, e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"Exception at Java class parsing", (Throwable)e);
            }
        }
        this.extractInformation(filename);
    }

    private void extractInformation(String filename) throws ClassParserException {
        List types = this.cu.getTypes();
        for (TypeDeclaration type : types) {
            if (type instanceof ClassOrInterfaceDeclaration) {
                this.clazz = (ClassOrInterfaceDeclaration)type;
            }
            List members = type.getMembers();
            for (BodyDeclaration member : members) {
                if (member instanceof FieldDeclaration) {
                    this.fields.add((FieldDeclaration)member);
                    continue;
                }
                if (member instanceof ConstructorDeclaration) {
                    this.constructors.add((ConstructorDeclaration)member);
                    continue;
                }
                if (!(member instanceof MethodDeclaration)) continue;
                this.methods.add((MethodDeclaration)member);
            }
        }
        if (this.clazz == null) {
            throw new ClassParserException("Could not successfully parse " + filename + ".");
        }
    }

    @Override
    public String getName() {
        return this.clazz.getName().toString();
    }

    @Override
    public Field[] getFields() {
        Field[] newFields = new Field[this.fields.size()];
        int i = 0;
        for (FieldDeclaration field : this.fields) {
            newFields[i] = new JpField(field);
            ++i;
        }
        return newFields;
    }

    @Override
    public Method[] getMethods() {
        Method[] newMethods = new Method[this.methods.size() + this.constructors.size()];
        int i = 0;
        for (ConstructorDeclaration constructor : this.constructors) {
            newMethods[i] = new JpConstructor(constructor);
            ++i;
        }
        for (MethodDeclaration method : this.methods) {
            newMethods[i] = new JpMethod(method);
            ++i;
        }
        return newMethods;
    }

    @Override
    public JavaClass.ClassRole getRole() {
        if (this.clazz.isInterface()) {
            return JavaClass.ClassRole.INTERFACE;
        }
        if ((this.clazz.getModifiers() & 0x400) != 0) {
            return JavaClass.ClassRole.ABSTRACT;
        }
        return JavaClass.ClassRole.CLASS;
    }

    @Override
    public String getPackage() {
        PackageDeclaration packageDecl = this.cu.getPackage();
        if (packageDecl == null) {
            return "";
        }
        String packageWithExtra = packageDecl.toString().replace("package ", "");
        return packageWithExtra.substring(0, packageWithExtra.lastIndexOf(";"));
    }
}

